/**
 * JS showing detailed infos about user's approval status for group approvals in a modal window
 *
 * @module        mod_openbook/groupapprovalstatus
 * @author        University of Geneva, E-Learning Team
 * @author        Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @copyright     2025 University of Geneva {@link http://www.unige.ch}
 * @license       http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_openbook/groupapprovalstatus",["jquery","core/modal_factory","core/str","core/templates","core/log"],(function($,ModalFactory,str,templates,log){var instance=new function(){this.id=""};return instance.initializer=function(config){instance.id=config.id,instance.mode=config.mode,log.info("Initialize groupapprovalstatus JS!","mod_openbook"),instance.modal||(instance.modalpromise=ModalFactory.create({type:ModalFactory.types.DEFAULT,body:"..."})),str.get_string("filedetails","mod_openbook").done((function(s){log.info("Done loading strings...","mod_openbook"),instance.modalpromise.done((function(modal){log.info("Done preparing modal","mod_openbook"),instance.modal=modal,$(".path-mod-openbook .statustable .approvaldetails *").click((function(e){e.stopPropagation();var approved,rejected,pending,filename,stat,dataelement=$(e.target).parent();try{approved=dataelement.data("approved")}catch(ex){approved=[]}try{rejected=dataelement.data("rejected")}catch(ex){rejected=[]}try{pending=dataelement.data("pending")}catch(ex){pending=[]}try{filename=s+" "+dataelement.data("filename")}catch(ex){filename=s}try{stat=dataelement.data("status")}catch(ex){stat={approved:!1,rejected:!1,pending:!1}}var context={id:instance.id,mode:instance.mode,status:stat,approved:approved,rejected:rejected,pending:pending};templates.render("mod_openbook/approvaltooltip",context).done((function(source){instance.modal.setTitle(filename),instance.modal.setBody(source),instance.modal.show()})).fail((function(ex){instance.modal.setBody(ex.message),instance.modal.show()}))})),$(".path-mod-openbook .statustable .approvaldetails").fadeIn("slow")}))})).fail((function(ex){log.error("Error getting strings: "+ex,"mod_openbook")}))},instance}));

//# sourceMappingURL=groupapprovalstatus.min.js.map