<?php
// This file is part of mod_openbook for Moodle - http://moodle.org/
//
// It is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// It is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'openbook', language 'en'
 *
 * @package       mod_openbook
 * @author        University of Geneva, E-Learning Team
 * @author        Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @copyright     2025 University of Geneva {@link http://www.unige.ch}
 * @license       http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// Let codechecker ignore some sniffs for this file as it is perfectly well ordered, just not alphabetically.
// phpcs:disable moodle.Files.LangFilesOrdering.UnexpectedComment
// phpcs:disable moodle.Files.LangFilesOrdering.IncorrectOrder

$string['sharedfilesnotshowing'] = 'Shared files table is hidden because files are personal.';

$string['availabilityrestriction'] = 'Apply availability restrictions to user list';
$string['availabilityrestriction_admin'] = 'Default setting for availability restrictions to user list';
$string['availabilityrestriction_help'] = 'Users who cannot access the activity due to availability restrictions will be removed from the list.<br>This only includes conditions which are marked as being applied to user lists. For example, group conditions are included but date conditions are not included.';
$string['availabilityrestriction_admin_desc'] = 'Users who cannot access the activity due to availability restrictions will be removed from the list.<br>This only includes conditions which are marked as being applied to user lists. For example, group conditions are included but date conditions are not included.';
$string['modulename'] = 'Openbook resource folder';
$string['pluginname'] = 'Openbook resource folder';
$string['modulename_help'] = '###### Key features
- Allows students to upload files within a teacher-defined submission period
- Supports automatic or approval-based publishing of files, with optional student sharing settings
- Sends notifications to students and teachers about uploads and status changes
- Enables secure display of documents in a Moodle "secure window" for controlled access
- Offers PDF.js integration for viewing PDF files directly in the browser

###### Ways to use it
- Collect student documents for later access during exams or assignments
- Share resources among students with optional approval workflows
- Restrict document access to secure mode for high-stakes assessments
- Provide a central repository for student submissions with flexible visibility settings
- Facilitate collaborative resource sharing while maintaining teacher control';
$string['modulename_summary'] = 'Allows students to upload and share files in a central course space with flexible approval workflows and then provide secure viewing options, for example during exams.';
$string['eventopenbookfiledeleted'] = 'Openbook resource folder file deleted';
$string['eventopenbookfileuploaded'] = 'Openbook resource folder file uploaded';
$string['eventopenbookduedateextended'] = 'Openbook resource folder due-date extended';
$string['eventopenbookapprovalchanged'] = 'Openbook resource folder file approval changed';

$string['modulenameplural'] = 'Openbook resource folders';
$string['pluginadministration'] = 'Openbook resource folder folder administration';
$string['openbook:addinstance'] = 'Add a new Openbook resource folder';
$string['openbook:view'] = 'View Openbook resource folder';
$string['openbook:upload'] = 'Upload files to a Openbook resource folder';
$string['openbook:uploadcommonteacherfile'] = 'Upload teacher files that are visible to everybody to a Openbook resource folder';
$string['openbook:approve'] = 'Decide if files should be published (visible for all participants)';
$string['openbook:grantextension'] = 'Grant extension';
$string['openbook:manageoverrides'] = 'Manage overrides';
$string['openbook:receiveteachernotification'] = 'Receive notifications for teachers';
$string['search:activity'] = 'Openbook resource folder - activity information';

$string['messageprovider:openbook_updates'] = 'Openbook resource folder notifications';

$string['notifications'] = 'Notifications';
$string['notifyteacher'] = 'Notify teachers about submitted files';
$string['notifystudents'] = 'Notify students about Openbook resource folder changes';
$string['notifyteacher_help'] = 'If enabled, teachers will receive a notification when students upload a file.';
$string['notifystudents_help'] = 'If enabled, students will receive a notification when the Openbook resource folder status of one of their uploaded files changes.';

$string['notify:setting:0'] = 'No notifications';
$string['notify:setting:1'] = 'Teachers only';
$string['notify:setting:2'] = 'Students only';
$string['notify:setting:3'] = 'Both teachers and students';
$string['notify:statuschange'] = 'Notifications about Openbook resource folder status changes';
$string['notify:statuschange_help'] = ' Depends on the setting, if enabled, students and/or teachers will receive a notification when the Openbook resource folder status of one of the files is changed.';
$string['notify:statuschange_admin'] = 'Default notification setting for Openbook resource folder status changes';
$string['notify:filechange'] = 'Notifications about submitted files';
$string['notify:filechange_help'] = 'Depends on the setting, if enabled, students and/or teachers will receive a notification when students upload or change a file.';
$string['notify:filechange_admin'] = 'Default notification setting for file changes';

$string['email:statuschange:header'] = 'The Openbook resource folder status of the following file(s) for <b>\'{$a->openbook}\'</b> was changed on {$a->dayupdated} at {$a->timeupdated} by <b>{$a->username}</b>:<br /><ul>';
$string['email:statuschange:filename'] = '<li>\'{$a->filename}\' to \'<b>{$a->apstatus}</b>\'</li>';
$string['email:statuschange:footer'] = '</ul>';
$string['email:statuschange:subject'] = 'Openbook resource folder status changed';
$string['email:filechange_upload:header'] = '<b>{$a->username}</b> has uploaded the following file(s) to <b>\'{$a->openbook}\'</b> on {$a->dayupdated} at {$a->timeupdated}:<br /><ul>';
$string['email:filechange_upload:subject'] = 'File(s) uploaded';
$string['email:filechange:footer'] = '</ul><br />Please check if your permission for Openbook resource folder is required.';

$string['uploaded'] = 'Uploaded';
$string['approvalchange'] = 'Openbook resource folder status changed';

$string['approvalsettings'] = 'Openbook resource folder settings';
$string['name'] = 'Name';
$string['obtainstudentapproval'] = 'Student approval';
$string['obtainstudentapproval_admin'] = 'Default student approval setting';
$string['obtainstudentapproval_admin_desc'] = 'This setting determines the default approval setting for students.';
$string['obtainstudentapproval_help'] = 'This option determines how the Openbook resource folder (visibility) of file submissions by student approval takes place: <br><ul><li><strong>Automatic</strong> - no approval from students is required. In the spirit of copyright law, we ask that you request approval to publish files from students in a separate way.</li><li><strong>Required</strong> - Students need to manually approve the file for Openbook resource folder</li></ul>';
$string['saveapproval'] = 'Save changes';

$string['filesarepersonal'] = 'Files are personal';
$string['filesarepersonal_yes'] = 'Yes (files are personal)';
$string['filesarepersonal_no'] = 'No (files can be shared between students)';
$string['filesarepersonal_admin'] = 'Files are personal';
$string['filesarepersonal_admin_desc'] = 'This setting determines the default visibility setting for student files.';
$string['filesarepersonal_help'] = 'This option determines if submitted files remain private to the owner: <br><ul><li><strong>Yes</strong> - files are private and personal.</li><li><strong>No</strong> - Files can be shared between students, if they are approved by needed parties.</li></ul>';

$string['openpdffilesinpdfjs'] = 'Enable PDF.js';
$string['openpdffilesinpdfjs_yes'] = 'Yes';
$string['openpdffilesinpdfjs_no'] = 'No';
$string['openpdffilesinpdfjs_admin'] = 'PDF files are shown with PDF.js viewer';
$string['openpdffilesinpdfjs_admin_desc'] = 'This setting determines the default setting for how PDF documents are displayed.';
$string['openpdffilesinpdfjs_help'] = 'This option determines whether submitted PDF files should be displayed using the PDF.js library.';

$string['uselegacyviewer'] = 'Use legacy PDF.js viewer';
$string['uselegacyviewer_help'] = 'If enabled, will use the legacy PDF.js viewer. Else, modern PDF.js viewer will be used. The legacy viewer is needed when using old browser versions that have trouble displaying PDF files using the modern PDF.js viewer.';
$string['uselegacyviewer_yes'] = 'Yes';
$string['uselegacyviewer_no'] = 'No';

$string['myownfiles'] = 'My own files';

$string['obtainteacherapproval'] = 'Teacher approval';
$string['obtainteacherapproval_help'] = 'This option determines how the Openbook resource folder (visibility) of file submissions by teachers approval takes place: <br><ul><li><strong>Automatic</strong> - no approval from teachers is required.</li><li><strong>Required</strong> - Teachers need to manually approve the file for Openbook resource folder</li></ul>';
$string['obtainteacherapproval_no'] = 'Automatic';
$string['obtainteacherapproval_yes'] = 'Required';
$string['obtainteacherapproval_admin'] = 'Default teacher approval setting';
$string['obtainteacherapproval_admin_desc'] = 'This setting determines the default approval setting for teachers.';
$string['obtainstudentapproval_no'] = 'Automatic';
$string['obtainstudentapproval_yes'] = 'Required';
$string['obtainapproval_automatic'] = 'Automatic';
$string['obtainapproval_required'] = 'Required';

$string['approvalfromdate'] = 'Approval from';
$string['approvalfromdate_help'] = 'Approval status cannot be changed before this date. This setting is only relevant when Student approval is not automatic.';
$string['approvaltodate'] = 'Approval until';
$string['approvaltodate_help'] = 'Approval status cannot be changed after this date. This setting is only relevant when Student approval is not automatic.';
$string['approvaltodatevalidation'] = 'Approval until date must be after the approval from date.';
$string['maxfiles'] = 'Maximum number of attachments';
$string['maxfiles_help'] = 'Each student will be able to upload up to this number of files for their submission.';
$string['configmaxfiles'] = 'Default maximum number of attachments allowed per user.';
$string['maxbytes'] = 'Maximum attachment size';
$string['maxbytes_help'] = 'Files uploaded by students may be up to this size.';
$string['configmaxbytes'] = 'Default maximum size for all files in the openbook resources folder.';
$string['uploadnotopen'] = 'File upload is closed!';

$string['reset_userdata'] = 'All data';

// Strings from the file mod_form.
$string['availability'] = 'Editing period (upload or approval)';
$string['submissionsettings'] = 'Submission settings';
$string['allowsubmissionsfromdate'] = 'Upload from';
$string['allowsubmissionsfromdate_help'] = 'If this option is enabled, participants cannot submit their file submissions before this date. If the option is disabled, participants can start submitting right away.';
$string['allowsubmissionsfromdatesummary'] = 'This assignment will accept submissions from <strong>{$a}</strong>';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'The assignment details and submission form will be available from <strong>{$a}</strong>';
$string['alwaysshowdescription'] = 'Always show description';
$string['alwaysshowdescription_help'] = 'If disabled, the assignment description above will only become visible to students at the "Upload/Approval from" date.';

$string['duedate'] = 'To';
$string['duedate_help'] = 'If this option is enabled, participants cannot submit their file submissions after this date. If the option is disabled, participants can submit forever.';
$string['duedatevalidation'] = 'Due date must be after the allow submissions from date.';

$string['securewindowsettings'] = 'Secure window settings';
$string['securewindowfromdate'] = 'Start secure window';
$string['securewindowfromdate_help'] = 'If this option is enabled, the activity will open in a secure window that hides navigation and offers no links to other parts of Moodle. So, for example, only links to the allowed files will be visible during the a quiz attempt. Secure window starts at the given date.';
$string['securewindowtodate'] = 'End secure window';
$string['securewindowtodate_help'] = 'If this option is enabled, the activity will open in a secure window that hides navigation and offers no links access to other parts of Moodle. So, for example, only links to the allowed files will be visible during the a quiz attempt. Secure window ends at the given date.';
$string['securewindowtodatevalidation'] = 'End date must be after secure window start date.';

$string['courseuploadlimit'] = 'Course upload limit';
$string['allowedfiletypes'] = 'Accepted file types';
$string['allowedfiletypes_help'] = 'Accepted file types can be restricted by entering a comma-separated list of mimetypes, e.g. \'video/mp4, audio/mp3, image/png, image/jpeg\', or file extensions including a dot, e.g. \'.png, .jpg\'. If the field is left empty, then all file types are allowed.';
$string['allowedfiletypes_err'] = 'Check input! Invalid file extensions or separators';

$string['currentlynotapproved'] = '* Currently not approved or rejected to publication.';

$string['teacherapproval_help'] = 'Current approval/rejection of files, i.e. whether they are visible to all participants: <br><ul><li><strong>Choose...</strong> - decision pending/no approval given or rejected, these files are not visible.</li><li><strong>Approve</strong> - approval granted, these files are published and therefore visible to all.</li><li><strong>Reject</strong> - no approval given, these files are not published and therefore not visible.</li></ul>';
$string['nonexistentfiletypes'] = 'The following file types were not recognised: {$a}';

$string['completionupload'] = 'Student must upload a file';
$string['completiondetail:upload'] = 'Upload a file';

// Strings from the File index.php.
$string['noopenbooksincourse'] = 'There is no openbook resources folder instance in this course.';

// Strings from the File view.php.
$string['allowsubmissionsfromdate_upload'] = 'Upload from';
$string['duedate_upload'] = 'Upload until';
$string['extensionto'] = 'Extension to';
$string['filedetails'] = 'Details';
$string['myfiles'] = 'Own files';
$string['teacherfiles'] = 'Teacher files that are visible to everybody';
$string['teacher_files'] = 'Teacher files';
$string['add_uploads'] = 'Add files';
$string['edit_uploads'] = 'Edit/upload files';
$string['edit_teacher_uploads'] = 'Edit/upload teacher files';
$string['edit_timeover'] = 'Files can be edited/uploaded only during the editing period.';
$string['edit_notcapable'] = 'Editing period is open but you are not allowed to edit or upload files.';
$string['approval_timeover'] = 'You don\'t have any file waiting for sharing approval or approval time is over.';
$string['approval_timeover_description'] = 'Sharing approval';
$string['noentries'] = 'No entries';
$string['nofiles'] = 'No files available';
$string['nothing_to_show_users'] = 'Nothing to display - no students available';
$string['nothing_to_show_groups'] = 'Nothing to display - no groups available';
$string['notice'] = '<strong>Notice: </strong>';
$string['datalogapprovalstudent'] = '(Students {$a->approving} out of {$a->needed}) {$a->approval}';
$string['viewallxsubmissions'] = 'View all {$a} submissions';

$string['notice_upload_filesarepersonal_teacherrequired'] = 'All files you upload here will be personal and visible to you only <strong>after the approval of teachers.</strong> Teachers reserve the right to reject the publication of your files at any time.';
$string['notice_upload_filesarepersonal_teachernotrequired'] = 'All files you upload here will be personal and visible to you <strong>automatically.</strong>';

$string['notice_upload_studentrequired_teacherrequired'] = 'All files you upload here will be visible and accessible only to you, <strong>after teacher approval</strong>. They will only be shared (visible to other students) <strong>after your approval.</strong>';
$string['notice_upload_studentrequired_teachernotrequired'] = 'All files you upload here will be visible and accessible only to you. They will only be shared (visible to other students) <strong>after your approval.</strong>';
$string['notice_upload_studentnotrequired_teacherrequired'] = 'All files you upload here will be published (visible to all students) only <strong>after teacher approval.</strong>';
$string['notice_upload_studentnotrequired_teachernotrequired'] = 'All files you upload here will be published (visible to everyone) <strong>automatically.</strong>';

// Strings for approval.

$string['teacher_pending'] = 'Decision from teacher is pending.';
$string['teacher_approved'] = 'Approved by teacher.';
$string['teacher_approved_automatically'] = 'Approved by teacher automatically.';
$string['teacher_rejected'] = 'Rejected by teacher.';
$string['teacher_approve'] = 'Approve';
$string['teacher_reject'] = 'Reject';
$string['approved'] = 'Approved';
$string['show_details'] = 'Show details';
$string['student_approve'] = 'Share';
$string['student_approved'] = 'Sharing approved by student.';
$string['group_approved'] = 'Sharing approved by all members of the group.';
$string['student_approved_automatically'] = 'Sharing approved by student automatically.';
$string['student_pending'] = 'Decision from student is pending.';
$string['pending'] = 'Pending';
$string['student_reject'] = 'Do not share';
$string['student_rejected'] = 'Sharing rejected from student.';
$string['rejected'] = 'Rejected';
$string['visible'] = 'Published';
$string['hidden'] = 'Not published';
$string['status:approved'] = 'Approved';
$string['status:approvedautomatic'] = 'Automatic';
$string['status:approvednot'] = 'Rejected';
$string['status:approvedrevoke'] = 'Revoked';
$string['giveapproval'] = 'Give approval';
$string['overdue'] = 'Deadline of editing/uploading period passed';
$string['approval_required'] = 'Decision pending';
$string['openbookstatus'] = 'Approval';
$string['openbookstatus_help'] = 'The status of the file represents the approval of the teacher: <ul><li><i class="fa fa-check text-success fa-fw"></i><i class="fa fa-share-from-square text-success fa-fw"></i> File is approved, has been shared, and is therefore visible for all participants</li><li><i class="fa fa-check text-success fa-fw"></i><i class="fa fa-user text-success fa-fw"></i> File is approved and is visible for the participant only</li><li><i class="fa fa-times text-danger fa-fw"></i> File is not approved (approval has not yet been given or has been rejected) and therefore not visible</li></ul>';

$string['allfiles'] = 'File submissions';
$string['publicfiles'] = 'Shared files';
$string['downloadall'] = 'Download all file submissions';
$string['optionalsettings'] = 'Options';
$string['entiresperpage'] = 'Participants shown per page';
$string['nothingtodisplay'] = 'No entries to display';
$string['nofilestodisplay'] = 'Currently there are no files available or not yet published.';
$string['nofilestozip'] = 'No files to zip';
$string['status'] = 'Status';
$string['studentapproval'] = 'Approval (students)';
$string['studentapproval_help'] = 'In the column "Approval (students)" the feedback of the students is displayed:<br><ul><li><i class="fa fa-question fa-fw text-warning"></i> - Decision pending</li><li><i class="fa fa-check text-success fa-fw"></i> - Approval given</li><li><i class="fa fa-times text-danger fa-fw"></i> - Approval rejected</li></ul>';
$string['teacherapproval'] = 'Approval';
$string['visibility'] = 'Published';
$string['visibleforstudents'] = 'Published';
$string['visibleforstudents_yes'] = 'This file is published (visible for students).';
$string['visibleforstudents_no'] = 'This file is not published (not visible for students).';
$string['resetstudentapproval'] = 'Revert student approval';
$string['savestudentapprovalwarning'] = 'Are you sure you want to save these changes? The publication status cannot be changed once it is set.';
$string['studentswhosubmitted'] = 'Students who submitted';
$string['submittedbystudents'] = 'Files submitted by students';
$string['submittedbyteachers'] = 'Files submitted by teachers';

$string['go'] = 'Go';
$string['withselected'] = 'With selected...';
$string['zipusers'] = 'Download selected file submissions';
$string['approveusers'] = 'Give approval';
$string['rejectusers'] = 'Reject';
$string['grantextension'] = 'Grant extension';
$string['saveteacherapproval'] = 'Save changes';
$string['reset'] = 'Revert';

// Strings from the file upload.php.
$string['filesofthesetypes'] = 'Files of these types may be added:';
$string['guideline'] = 'Openbook resource folder of file submissions';
$string['published_immediately'] = 'Approve automatically';
$string['published_aftercheck'] = 'Approval from teachers required';
$string['save_changes'] = 'Save changes';

$string['overview'] = 'Overview';

// Strings for JS.
$string['total'] = 'Total';
$string['details'] = 'Details';

// Strings for privacy-API.
$string['privacy:metadata:openbookperpage'] = 'How many entries should be displayed on a single table page!';
$string['privacy:path:files'] = 'Files';
$string['privacy:metadata:openbookfileexplanation'] = 'Files for this plugin get stored via Moodle\'s file API.';
$string['privacy:metadata:files'] = 'Stores information (identifier, whom it belongs, where it came from, hash of content, file name and if approved by teacher and/or student) about the files uploaded into mod_openbook.';
$string['privacy:metadata:fileid'] = 'Identifier of the file.';
$string['privacy:metadata:userid'] = 'Identifier of the user.';
$string['privacy:metadata:timecreated'] = 'The time and date the data record was created.';
$string['privacy:metadata:openbook'] = 'The Openbook resource folder';
$string['privacy:metadata:openbook_overrides'] = 'The overrides for this Openbook resource folder';
$string['privacy:metadata:timemodified'] = 'The most recent time and date the data record got updated/modified.';
$string['privacy:metadata:userextensionapprovalfromdate'] = 'The overridden start date for file approval for that user.';
$string['privacy:metadata:userextensionapprovaltodate'] = 'The overridden end date for file approval for that user.';
$string['privacy:metadata:userextensionsecurewindowfromdate'] = 'The overridden start date for secure window for that user.';
$string['privacy:metadata:userextensionsecurewindowtodate'] = 'The overridden end date for secure window for that user.';
$string['privacy:metadata:userextensionallowsubmissionsfromdate'] = 'The overridden start date for file submissions for that user.';
$string['privacy:metadata:userextensiontodate'] = 'The overridden end date for file submissions for that user.';
$string['privacy:metadata:studentapproval'] = 'Whether the student has approved or rejected the publication of a file.';
$string['privacy:metadata:teacherapproval'] = 'Whether the teacher has approved or rejected the publication of a file.';
$string['privacy:metadata:contenthash'] = 'SHA1 hash of the file\'s content, used to determine if the file changed.';
$string['privacy:metadata:filename'] = 'The file\'s name.';

// Strings for filters.
$string['filter'] = 'Filter';
$string['filter:nofilter'] = 'No filter';
$string['filter:allfiles'] = 'All file submissions';
$string['filter:approved'] = 'Approved file submissions';
$string['filter:rejected'] = 'Rejected file submissions';
$string['filter:approvalrequired'] = 'Decision pending';
$string['filter:nofiles'] = 'No file submission';

// Strings for overrides.
$string['overrides'] = 'Overrides';
$string['eventoverridecreated'] = 'Openbook resource folder override created';
$string['eventoverridedeleted'] = 'Openbook resource folder override deleted';
$string['eventoverrideupdated'] = 'Openbook resource folder override updated';
$string['override:add:group'] = 'Add group override';
$string['override:add:user'] = 'Add user override';
$string['overrides:empty'] = 'No overrides';
$string['override:save:success'] = 'Override saved successfully';
$string['override:invalidid'] = 'Invalid override ID';
$string['override:submission:fromto'] = 'Allow submissions from {$a->from} until {$a->to}';
$string['override:submission:from'] = 'Allow submissions from {$a->from}';
$string['override:submission:to'] = 'Allow submissions until {$a->to}';
$string['override:approval:fromto'] = 'Approval from {$a->from} until {$a->to}';
$string['override:approval:from'] = 'Approval from {$a->from}';
$string['override:approval:to'] = 'Approval until {$a->to}';
$string['override:user:choose'] = 'Choose a user';
$string['override:securewindow:fromto'] = 'Secure window from {$a->from} until {$a->to}';
$string['override:securewindow:from'] = 'Secure window from {$a->from}';
$string['override:securewindow:to'] = 'Secure window until {$a->to}';
$string['override:nothingtochange'] = 'There are no settings that can be overriden with the current activity settings!';
$string['override:delete:ask'] = 'Are you sure you want to delete the override for {$a->userorgroup} {$a->fullname}?';
$string['override:delete:success'] = 'Override deleted successfully!';

$string['calendarsubmissionstart'] = '{$a} opens for file uploads';
$string['calendarsubmissionend'] = '{$a} closes for file uploads';
$string['calendarapprovalstart'] = '{$a} opens for file approvals';
$string['calendarapprovalend'] = '{$a} closes for file approvals';

$string['answered'] = 'Answered';
$string['notanswered'] = 'Not answered';
