define("block_stash/trade-selector",["exports","core/modal_factory","core/modal_events","core/str","core/templates","core/ajax"],(function(_exports,_modal_factory,_modal_events,_str,_templates,_ajax){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Add items to a trade table.
   *
   * @copyright 2023 Adrian Greeve <adriangreeve.com>
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_templates=_interopRequireDefault(_templates),_ajax=_interopRequireDefault(_ajax);const showModal=async e=>{let type=e.currentTarget.dataset.type;const modal=await buildModal(type);displayModal(modal,type)},buildModal=async tradetype=>{let courseid=document.querySelector('input[name="courseid"]').value,context=await getItems(courseid);return context.type=tradetype,_modal_factory.default.create({title:(0,_str.get_string)("addnewtradeitem","block_stash"),body:_templates.default.render("block_stash/trade_item_picker",context),type:_modal_factory.default.types.SAVE_CANCEL})},displayModal=async(modal,type)=>{let savetext=(0,_str.get_string)("additem","block_stash");modal.setSaveButtonText(savetext),modal.getRoot().on(_modal_events.default.save,(()=>{let itemnode=document.querySelector("#block-stash-item-select option:checked"),itemamount=document.getElementById("amount").value;itemamount=parseInt(itemamount),(!Number.isInteger(itemamount)||itemamount<=0)&&(itemamount=1);let data={itemid:itemnode.value,imageurl:itemnode.dataset.imgurl,name:itemnode.innerText,quantity:itemamount},templatename="gain"===type?"block_stash/trade_add_item_detail":"block_stash/trade_loss_item_detail";_templates.default.render(templatename,data).done(((html,js)=>{let itemsbox=document.querySelector('.block_stash_item_box[data-type="'+type+'"]');_templates.default.appendNodeContents(itemsbox,html,js),registerActions()})),modal.destroy()})),modal.getRoot().on(_modal_events.default.hidden,(()=>{modal.destroy()})),modal.show()},getItems=courseid=>_ajax.default.call([{methodname:"block_stash_get_items",args:{courseid:courseid}}])[0],registerActions=()=>{let deleteelements=document.getElementsByClassName("block-stash-delete-item");for(let delement of deleteelements)delement.addEventListener("click",deleteItem)},deleteItem=element=>{element.currentTarget.closest(".block-stash-trade-item").remove(),element.preventDefault()};_exports.init=()=>{registerActions();let additemelements=document.getElementsByClassName("additem");for(let additem of additemelements)additem.addEventListener("click",showModal)}}));

//# sourceMappingURL=trade-selector.min.js.map