<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings.
 *
 * @package   block_stash
 * @copyright 2016 Adrian Greeve <adrian@moodle.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['accept'] = 'Accept';
$string['add'] = 'Add';
$string['additem'] = 'Add an item';
$string['addnewdrop'] = 'Add new location';
$string['addnewtradeitem'] = 'Add new item to this trade';
$string['addtradeitem'] = 'Add a trade item';
$string['addtoinventory'] = 'Add an item to the inventory.';
$string['addtrade'] = 'Add a trade widget';
$string['advancedreset'] = 'Advanced reset';
$string['aftercreatinglocationhelp'] = 'Once you have created the item and the location, you need to add a code snippet to your course for the item to be displayed. After customising how the item will be displayed to your students, copy the snippet below and paste it in your content, in the description of an assignment for instance.';
$string['appearance'] = 'Appearance';
$string['backtostart'] = 'Back to the main screen';
$string['buttontext'] = 'Button text';
$string['configdeleted'] = 'Configuration deleted';
$string['configupdated'] = 'Configuration updated';
$string['configurationtitle'] = 'Stash title';
$string['configureremoval'] = 'Configure removal';
$string['completed'] = 'Completed';
$string['copypaste'] = 'Copy and paste this into an editor in different activities around your course.';
$string['copytoclipboard'] = 'Copy to clipboard';
$string['cost'] = 'Cost';
$string['createtrade'] = 'Create trade request';
$string['createquizzes'] = 'Create a quiz in this course to configure a stash item removal for it here.';
$string['decline'] = 'Decline';
$string['delete'] = 'Delete';
$string['deletedrop'] = 'Delete {$a}';
$string['deleteitem'] = 'Delete {$a}';
$string['deleteswap'] = 'Delete trade';
$string['deleteuseritem'] = 'Delete {$a} for this user';
$string['details'] = 'Details';
$string['dropa'] = 'Location \'{$a}\'';
$string['dropname'] = 'Location';
$string['dropname_help'] = 'The name of the location is only useful for you to organise them, it will not be displayed to the students.';
$string['drops'] = 'Locations';
$string['drops_help'] = '
<p>Locations are places where your items are in the <em>virtual world</em>. Without a <em>location</em> an item cannot be picked up by a student.</p>
<p>Locations come with a few options, including the number of times a single student can pick them up, and how often they reappear after being picked up.</p>
<p>For instance, if your students need a <em>key item</em> to access an activity, you will most likely set it so that your students can only pick it up once in that location.</p>
<p>But if they need <em>5 coins</em> to access another one, you may set this coin to reappear each day to encourage them to visit the course everyday.</p>
<p>Note that items do not magically appear in your course, you will have to add a special code to your content in order for the item to be displayed.</p>
';
$string['dropslist'] = 'List of locations';
$string['dropsnippet'] = 'Snippet for \'{$a}\'';
$string['dropsummary'] = 'Location summary';
$string['edit'] = 'Edit'; // Should be replaced with the pix icon.
$string['editdrop'] = 'Edit location \'{$a}\'';
$string['edititem'] = 'Edit item \'{$a}\'';
$string['edittrade'] = 'Edit trade widget \'{$a}\'';
$string['edittradeitem'] = 'Edit trade item \'{$a}\'';
$string['eginthecastle'] = 'E.g. In the castle';
$string['enabled'] = 'Enabled';
$string['eventitemacquired'] = 'An item was acquired.';
$string['eventswapaccepted'] = 'A user trade was accepted.';
$string['eventswapcreated'] = 'A user trade was created.';
$string['filtershortcodesnotactive'] = 'The filter plugin Shortcodes is installed but not yet enabled for this course. Visit <a href="{$a->activeurl}" target="_blank">this page</a> to enable it for this course.';
$string['filtershortcodesnotenabled'] = 'The filter plugin Shortcodes is installed but not yet <a href="{$a->enableurl}" target="_blank">enabled</a>.';
$string['filtershortcodesnotinstalled'] = 'We recommend that you install and enable the <a href="{$a->installurl}" target="_blank">filter plugin Shortcodes</a>. It makes it easier and more reliable to use the snippets. It also enables trading.';
$string['filterstashdeprecated'] = 'You are using the older filter plugin Stash which is no longer supported, we now recommend that you install and enable the <a href="{$a->installurl}" target="_blank">filter Shortcodes</a> instead. It also enables trading.';
$string['from'] = 'From';
$string['gain'] = "Gain";
$string['gainloss'] = "Gain or lose";
$string['gaintitle'] = "Gain title";
$string['gaintitle_help'] = "Title for the column of items the user will acquire in this trade.";
$string['generalsettings'] = 'General settings';
$string['grouponly'] = 'Only allow trades between students in their groups.';
$string['leaderboard'] = 'Show leaderboard.';
$string['leaderboards'] = 'Leaderboards';
$string['leaderboard_groups'] = 'Show only users from my groups in the leaderboard.';
$string['image'] = 'Image';
$string['imageandbutton'] = 'Image and button';
$string['item'] = 'Item';
$string['itemamountlimit'] = 'Amount limit';
$string['itemamountlimit_help'] = 'This is the maximum amount of this scarce item available for all students in this course.';
$string['itemamountupdate'] = 'The number for this item was updated';
$string['items'] = 'Items';
$string['itemdeleted'] = 'The item was deleted';
$string['itemdetail'] = 'Details';
$string['itemdetail_help'] = 'Details about the item.';
$string['itemimage'] = 'Image';
$string['itemimage_help'] = 'This image will be used to display the item. The recommended size is 100x100 pixels.';
$string['itemname'] = 'Item name';
$string['itemname_help'] = 'The name of the item, this will be displayed to the students.';
$string['itemremoval'] = 'Item removal';
$string['items'] = 'Items';
$string['itemslist'] = 'List of items';
$string['itemsremoved'] = 'Items removed';
$string['locations'] = 'Locations';
$string['loss'] = 'Loss';
$string['losstitle'] = 'Loss title';
$string['losstitle_help'] = 'Title for the column of items the user will surrender in this trade.';
$string['maxnumber'] = 'Maximum collectible';
$string['maxpickup'] = 'Supplies';
$string['maxpickup_help'] = 'The number of times the item can be picked up by each students in this location. For instance, if you set this to \'1\' the item will only be available once per student. If you set it to \'5\', each student can acquire the item five times in this location. A value different than \'1\' is better used in combination with the \'Collection interval\'.';
$string['mostitems'] = 'Most items';
$string['mostsingularitem'] = 'Most of a singular specified item';
$string['mostsingularitemname'] = 'Most of \'{$a}\' ';
$string['mostuniqueitems'] = 'Most unique items';
$string['myitems'] = 'My items';
$string['myrequests'] = 'My requests to others';
$string['navdrops'] = 'Locations';
$string['navinventory'] = 'Stash items';
$string['navitems'] = 'Items';
$string['navleaderboadsettings'] = 'Leader board settings';
$string['navreport'] = 'Report';
$string['navtrade'] = 'Trade';
$string['new'] = 'New';
$string['next'] = 'Next';
$string['none'] = 'None';
$string['nofilterandnotiny'] = '📢 Did you know there is a new plugin for the TinyMCE editor that makes creating items and trades much easier? Download and install both the <a href="https://moodle.org/plugins/filter_shortcodes">filter plugin shortcodes</a> and the <a href="https://moodle.org/plugins/tiny_stash">TinyMCE editor plugin tiny stash</a> to vastly improve your stash creation experience. A preview video is available via the previous tiny stash link.';
$string['noitems'] = 'No items selected';
$string['noitemstotrade'] = 'You have no items to trade';
$string['nomorescarceitems'] = 'The maximum number of this item has already been allocated. Consider upping the scarcity amount of this item.';
$string['noquizzes'] = 'You have no quizzes';
$string['nosingularitem'] = 'Please add at least one item to use this leaderboard';
$string['notiny'] = '📢 Did you know there is a new plugin for the TinyMCE editor that makes creating items and trades much easier? Download and install the <a href="https://moodle.org/plugins/tiny_stash">TinyMCE plugin tiny stash</a> to vastly improve your stash creation experience. A preview video is available via the previous link.';
$string['notrecorded'] = 'Not recorded';
$string['number'] = 'Number';
$string['offers'] = 'Offers';
$string['offerdetail'] = 'You have requested a trade with this student for the following items.';
$string['offereditems'] = 'Offered items';
$string['offers:zero'] = 'No offers';
$string['offersdetail:zero'] = 'Go to the trade center to start a trade, or wait for someone to offer you a trade.';
$string['participantswithitem'] = 'Participants with this item';
$string['previous'] = 'Previous';
$string['pickupa'] = 'Pick up \'{$a}\'';
$string['pickupinterval'] = 'Collection interval';
$string['pickupinterval_help'] = 'This defines the time required for the item to re-appear to students who already picked this item up. For instance, if you created an item \'cake\' you could set its collection interval to 24 hours to simulate the time it takes for the baker to bake another one. It is important to note that students are not affected by the pickups of other students. This setting has no effect when \'Supplies\' is set to \'1\'.';
$string['pluginname'] = 'Stash';
$string['privacy:metadata:pickup'] = 'A record of the items picked up at a certain location.';
$string['privacy:metadata:pickup:dropid'] = 'The ID of the location.';
$string['privacy:metadata:pickup:lastpickup'] = 'The time at which the last pickup occured.';
$string['privacy:metadata:pickup:pickupcount'] = 'The quantity picked up at that location.';
$string['privacy:metadata:pickup:timecreated'] = 'The time at which the record was created.';
$string['privacy:metadata:pickup:timemodified'] = 'The time at which the record was last modified.';
$string['privacy:metadata:pickup:userid'] = 'The ID of the user who picked did the pick up.';
$string['privacy:metadata:swap:stashid'] = 'The stash instance this trade is part of';
$string['privacy:metadata:swap:initiator'] = 'The person that made a trade offer';
$string['privacy:metadata:swap:receiver'] = 'The person that is receiving the trade offer';
$string['privacy:metadata:swap:message'] = 'A message related to the trade';
$string['privacy:metadata:swap:messageformat'] = 'A format that the message is in';
$string['privacy:metadata:swap:status'] = 'The status of the trade';
$string['privacy:metadata:swap:timecreated'] = 'The time that the trade offer was made';
$string['privacy:metadata:swap:timemodified'] = 'Any time that the trade offer is updated';
$string['privacy:metadata:swap'] = 'A record of trades between users';
$string['privacy:metadata:useritem'] = 'A record of the items owned by a user.';
$string['privacy:metadata:useritem:itemid'] = 'The ID of the item.';
$string['privacy:metadata:useritem:quantity'] = 'The quantity owned.';
$string['privacy:metadata:useritem:timecreated'] = 'The time at which the record was created.';
$string['privacy:metadata:useritem:timemodified'] = 'The time at which the record was last modified.';
$string['privacy:metadata:useritem:userid'] = 'The ID of the user owning the item.';
$string['quantity'] = 'Quantity';
$string['quizitemsremoved'] = 'The following items were removed:'; // Items will be listed after this string. Please contact me if this does not work with your language.
$string['quizname'] = 'Quiz name';
$string['quiznotenoughitems'] = 'You do not have enough items to take this quiz. You need the following items:'; // Items will be listed after this string. Please contact me if this does not work with your language.
$string['quizremovalconfigured'] = 'This quiz is <a href="{$a}">configured</a> to remove stash items.';
$string['reallydeletedrop'] = 'Are you sure you want to delete this location?';
$string['reallydeleteitem'] = 'Are you sure you want to delete this item?';
$string['reallyresetstashof'] = 'Are you sure you want to completely reset the stash of {$a}?';
$string['received'] = 'Received';
$string['removalconfigurations'] = 'Removal configurations';
$string['removalexplanation'] = 'Removals are currently limited to attempting the quiz activity. Items listed for removal will be removed every time a student starts a new attempt. Access will be denied if the student does not have enough of the listed items.';
$string['removals'] = 'Removals';
$string['removeswapdetails'] = 'Do you want to remove the details of this trade?';
$string['report'] = 'Report';
$string['reportadditional'] = 'Advanced user item management';
$string['requestdetail'] = 'This student has requested the following trade.';
$string['requesteditems'] = 'Requested items';
$string['requestsforme'] = 'Requests for me';
$string['requestsent'] = 'Request has been sent.';
$string['requestswap'] = 'Make an offer';
$string['resetstashof'] = 'Reset the stash of {$a}';
$string['saveandnext'] = 'Save and next';
$string['savechanges'] = 'Save changes';
$string['savequantity'] = 'Save the quantity for the {$a} item';
$string['scarceitem'] = 'Scarce item';
$string['scarceitem_help'] = 'Only a limited amount of this item is available. If you limit this item to 5 then only five items exist in this course.';
$string['searchitems'] = 'Search items';
$string['selectanitem'] = 'Select an item';
$string['selectauser'] = 'Select a user';
$string['selectquizcheck'] = 'Please select a quiz';
$string['selectquiz'] = 'Quiz';
$string['sendtraderequest'] = 'Send trade request';
$string['sent'] = 'Sent';
$string['settingupdated'] = 'Setting updated';
$string['settings'] = 'Settings';
$string['setup'] = 'Setup';
$string['shortcode:stashdrop'] = 'Displays an item for a user to pick up';
$string['shortcode:stashtrade'] = 'Displays the trade widget';
$string['snippet'] = 'Snippet';
$string['stash'] = 'Stash';
$string['stash:acquireitems'] = 'User is able to acquire items';
$string['stash:addinstance'] = 'Add a the block to a page';
$string['stash:view'] = 'View the stash and its content';
$string['stashdisabled'] = 'The stash is not enabled. Was the block added to the course?';
$string['swapnolongerpossible'] = 'This offer is no longer possible, likely because either you or the participant no longer have these items.';
$string['text'] = 'Text';
$string['tidyswap'] = 'Remove all trade requests that have been completed.';
$string['title'] = 'Title';
$string['to'] = 'To';
$string['trade'] = 'Trade';
$string['tradecenter'] = 'Trade center';
$string['tradecenter:zero'] = 'Select an item or user above';
$string['tradecenterdetail:zero'] = 'Finding an item will give you a list of users with those items to start a trade. Selecting a user will show a list of their items to trade for.';
$string['tradecreated'] = 'Created trade \'{$a}\'';
$string['tradedetails'] = 'Trade details';
$string['tradeitem'] = 'Trade item';
$string['tradeitems'] = 'Trade items';
$string['tradelist'] = 'List of trade widgets';
$string['tradename'] = 'Trade name';
$string['tradename_help'] = 'The name of the trade widget, this may be displayed to the students.';
$string['tradesnotenabled'] = 'Trades are not enabled';
$string['tradestatusapproved'] = 'Trade approved';
$string['tradestatuscompleted'] = 'Trade completed';
$string['tradestatusdeclined'] = 'Trade declined';
$string['tradestatusviewed'] = 'Trade viewed';
$string['tradewidget'] = 'Creating a trade.';
$string['tradewidget_help'] = '<p>This trade widget allows gaining items from the left column in exchange for losing items in the right column.</p><p>Click the + symbol at the bottom of the box to add items to that column.</p><p>The quantity of an item must be a positive number.</p>';
$string['thedrophasbeendeleted'] = 'The location \'{$a}\' has been deleted';
$string['theiritems'] = 'Their items';
$string['theitemhasbeendeleted'] = 'The item \'{$a}\' has been deleted';
$string['thestashofhasbeenreset'] = 'The stash of {$a} has been reset';
$string['thetradehasbeendeleted'] = 'The trade widget \'{$a}\' has been deleted';
$string['thetradeitemhasbeendeleted'] = 'The trade item has been deleted';
$string['unlimited'] = 'Unlimited';
$string['useritemswap'] = 'Allow students to trade items with each other.';
$string['view'] = 'view';
$string['whataredrops'] = 'What are locations?';
$string['whatisadrophelp'] = 'A location is a place where you intend to display your item.';
$string['whatisatradedrophelp'] = 'A location is a place where you intend to display your trade widget.';
$string['whatisthisthing'] = 'What is this thing? I am certain you can find a use for it!';
$string['whatsthis'] = 'What\'s this?';
$string['whatsnext'] = 'What\'s next?';
$string['yourinventoryisempty'] = 'Your inventory is empty.';

// Deprecated.
$string['filterstashnotactive'] = 'The filter plugin is installed but not yet enabled for this course. Visit <a href="{$a->activeurl}" target="_blank">this page</a> to enable it for this course.';
$string['filterstashnotenabled'] = 'The filter plugin is installed but not yet <a href="{$a->enableurl}" target="_blank">enabled</a>.';
$string['filterstashnotinstalled'] = 'We recommend that you install and enable the <a href="{$a->installurl}" target="_blank">filter plugin for Stash</a>. It makes it easier and more reliable to use the snippets. It also enables trading.';
$string['filterstashwrongversion'] = 'The filter plugin that you have installed is an early version and does not work with trading. Please visit <a href="{$a}" target="_blank">this page</a> to get the latest version.';
