define("block_stash/item-selector-modal",["exports","core/modal_factory","core/modal_events","core/ajax","core/templates","core/str","core/toast"],(function(_exports,_modal_factory,_modal_events,_ajax,_templates,_str,_toast){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Select items to give to students.
   *
   * @copyright  2023 Adrian Greeve <adriangreeve.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates);const showModal=async e=>{let targetnode=e.currentTarget,userid=targetnode.dataset.userid,courseid=targetnode.dataset.courseid;const modal=await buildModal(courseid);displayModal(modal,userid,courseid)},buildModal=async courseid=>{let context=await getItems(courseid);return context.type="",_modal_factory.default.create({title:(0,_str.get_string)("additem","block_stash"),body:_templates.default.render("block_stash/trade_item_picker",context),type:_modal_factory.default.types.SAVE_CANCEL})},displayModal=async(modal,userid,courseid)=>{let savetext=(0,_str.get_string)("additem","block_stash");modal.setSaveButtonText(savetext),modal.getRoot().on(_modal_events.default.save,(()=>{let itemnode=document.getElementById("block-stash-item-select"),itemid=itemnode.options[itemnode.selectedIndex].value,quantity=document.getElementById("amount").value;saveItem(courseid,itemid,userid,quantity).then((iteminfo=>{let tablething=document.querySelector(".block-stash-report-table").children[0],existingrow=document.querySelector('.block-stash-item[data-id="'+itemid+'"]');if(existingrow)existingrow.querySelector("div.item-quantity").innerHTML=quantity,existingrow.parentNode.parentNode.querySelector('input[name="quantity"]').value=quantity;else{let rowcontext={item:{id:iteminfo.id,name:iteminfo.name,imageurl:iteminfo.imageurl},useritem:{userid:userid,quantity:quantity},courseid:courseid};_templates.default.render("block_stash/local/report_table/item_row",rowcontext).done(((html,js)=>{_templates.default.appendNodeContents(tablething,html,js),registerSaveListeners(),registerDeleteListeners()}))}})),modal.destroy()})),modal.getRoot().on(_modal_events.default.hidden,(()=>{modal.destroy()})),modal.show()},getItems=courseid=>_ajax.default.call([{methodname:"block_stash_get_items",args:{courseid:courseid}}])[0],saveItem=(courseid,itemid,userid,quantity)=>_ajax.default.call([{methodname:"block_stash_add_user_item",args:{courseid:courseid,itemid:itemid,userid:userid,quantity:quantity}},{methodname:"block_stash_get_item",args:{itemid:itemid}}])[1],registerSaveListeners=()=>{document.getElementsByClassName("block-stash-save-button").forEach((button=>{button.addEventListener("click",saveItemInformation)}))},saveItemInformation=e=>{let target=e.currentTarget,quantity=target.parentNode.parentNode.querySelector('input[name="quantity"]').value,itemid=target.parentNode.parentNode.querySelector('input[name="itemid"]').value,userid=target.parentNode.parentNode.querySelector('input[name="userid"]').value,courseid=target.parentNode.parentNode.querySelector('input[name="courseid"]').value;saveItem(courseid,itemid,userid,quantity),(0,_toast.add)((0,_str.get_string)("itemamountupdate","block_stash"),{type:"info",autohide:!0,closeButton:!0}),document.querySelector('.block-stash-item[data-id="'+itemid+'"] div.item-quantity').innerHTML=quantity},registerDeleteListeners=()=>{document.getElementsByClassName("block-stash-delete-button").forEach((button=>{button.addEventListener("click",deleteItem)}))},deleteItem=e=>{let target=e.currentTarget,itemid=target.parentNode.parentNode.querySelector('input[name="itemid"]').value,userid=target.parentNode.parentNode.querySelector('input[name="userid"]').value,courseid=target.parentNode.parentNode.querySelector('input[name="courseid"]').value;saveItem(courseid,itemid,userid,0),(0,_toast.add)((0,_str.get_string)("itemdeleted","block_stash"),{type:"info",autohide:!0,closeButton:!0}),document.querySelector('.block-stash-item[data-id="'+itemid+'"]').parentNode.parentNode.remove()};_exports.init=()=>{document.querySelector("[data-additem]").addEventListener("click",showModal),registerSaveListeners(),registerDeleteListeners()}}));

//# sourceMappingURL=item-selector-modal.min.js.map