/**
 * Stash module.
 *
 * @copyright  2016 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_stash/stash-area",["jquery","core/templates","block_stash/item-modal","block_stash/drop","block_stash/trade","core/pubsub"],(function($,Templates,ItemModal,Drop,Trade,PubSub){function StashArea(node){this._node=$(node),this._setUp()}return StashArea.prototype._node=null,StashArea.prototype._userItemTemplate="block_stash/user_item",StashArea.prototype._setUp=function(){PubSub.subscribe("block_stash/drop/pickedup",this._dropPickedUpListener.bind(this)),PubSub.subscribe("trade:pickedup",this._dropPickedUpListener.bind(this)),this._setUpUserItemAreClickable()},StashArea.prototype.addUserItem=function(userItem){return this._renderUserItem(userItem).then(function(html,js){var node=$(html),container=this._node.find(".item-list");node.data("useritem",userItem),this._makeUserItemNodeClickable(node),container.append(" "),container.append(node),Templates.runTemplateJS(js)}.bind(this))},StashArea.prototype.containsItem=function(id){return this.getUserItemNode(id).length>0},StashArea.prototype._dropPickedUpListener=function(e){var userItem=e.useritem;this.containsItem(userItem.getItem().get("id"))?this.updateUserItemQuantity(userItem):this.addUserItem(userItem).then(function(){this._node.find(".empty-content").remove()}.bind(this))},StashArea.prototype.getUserItemNode=function(id){return this._node.find(".block-stash-item[data-id="+id+"]")},StashArea.prototype._makeUserItemNodeClickable=function(node){node.attr("tabindex",0),node.attr("role","button"),node.attr("aria-haspopup","true")},StashArea.prototype._renderUserItem=function(userItem){return Templates.render(this._userItemTemplate,{item:userItem.getItem().getData(),useritem:userItem.getData()})},StashArea.prototype._setUpUserItemAreClickable=function(){this._node.find(".item-list .block-stash-item").each(function(i,node){this._makeUserItemNodeClickable($(node))}.bind(this));var handler=function(e){var itemId=$(e.currentTarget).data("id");itemId&&(ItemModal.init(itemId),e.preventDefault())},selector='.block-stash-item[aria-haspopup="true"]';this._node.find(".item-list").delegate(selector,"click",handler),this._node.find(".item-list").delegate(selector,"keydown",(function(e){13!=e.keyCode&&32!=e.keyCode||handler(e)}))},StashArea.prototype.updateUserItemQuantity=function(userItem){var node=this.getUserItemNode(userItem.getItem().get("id")),quantityNode=node.find(".item-quantity"),newQuantity=userItem.get("quantity"),quantity=parseInt(quantityNode.text(),10);quantityNode.text(newQuantity),node.removeClass("item-quantity-"+quantity),node.addClass("item-quantity-"+newQuantity)},StashArea}));

//# sourceMappingURL=stash-area.min.js.map