<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Form for editing Stash block instances.
 *
 * @package   block_stash
 * @copyright 2017 Adrian Greeve <adriangreeve.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Form for editing Stash block instances.
 *
 * @copyright 2017 Adrian Greeve <adriangreeve.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class block_stash_edit_form extends block_edit_form {
    protected function specific_definition($mform) {
        global $CFG;

        // Fields for editing HTML block title and contents.
        $mform->addElement('header', 'configheader', get_string('blocksettings', 'block'));

        $mform->addElement('text', 'config_title', get_string('configurationtitle', 'block_stash'));
        $mform->setType('config_title', PARAM_TEXT);

        $mform->addElement('advcheckbox', 'config_useritemswap', get_string('useritemswap', 'block_stash'));
        $mform->setType('config_useritemswap', PARAM_BOOL);
        $mform->setDefault('config_useritemswap', 1);

        $mform->addElement('advcheckbox', 'config_grouponly', get_string('grouponly', 'block_stash'));
        $mform->setType('config_grouponly', PARAM_BOOL);
        $mform->setDefault('config_grouponly', 0);
        $mform->hideIf('config_grouponly', 'config_useritemswap', 'eq', 0);

        $mform->addElement('advcheckbox', 'config_leaderboard', get_string('leaderboard', 'block_stash'));
        $mform->setType('config_leaderboard', PARAM_BOOL);
        $mform->setDefault('config_leaderboard', 0);

        $mform->addElement('advcheckbox', 'config_leaderboard_groups', get_string('leaderboard_groups', 'block_stash'));
        $mform->setType('config_leaderboard_groups', PARAM_BOOL);
        $mform->setDefault('config_leaderboard_groups', 0);
        $mform->hideIf('config_leaderboard_groups', 'config_leaderboard', 'eq', 0);
    }

    public function set_data($defaults) {

        if (!$this->block->user_can_edit() && !empty($this->block->config->title)) {
            // If a title has been set but the user cannot edit it format it nicely.
            $title = $this->block->config->title;
            $defaults->config_title = format_string($title, true, $this->page->context);
            // Remove the title from the config so that parent::set_data doesn't set it.
            unset($this->block->config->title);
        }

        // Have to delete text here, otherwise parent::set_data will empty content of editor.
        parent::set_data($defaults);
        // Restore $text.
        if (!isset($this->block->config)) {
            $this->block->config = new stdClass();
        }
        if (isset($title)) {
            // Reset the preserved title.
            $this->block->config->title = $title;
        }
    }
}
