define("tiny_stash/ui",["exports","core/modal_factory","core/modal_events","core/templates","editor_tiny/options","tiny_stash/options","jquery","tiny_stash/drop-add","tiny_stash/additem","tiny_stash/addtrade","tiny_stash/helptabs","tiny_stash/local/classes/snippetmaker","tiny_stash/webservice-calls","core/str","./options"],(function(_exports,_modal_factory,_modal_events,_templates,_options,_options2,_jquery,DropAdd,AddItem,AddTrade,Help,_snippetmaker,WebService,_str,_options3){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Tiny stash UI.
   *
   * @module      tiny_stash/ui
   * @copyright   2023 Adrian Greeve <adriangreeve.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.handleSubmit=_exports.handleInit=_exports.handleAction=void 0,_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_templates=_interopRequireDefault(_templates),_jquery=_interopRequireDefault(_jquery),DropAdd=_interopRequireWildcard(DropAdd),AddItem=_interopRequireWildcard(AddItem),AddTrade=_interopRequireWildcard(AddTrade),Help=_interopRequireWildcard(Help),_snippetmaker=_interopRequireDefault(_snippetmaker),WebService=_interopRequireWildcard(WebService);let itemsData={},tradeData={},Snippet={};_exports.handleAction=editor=>{displayDialogue(editor)};_exports.handleInit=editor=>async()=>{formatTradeInformation((0,_options2.getTradeDataFromEditor)(editor),(0,_options2.getItemDataFromEditor)(editor));const hashcodetoitem=Object.values((0,_options3.getDropDataFromEditor)(editor)).reduce(((c,v)=>({...c,[v.hashcode]:v})),{}),hashcodetotrade=Object.values(tradeData).reduce(((c,v)=>({...c,[v.hashcode]:v})),{}),allhashcodes=[...Object.keys(hashcodetoitem),...Object.keys(hashcodetotrade)],templategetters={stashdrop:data=>({template:"tiny_stash/item-preview",context:{...data,...data.image?{image:hashcodetoitem[data.secret].imageurl}:{}}}),stashtrade:data=>({template:"tiny_stash/trade-preview",context:{...hashcodetotrade[data.secret]}})},shortcodes=(0,_options2.getShortCodes)(editor).filter((shortcode=>templategetters.hasOwnProperty(shortcode))),regex=new RegExp("((?:<p>){0,1}\\[(?:".concat(shortcodes.join("|"),")[^\\]]*](?:<\\/p>){0,1})")),promises=editor.getContent().split(regex).map((segment=>{const trimmed=segment.replace(/^<p>|<\/p>$/g,"");return shortcodes.reduce(((c,v)=>c||trimmed.startsWith("[".concat(v))&&trimmed.endsWith("]")),!1)?(shortcode=>{const data=shortcode.matchAll(/(\w+)(?:=?"([^"]*)")?/g).reduce(((c,v)=>{var _v$;return{...c,[v[1]]:null!==(_v$=v[2])&&void 0!==_v$?_v$:v[1]}}),{});if(!allhashcodes.includes(data.secret))return Promise.resolve(shortcode);const{template:template,context:context}=templategetters[Object.keys(data)[0]](data);return _templates.default.renderForPromise(template,{shortcode:shortcode,...context}).then((preview=>preview.html))})(trimmed):Promise.resolve(segment)}));Promise.all(promises).then((rendered=>editor.setContent(rendered.join(""))))};_exports.handleSubmit=editor=>()=>{const tempcontainer=document.createElement("div"),content=editor.getContent();tempcontainer.innerHTML=content,tempcontainer.querySelectorAll(".tiny-stash-preview").forEach((stashitem=>{const shortcode=stashitem.querySelectorAll(".tiny-stash-shortcode")[0].textContent;stashitem.replaceWith(shortcode)})),tempcontainer.querySelectorAll(".tiny-stash-trade-preview").forEach((trade=>{const shortcode=trade.querySelectorAll(".tiny-stash-shortcode")[0].textContent;trade.replaceWith(shortcode)})),tempcontainer.querySelectorAll("[data-mce-bogus]").forEach((node=>node.parentNode.removeChild(node))),null===editor.getElement().closest("form").querySelector(".form-control.is-invalid")&&(editor.setContent(tempcontainer.innerHTML),editor.save())};const displayDialogue=async editor=>{let contextid=(0,_options.getContextId)(editor),data=await getDropData(contextid),courseid=(0,_options2.getCourseId)(editor);await updateItems(courseid),formatTradeInformation(data.trades,itemsData),0==Object.keys(itemsData).length?data.itemempty=!0:0==data.items.length?data.dropempty=!0:data.normal=!0,data.tradeavailable=data.trades.length>0,window.console.log(data);const modalPromises=await _modal_factory.default.create({title:(0,_str.get_string)("modalheading","tiny_stash"),type:_modal_factory.default.types.SAVE_CANCEL,body:_templates.default.render("tiny_stash/drop-code-selector",data),large:!0});modalPromises.show();const $root=await modalPromises.getRoot(),root=$root[0];$root.on(_modal_events.default.hidden,(()=>{modalPromises.destroy()})),$root.on(_modal_events.default.bodyRendered,(()=>{Help.init(),addTabListeners(),addDropListener(editor),data.normal&&(addAppearanceListener(),addTextAndImageListener());let additembuttons=document.querySelectorAll(".tiny-stash-add-item");for(let additembutton of additembuttons)additembutton.addEventListener("click",(e=>shiftAndMove(e,1,AddItem,editor,e.currentTarget.dataset.location)));document.querySelector(".tiny-stash-add-trade").addEventListener("click",(e=>shiftAndMove(e,3,AddTrade,editor))),(0,_jquery.default)(".carousel").on("slide.bs.carousel",(async()=>{if("Saved"==DropAdd.getStatus()){data=await getDropData(contextid);const zerostatenode=document.querySelector(".tiny-stash-zero-state");zerostatenode&&_templates.default.render("tiny_stash/local/tabs/drop-form",data).then(((html,js)=>{const parentnode=zerostatenode.parentNode;parentnode.removeChild(zerostatenode),_templates.default.appendNodeContents(parentnode,html,js),addAppearanceListener(),addTextAndImageListener()})),_templates.default.render("tiny_stash/drop-select",data).then(((html,js)=>{let selectnode=document.querySelector(".tiny-stash-drop-select");_templates.default.replaceNodeContents(selectnode,html,js);let selectitemnode=document.querySelector(".tiny-stash-item-select");for(let i=0;i<selectitemnode.options.length;i++){let option=selectitemnode.options[i];option.dataset.hash==DropAdd.SavedIndex&&(option.selected=!0,setPreview(option.dataset.id,option.dataset.hash))}})),DropAdd.setStatus("Clear")}if("Saved"==AddItem.getStatus()){if(data.itemempty){if(0==data.items.length){data.dropempty=!0;const contentnode=document.querySelector(".tiny-stash-zero-state");AddItem.removeChildren(contentnode);const messageheader=document.createElement("h3");messageheader.innerText=await(0,_str.get_string)("locationneeded","tiny_stash");const messagenode=document.createElement("p");messagenode.innerText=await(0,_str.get_string)("nolocations","tiny_stash"),contentnode.appendChild(messageheader),contentnode.appendChild(messagenode),document.querySelector(".tiny-stash-add-drop").attributes.removeNamedItem("disabled")}data.itemempty=!1}updateItems(courseid),AddItem.setStatus("Clear")}if("Saved"==AddTrade.getStatus()){await updateItems(courseid),data=await getDropData(contextid),formatTradeInformation(data.trades,itemsData);const zerostatenode=document.querySelector(".tiny-stash-zero-state-trade");zerostatenode&&_templates.default.render("tiny_stash/local/tabs/trade-form",data).then(((html,js)=>{const parentnode=zerostatenode.parentNode;parentnode.removeChild(zerostatenode),_templates.default.appendNodeContents(parentnode,html,js)})),_templates.default.render("tiny_stash/local/selectors/trade-drop-selector",data).then(((html,js)=>{let selectnode=document.querySelector(".tiny-stash-trade-select");_templates.default.replaceNodeContents(selectnode,html,js);let selectitemnode=document.querySelector(".tiny-stash-trade-selector");for(let i=0;i<selectitemnode.options.length;i++){let option=selectitemnode.options[i];option.dataset.hash==AddTrade.TradeHash&&(option.selected=!0,setTradePreview(option.dataset.hash))}})),AddTrade.setStatus("ready")}}))})),$root.on(_modal_events.default.save,(()=>{const previewnodeclasssuffix="items"==document.querySelector('[aria-selected="true"][data-tiny-stash]').getAttribute("aria-controls")?"preview":"trade-preview",previewnode=document.querySelector(".tiny-stash-"+previewnodeclasssuffix).cloneNode(!0);editor.execCommand("mceInsertContent",!1,previewnode.outerHTML)})),root.addEventListener("click",(event=>{let element=event.target,elementtype=element.dataset.type;if("OPTION"===element.nodeName&&"item"==elementtype&&setPreview(element.dataset.id,element.dataset.hash),"OPTION"===element.nodeName&&"trade"==elementtype){let codearea=document.getElementsByClassName("tiny-stash-trade-code"),dropcode='[stashtrade secret="'+element.dataset.hash+'"]';codearea[0].innerText=dropcode,setTradePreview(element.dataset.hash)}}))},updateItems=async courseid=>{itemsData={};let itemdata=await getItemData(courseid);itemdata.items&&itemdata.items.forEach((item=>{itemsData[item.id]=item}))},addTabListeners=()=>{document.querySelectorAll(".tiny-stash-tabs").forEach((tabnode=>{tabnode.addEventListener("click",(e=>{if("help-tab"==e.currentTarget.children[0].attributes.id.value)return;document.querySelector('button[data-action="save"]')||_templates.default.render("tiny_stash/local/footers/main-footer",{}).then(((html,js)=>{let modalfooter=document.querySelector(".modal-footer");AddItem.removeChildren(modalfooter),_templates.default.appendNodeContents(modalfooter,html,js)}))}))}))},addDropListener=editor=>{document.getElementsByClassName("tiny-stash-add-drop")[0].addEventListener("click",(e=>shiftAndMove(e,2,DropAdd,itemsData,editor)))},addAppearanceListener=()=>{document.querySelector(".tiny-stash-appearance").addEventListener("change",(e=>{let selectedelement=e.target.selectedOptions[0];"text"==selectedelement.value&&(document.querySelector(".snippet-label").classList.remove("d-none"),document.querySelector(".snippet-actiontext").classList.add("d-none")),"image"==selectedelement.value&&(document.querySelector(".snippet-label").classList.add("d-none"),document.querySelector(".snippet-actiontext").classList.add("d-none")),"imageandbutton"==selectedelement.value&&(document.querySelector(".snippet-label").classList.add("d-none"),document.querySelector(".snippet-actiontext").classList.remove("d-none"));let itemselect=document.querySelector(".tiny-stash-item-select").selectedOptions[0];setPreview(itemselect.dataset.id,itemselect.dataset.hash)}))},addTextAndImageListener=()=>{document.querySelector('input[name="actiontext"]').addEventListener("keyup",(e=>{if(!document.querySelector(".block-stash-item"))return;let previewnode=document.querySelector("#item .preview"),buttontext=e.currentTarget.value;previewnode.querySelector(".tiny-stash-button-preview").innerText=buttontext;let codearea=document.querySelector(".tiny-stash-item-code"),shortcodearea=previewnode.querySelector(".tiny-stash-shortcode");Snippet.setText(buttontext),codearea.innerText=Snippet.getImageAndText(),shortcodearea.innerText=Snippet.getImageAndText()})),document.querySelector('input[name="label"]').addEventListener("keyup",(()=>{if(!document.querySelector(".block-stash-item"))return;let itemnode=document.querySelector(".tiny-stash-item-select");setPreview(itemnode.selectedOptions[0].dataset.id,itemnode.selectedOptions[0].dataset.hash)}))},setPreview=(itemid,hashcode)=>{let appearanceselector=document.querySelector(".tiny-stash-appearance"),codearea=document.getElementsByClassName("tiny-stash-item-code"),buttontext="";buttontext="text"===appearanceselector.value?document.querySelector('input[name="label"]').value:document.querySelector('input[name="actiontext"]').value,Snippet=new _snippetmaker.default(hashcode,itemsData[itemid].name),Snippet.setText(buttontext),"imageandbutton"===appearanceselector.value?codearea[0].innerText=Snippet.getImageAndText():"image"===appearanceselector.value?codearea[0].innerText=Snippet.getImage():codearea[0].innerText=Snippet.getText();let previewnode=document.querySelector("#item .preview");previewnode.children.forEach((child=>previewnode.removeChild(child)));const templatedata={image:["imageandbutton","image"].includes(appearanceselector.value)?itemsData[itemid].imageurl:null,text:["imageandbutton","text"].includes(appearanceselector.value)?buttontext:null,shortcode:codearea[0].innerText};_templates.default.renderForPromise("tiny_stash/item-preview",templatedata).then((preview=>{_templates.default.replaceNodeContents(previewnode,preview.html,preview.js)}))},formatTradeInformation=(tradedata,itemdata)=>{let data={};for(let tradedatum of tradedata){data[tradedatum.tradeid]={tradeid:tradedatum.tradeid,name:tradedatum.name,gaintitle:tradedatum.gaintitle,losstitle:tradedatum.losstitle,hashcode:tradedatum.hashcode,additems:[],lossitems:[]};for(let gainitem of tradedatum.additems)gainitem&&data[tradedatum.tradeid].additems.push({itemid:gainitem.itemid,quantity:gainitem.quantity,name:itemdata[gainitem.itemid].name,imageurl:itemdata[gainitem.itemid].imageurl});for(let lossitem of tradedatum.lossitems)lossitem&&data[tradedatum.tradeid].lossitems.push({itemid:lossitem.itemid,quantity:lossitem.quantity,name:itemdata[lossitem.itemid].name,imageurl:itemdata[lossitem.itemid].imageurl})}tradeData=data},setTradePreview=hashcode=>{let dropcode='[stashtrade secret="'+hashcode+'"]',selecteditem={};document.getElementsByClassName("tiny-stash-trade-code")[0].innerText=dropcode;for(let tradeinfo of Object.entries(tradeData))if(tradeinfo[1].hashcode==hashcode){selecteditem=tradeinfo[1];break}let tradepreviewnode=document.querySelector("#trade .preview");AddItem.removeChildren(tradepreviewnode),_templates.default.render("tiny_stash/trade-preview",{...selecteditem,shortcode:dropcode}).then(((html,js)=>{_templates.default.replaceNodeContents(tradepreviewnode,html,js)}))},shiftAndMove=function(e,carousellocation,func){e.preventDefault(),(0,_jquery.default)(".carousel").carousel(carousellocation),(0,_jquery.default)(".carousel").carousel("pause");for(var _len=arguments.length,args=new Array(_len>3?_len-3:0),_key=3;_key<_len;_key++)args[_key-3]=arguments[_key];func.init(...args)},getDropData=async contextid=>{try{return await WebService.getAllDropData(contextid)}catch(e){return{}}},getItemData=async courseid=>{try{return await WebService.getAllItemData(courseid)}catch(e){return{}}}}));

//# sourceMappingURL=ui.min.js.map