<?php
// This file is part of local_checkmarkreport for Moodle - http://moodle.org/
//
// It is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// It is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The local_checkmarkreport_overview_exported event.
 *
 * @package   local_checkmarkreport
 * @author    Philipp Hager
 * @copyright 2014 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_checkmarkreport\event;

/**
 * Event class for exported overview reports
 *
 * @package   local_checkmarkreport
 * @author    Philipp Hager
 * @copyright 2014 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class overview_exported extends exported_base {
    /**
     * Static convenience method to create event from objects
     *
     * @param \stdClass $course course object
     * @param int $format export format (local_checkmarkreport_base::FORMAT_XLSX, local_checkmarkreport_base::FORMAT_ODS,
     *                                   local_checkmarkreport_base::FORMAT_XML, local_checkmarkreport_base::FORMAT_TXT)
     * @param string $formatreadable human readable representation of export format
     * @return overview_exported event object
     */
    public static function overview(\stdClass $course, $format, $formatreadable) {
        $event = self::create([
                'context' => \context_course::instance($course->id),
                'other' => ['tab' => 'overview', 'format' => $format, 'format_readable' => $formatreadable],
        ]);

        return $event;
    }

    /**
     * Return localised event name.
     *
     * @return string
     */
    public static function get_name() {
        return get_string('eventoverviewexported', 'local_checkmarkreport');
    }
}
