<?php
// This file is part of local_checkmarkreport for Moodle - http://moodle.org/
//
// It is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// It is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Contains local_checkmarkreport_useroverview class (handling checkmarkreport useroverview content)
 *
 * @package   local_checkmarkreport
 * @author    Philipp Hager
 * @copyright 2014 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * local_checkmarkreport_useroverview class, handles checkmarkreport useroverview content
 *
 * @package   local_checkmarkreport
 * @author    Philipp Hager
 * @copyright 2014 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class local_checkmarkreport_userview extends local_checkmarkreport_useroverview implements renderable {

    /** @var string classes to assign to the reporttables */
    protected $tableclass = 'table table-condensed table-bordered userview';

    /**
     * Constructor
     *
     * @param int $id course id
     */
    public function __construct($id) {
        global $USER;
        set_user_preference('checkmarkreport_showgrade', 1);
        set_user_preference('checkmarkreport_sumabs', 1);
        set_user_preference('checkmarkreport_sumrel', 1);
        set_user_preference('checkmarkreport_showexamples', 1);
        set_user_preference('checkmarkreport_showattendances', 1);
        set_user_preference('checkmarkreport_showpresentationgrades', 1);
        set_user_preference('checkmarkreport_showpresentationcount', 1);
        parent::__construct($id, [0], [0], [$USER->id]);
    }
}
