/**
 * Handles filtering of items on download center page
 *
 * @module        local_downloadcenter/modfilter
 * @author        Simeon Naydenov (moniNaydenov@gmail.com)
 * @copyright     2022 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license       http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_downloadcenter/modfilter",["jquery","core/str","core/url"],(function($,Str,url){const ModFilter=function(modnames){const instance=this;this.modnames=modnames,this.strings={},this.formid=null,this.currentlyshown=!1,this.modlist=null,Str.get_strings([{key:"all",component:"moodle"},{key:"none",component:"moodle"},{key:"select",component:"moodle"},{key:"showtypes",component:"backup"},{key:"hidetypes",component:"backup"}]).done((function(strs){instance.strings.all=strs[0],instance.strings.none=strs[1],instance.strings.select=strs[2],instance.strings.showtypes=strs[3],instance.strings.hidetypes=strs[4];const firstsection=$('div[role="main"] > form .card.block').first();instance.formid=firstsection.closest("form").prop("id");const showTypeOptionsLink='<span class="font-weight-bold ml-3 text-nowrap">(<a id="downloadcenter-bytype" href="#">'+instance.strings.showtypes+"</a>)</span>";let html=instance.htmlGenerator("included",instance.strings.select),links=$(document.createElement("div"));links.addClass("grouped_settings section_level block card"),links.html(html),links.find(".downloadcenter_selector .col-md-9").append(showTypeOptionsLink),links.insertBefore(firstsection),instance.modlist=$(document.createElement("div")),instance.modlist.prop("id","mod_select_links"),instance.modlist.prop("class","m-l-2"),instance.modlist.appendTo(links),instance.modlist.hide();for(let mod in instance.modnames){if(!instance.modnames.hasOwnProperty(mod))continue;const img='<img src="'+url.imageUrl("icon","mod_"+mod)+'" class="activityicon" />';html=instance.htmlGenerator("mod_"+mod,img+instance.modnames[mod]);const modlinks=$(document.createElement("div"));modlinks.addClass("grouped_settings section_level"),modlinks.html(html),modlinks.appendTo(instance.modlist),instance.initlinks(modlinks,mod)}$("#downloadcenter-all-included").click((function(e){instance.helper(e,!0,"item_")})),$("#downloadcenter-none-included").click((function(e){instance.helper(e,!1,"item_")})),$("#downloadcenter-bytype").click((function(e){e.preventDefault(),instance.toggletypes()})),$("input.form-check-input").click((function(){instance.checkboxhandler($(this)),instance.updateFormState()}))}))};return ModFilter.prototype.checkboxhandler=function($checkbox){const name=$checkbox.prop("name"),checked=$checkbox.prop("checked");if("item_"===name.substring(0,"item_".length)){let $parent=$checkbox.parentsUntil("form",".card");$parent.length>1&&($parent=$parent.first()),"item_topic"===name.substring(0,"item_topic".length)?$parent.find("input.form-check-input").prop("checked",checked):checked&&$parent.find('input.form-check-input[name^="item_topic"]').prop("checked",!0)}},ModFilter.prototype.updateFormState=function(){this.formid&&M.form&&M.form.updateFormState&&M.form.updateFormState(this.formid)},ModFilter.prototype.toggletypes=function(){const link=$("#downloadcenter-bytype");this.currentlyshown?link.text(this.strings.showtypes):link.text(this.strings.hidetypes),this.modlist.animate({height:"toggle"},500,"swing"),this.currentlyshown=!this.currentlyshown},ModFilter.prototype.initlinks=function(links,mod){const instance=this;$("#downloadcenter-all-mod_"+mod).click((function(e){instance.helper(e,!0,"item_",mod)})),$("#downloadcenter-none-mod_"+mod).click((function(e){instance.helper(e,!1,"item_",mod)}))},ModFilter.prototype.helper=function(e,check,type,mod){e.preventDefault();let prefix="";void 0!==mod&&(prefix="item_"+mod+"_");const len=type.length;$('input[type="checkbox"]').each((function(i,checkbox){const name=(checkbox=$(checkbox)).prop("name");prefix&&name.substring(0,prefix.length)!==prefix||(name.substring(0,len)===type&&checkbox.prop("checked",check),check&&checkbox.closest(".card.block").find('.fitem:first-child input[type="checkbox"]').prop("checked",check))})),this.updateFormState()},ModFilter.prototype.htmlGenerator=function(idtype,heading){let links='<a id="downloadcenter-all-'+idtype+'" href="#">'+this.strings.all+"</a> / ";return links+='<a id="downloadcenter-none-'+idtype+'" href="#">'+this.strings.none+"</a>",this.rowGenerator(heading,links)},ModFilter.prototype.rowGenerator=function(heading,content){let ret='<div class="form-group row fitem downloadcenter_selector">';return ret+='<div class="col-md-3"></div>',ret+='<div class="col-md-9">',ret+='<label><span class="itemtitle">'+heading+"</span></label>",ret+='<span class="text-nowrap">'+content+"</span>",ret+="</div>",ret+="</div>",ret},{init:function(modnames){return new ModFilter(modnames)}}}));

//# sourceMappingURL=modfilter.min.js.map