/**
 * Javascript for group administration (rename, resize, toggle and deletion)
 *
 * @module   mod_grouptool/administration
 * @author    Philipp Hager
 * @copyright 2014 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_grouptool/administration",["jquery","core/templates","core/ajax","core/str","core/url","core/notification","core/log"],(function($,templates,ajax,str,murl,notif,log){var Administration=function(){this.cmid=0,this.filter=null,this.filterall=null,this.globalsize=3};Administration.prototype.renamegroup=function(e){log.info("Rename Group!","grouptool"),e.preventDefault(),e.stopPropagation();var context={},requests=[],target=$(e.target).closest("[data-rename]"),node=target.closest("tr"),grpid=node.data("id"),button=target,field=button.prevAll("input[type=hidden]"),text=button.prevAll("span.text"),infoNode="";button.fadeOut(600),field.fadeOut(600),text.fadeOut(600,(function(){field.attr("type","text"),field.fadeIn(600),field.focus(),field.select()})),field.on("keydown",null,e.data,(function(e){13!==e.which&&27!==e.which||(e.preventDefault(),e.stopPropagation()),13===e.which?(requests=ajax.call([{methodname:"mod_grouptool_rename_group",args:{cmid:e.data.cmid,groupid:grpid,name:field.val()},fail:notif.exception}]),infoNode&&(infoNode.fadeOut(600),infoNode.remove()),requests[0].then((function(result){return result.error?(context={message:result.error},templates.render("core/notification_error",context).then((function(html){return(infoNode=$(html)).hide(),node.find(".grpname div").prepend(infoNode),infoNode.fadeIn(600),window.setTimeout((function(){infoNode.fadeOut(600,(function(){infoNode.remove()}))}),6e4),this})).fail(notif.exception)):(context={message:result.message},templates.render("core/notification_success",context).then((function(){return text.html(field.val()),field.fadeOut(600,(function(){field.attr("value",field.val()),field.attr("type","hidden"),text.fadeIn(600),button.fadeIn(600)})),field.off("keydown"),this})).fail(notif.exception),log.info("AJAX Call to rename group "+grpid+" successfull\n"+status,"grouptool")),this})).fail(notif.exception)):27===e.which&&(field.fadeOut(600,(function(){text.hide(),field.attr("type","hidden"),field.val(text.html()),field.attr("value",text.html()),text.fadeIn(600),button.fadeIn(600)})),infoNode&&infoNode.fadeOut(600,(function(){infoNode.remove()})),field.unbind("key"))}))},Administration.prototype.resizegroup=function(e){log.info("Resize Group!","grouptool"),e.preventDefault(),e.stopPropagation();var target=$(e.target).closest("[data-resize]"),node=target.closest("tr"),grpid=node.data("id"),cmid=e.data.instance.cmid,strings=e.data.strings,globalsize=e.data.globalsize,button=target,field=button.prevAll("input[type=hidden]"),text=button.prevAll("span.text"),infoNode="",helpNode="",context={},requests=[];button.fadeOut(600),field.fadeOut(600),text.fadeOut(600,(function(){field.attr("type","text"),field.fadeIn(600),field.focus(),field.select();var context={message:strings.resizehelp};templates.render("core/notification_info",context).then((function(html){return log.info("Helpnode fade in!","grouptool"),(helpNode=$(html)).hide(),node.find(".size div").prepend(helpNode),helpNode.fadeIn(600),this})).fail(notif.exception)})),field.on("keydown",null,null,(function(e){if(13!==e.which&&27!==e.which||(e.preventDefault(),e.stopPropagation()),13===e.which)log.info("Enter was pressed!","grouptool"),requests=ajax.call([{methodname:"mod_grouptool_resize_group",args:{cmid:parseInt(cmid),groupid:grpid,size:field.val()},fail:notif.exception}]),infoNode&&(log.info("Remove info node!","grouptool"),infoNode.fadeOut(600),infoNode.remove()),helpNode&&(log.info("Remove help node!","grouptool"),helpNode.fadeOut(600),helpNode.remove()),requests[0].then((function(result){return result.error?(context={message:result.error},templates.render("core/notification_error",context).then((function(html){return(infoNode=$(html)).hide(),node.find(".size div").prepend(infoNode),infoNode.fadeIn(600),log.info("Fade in info node error!","grouptool"),window.setTimeout((function(){log.info("Fade out info node error!","grouptool"),infoNode.fadeOut(600,(function(){infoNode.remove()}))}),5e3),this})).fail(notif.exception)):(context={message:result.message},templates.render("core/notification_success",context).then((function(html){(infoNode=$(html)).hide(),node.find(".size div").prepend(infoNode),infoNode.fadeIn(600),log.info("Fade in info node success!","grouptool");var newvalue=field.val();return""===newvalue?text.html(globalsize+"*"):text.html(newvalue),field.fadeOut(600,(function(){field.attr("value",field.val()),field.attr("type","hidden"),text.fadeIn(600),button.fadeIn(600),field.off("keydown")})),window.setTimeout((function(){infoNode.fadeOut(600,(function(){log.info("Fade out info node success!","grouptool"),infoNode.remove()}))}),5e3),field.off("keydown"),this})).fail(notif.exception)),log.info("AJAX Call to resize group "+grpid+" successfull\n"+status,"grouptool"),this})).fail(notif.exception);else if(27===e.which)return log.info("Escape was pressed!","grouptool"),field.fadeOut(600,(function(){text.hide(),field.attr("type","hidden"),text.fadeIn(600),button.fadeIn(600)})),infoNode&&infoNode.fadeOut(600,(function(){infoNode.remove()})),helpNode&&helpNode.fadeOut(600,(function(){helpNode.remove()})),field.off("keydown"),log.info("Return this!","grouptool"),this}))},Administration.prototype.togglegroup=function(e){e.preventDefault(),e.stopPropagation();var context={},target=$(e.target).closest("[data-toggle]"),node=target.closest("tr"),grpid=node.data("id");log.info("TOGGLE GROUP "+grpid,"grouptool");var status=node.data("status");1===status||!0===status?(log.info("DEACTIVATE GROUP "+grpid+"!","grouptool"),ajax.call([{methodname:"mod_grouptool_deactivate_group",args:{cmid:e.data.cmid,groupid:grpid},fail:notif.exception}])[0].then((function(result){if(result.error){var text="AJAX Call to deactivate group "+grpid+" successfull but error occured:\n";log.info(text+result.error+"\n"+status,"grouptool")}else{if("active"===e.data.filter)node.find("td div").slideUp(600).promise().done((function(){if(node.remove(),!$("tbody.mod_grouptool_sortlist_body tr").length){log.info("No more groups in sortlist! "+$("tbody.mod_grouptool_sortlist_body tr").length,"grouptool");str.get_strings([{key:"nogroupsactive",component:"mod_grouptool"},{key:"nogroupschoose",component:"mod_grouptool"}]).done((function(s){var link='<a href="'+murl.relativeUrl("/mod/grouptool/administration.php",{id:e.data.cmid,tab:"group_administration",filter:e.data.filterall})+'">'+s[1]+"</a>",context={message:s[0]+link},sortlistcontainer=$("div.mod_grouptool_sortlist");sortlistcontainer.fadeOut(600,(function(){templates.render("core/notification_info",context).then((function(html){return sortlistcontainer.html(html),sortlistcontainer.fadeIn(600),this})).fail(notif.exception)}))})).fail(notif.exception)}})).fail(notif.exception);else{var viewparams={id:e.data.cmid,tab:"administration"};context={status:!1,missing:!1,groupings:target.closest("tr").data("groupings"),id:grpid,grouppix:target.closest("tr").find(".grouppix").html(),checked:target.closest("tr").find("input[type=checkbox]").prop("checked"),name:target.closest("tr").data("name"),pageurl:murl.relativeUrl("/mod/grouptool/view.php",viewparams,!1),order:target.closest("tr").data("order"),usesize:!!e.data.usesize,size:target.closest("tr").data("size")},templates.render("mod_grouptool/sortlist_entry",context).then((function(html){var newnode=$(html);return node.replaceWith(newnode),newnode.find("[data-drag]").removeClass("js_invisible").css("cursor","pointer"),node=newnode,this})).fail(notif.exception)}log.info("AJAX Call to deactivate group "+grpid+" successfull\n"+result.message+"\n"+status,"grouptool")}return this})).fail(notif.exception)):0===status||!1===status?(log.info("ACTIVATE GROUP "+grpid+"!","grouptool"),ajax.call([{methodname:"mod_grouptool_activate_group",args:{cmid:e.data.cmid,groupid:grpid},fail:notif.exception}])[0].then((function(result){if(result.error){var text="AJAX Call to activate group "+grpid+" successfull but error occured:\n";log.info(text+result.error+"\n"+status,"grouptool")}else{if("inactive"===e.data.filter)node.find("td div").slideUp(600).promise().done((function(){if(node.remove(),!$("tbody.mod_grouptool_sortlist_body tr").length){str.get_strings([{key:"nogroupsinactive",component:"mod_grouptool"},{key:"nogroupschoose",component:"mod_grouptool"}]).done((function(s){var link='<a href="'+murl.relativeUrl("/mod/grouptool/administration.php",{id:e.data.cmid,tab:"group_administration",filter:e.data.filterall})+'">'+s[1]+"</a>";context={message:s[0]+" "+link};var sortlistcontainer=$("div.mod_grouptool_sortlist");sortlistcontainer.fadeOut(600,(function(){templates.render("core/notification_info",context).then((function(html){return sortlistcontainer.html(html),sortlistcontainer.fadeIn(600),this})).fail(notif.exception)}))})).fail(notif.exception)}}));else{var viewparams={id:e.data.cmid,tab:"administration"};context={status:!0,missing:!1,groupings:node.data("groupings"),id:grpid,grouppix:target.closest("tr").find(".grouppix").html(),checked:node.find("input[type=checkbox]").prop("checked"),name:node.data("name"),pageurl:murl.relativeUrl("/mod/grouptool/view.php",viewparams,!1),order:node.data("order"),usesize:!!e.data.usesize,size:node.data("size")},templates.render("mod_grouptool/sortlist_entry",context).then((function(html){var newnode=$(html);return node.replaceWith(newnode),newnode.find("[data-drag]").removeClass("js_invisible").css("cursor","pointer"),node=newnode,this})).fail(notif.exception)}log.info("AJAX Call to activate group "+grpid+" successfull\n"+result.message,"grouptool")}return this})).fail(notif.exception)):log.error("Group with id "+grpid+" must have either status 1 or 0!","grouptool")},Administration.prototype.deletegroup=function(e){if(e.preventDefault(),e.stopPropagation(),!$(e.target).closest("[data-delete]").hasClass("disabled")){var node=$(e.target).closest("[data-delete]").closest("tr"),grpid=node.data("id"),strings=e.data.strings;notif.confirm(strings.title,strings.confirm,strings.yes,strings.no,(function(){grpid?(log.info("DELETE GROUP "+grpid+"!","grouptool"),ajax.call([{methodname:"mod_grouptool_delete_group",args:{cmid:e.data.cmid,groupid:grpid},fail:notif.exception}])[0].then((function(result){return notif.fetchNotifications(),result.error?notif.exception(result.error):node.find("td div").slideUp(600).promise().done((function(){node.remove()})),log.info("AJAX Call to delete group "+grpid+" successfull\n"+status,"grouptool"),this})).fail(notif.exception)):log.info("No Group ID!","grouptool")}))}};var instance=new Administration;return instance.initializer=function(cmid,filter,filterall,globalsize,usesize){this.cmid=cmid,this.filter=filter,this.filterall=filterall,this.globalsize=globalsize,this.usesize=usesize,this.resizeflag=!1,log.info("Initialize Grouptool group administration","grouptool"),$(".path-mod-grouptool").on("click","tr[data-id] a[data-rename]",this,this.renamegroup),log.debug("Init edit size button","grouptool"),str.get_strings([{key:"ajax_edit_size_help",component:"mod_grouptool"}]).done((function(s){var strings={resizehelp:s[0]};log.debug("String successfully retrieved: "+s,"grouptool");var resizedata={instance:instance,strings:strings,globalsize:instance.globalsize};$(".path-mod-grouptool").on("click","tr[data-id] a[data-resize]",resizedata,instance.resizegroup)})).fail((function(ex){log.error("Error while retrieving string: "+ex,"grouptool")}));str.get_strings([{key:"confirm_delete_title",component:"mod_grouptool"},{key:"confirm_delete",component:"mod_grouptool"},{key:"yes",component:"moodle"},{key:"no",component:"moodle"}]).done((function(s){log.info("Strings successfully retrieved: "+s,"grouptool");var strings={title:s[0],confirm:s[1],yes:s[2],no:s[3]};$(".path-mod-grouptool .mod_grouptool_sortlist").on("click","tr[data-id] a[data-delete]",{cmid:instance.cmid,strings:strings},instance.deletegroup)})).fail((function(ex){log.error("Error while retrieving strings: "+ex,"grouptool")})),$(".path-mod-grouptool .mod_grouptool_sortlist").on("click","tr[data-id] a[data-toggle]",this,this.togglegroup)},instance}));

//# sourceMappingURL=administration.min.js.map