/**
 * Javascript for sortable groups-list
 *
 * @module   mod_grouptool/sortlist
 * @author    Anne Kreppenhofer
 * @copyright 2025 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_grouptool/sortlist",["jquery","jqueryui","core/ajax","core/templates","core/str","core/log","core/notification"],(function($,jqui,ajax,templates,str,log,notif){var Sortlist=function(){this.cmid=0};Sortlist.prototype.dragStartHandler=function(e,ui){ui.helper.find("a[data-movedown], a[data-moveup]").css("visibility","visible")},Sortlist.prototype.dragEndHandler=function(e){var neworderparams=[],sortlistEntries=$(".mod_grouptool_sortlist_body .mod_grouptool_sortlist_entry");(sortlistEntries.find("a[data-movedown], a[data-moveup]").css("visibility","visible"),sortlistEntries.first().find("a[data-moveup]").css("visibility","hidden"),sortlistEntries.last().find("a[data-movedown]").css("visibility","hidden"),sortlistEntries.each((function(index){$(this).attr("order",index+1),$(this).find('input[name="order['+$(this).data("id")+']"]').val(index+1),neworderparams.push({groupid:$(this).data("id"),order:index+1})})),""!==neworderparams)&&ajax.call([{methodname:"mod_grouptool_reorder_groups",args:{cmid:e.data.cmid,order:neworderparams},fail:notif.exception}])[0].then((function(result){var context={message:"",extraclasses:"infonode"},template="core/notification_success",autoFadeOut=5e3;return result.error?(template="core/notification_error",context.message=result.error,autoFadeOut=6e4,log.info("AJAX Call to reorder groups successfull\nError ocured:"+result.error+"\n"+status,"grouptool"),templates.render(template,context).then((function(html){var infoNode=$(html);return infoNode.hide(0),$("table.drag_list").before(infoNode),infoNode.slideDown(600,(function(){window.setTimeout((function(){infoNode.slideUp(600,(function(){infoNode.remove()}))}),autoFadeOut)})),this})).fail(notif.exception)):(context.message=result.message,log.info("AJAX Call to reorder groups successfull\n"+result.message+"\n"+status,"grouptool")),this})).fail(notif.exception)},Sortlist.prototype.moveDown=function(e){var target=$(e.target),nodeA=target.closest(".mod_grouptool_sortlist_entry"),nodeB=target.closest(".mod_grouptool_sortlist_entry").next(".mod_grouptool_sortlist_entry"),thisOrder=nodeA.data("order"),otherOrder=nodeB.data("order");e.preventDefault(),e.stopPropagation(),ajax.call([{methodname:"mod_grouptool_swap_groups",args:{cmid:e.data.cmid,a:nodeA.data("id"),b:nodeB.data("id")},fail:notif.exception}])[0].then((function(result){return result.error?notif.exception(result.error):(nodeB.after(nodeA.clone(!0)),nodeA.replaceWith(nodeB),nodeA.data("order",otherOrder),nodeA.find('input[name="order['+nodeA.data("id")+']"]').val(otherOrder),nodeB.data("order",thisOrder),nodeB.find('input[name="order['+nodeB.data("id")+']"]').val(thisOrder),log.info(result.message)),this})).fail(notif.exception)},Sortlist.prototype.moveUp=function(e){var target=$(e.target),nodeA=target.closest(".mod_grouptool_sortlist_entry"),nodeB=target.closest(".mod_grouptool_sortlist_entry").prev(".mod_grouptool_sortlist_entry"),thisOrder=nodeA.data("order"),otherOrder=nodeB.data("order");e.preventDefault(),e.stopPropagation(),ajax.call([{methodname:"mod_grouptool_swap_groups",args:{cmid:e.data.cmid,a:nodeA.data("id"),b:nodeB.data("id")},fail:notif.exception}])[0].then((function(result){return result.error?notif.exception(result.error):(nodeB.before(nodeA.clone(!0)),nodeA.replaceWith(nodeB),nodeA.data("order",otherOrder),nodeA.find('input[name="order['+nodeA.data("id")+']"]').val(otherOrder),nodeB.data("order",thisOrder),nodeB.find('input[name="order['+nodeB.data("id")+']"]').val(thisOrder),log.info(result.message)),this})).fail(notif.exception)};var instance=new Sortlist;return instance.initializer=function(cmid){instance.cmid=cmid,log.info("Initialize Grouptool sortlist","grouptool"),$(".path-mod-grouptool .mod_grouptool_sortlist .mod_grouptool_sortlist_body").sortable({containment:".mod_grouptool_sortlist .mod_grouptool_sortlist_body",cursor:"move",delay:150,handle:"[data-drag]",items:" .mod_grouptool_sortlist_entry",opacity:.5,helper:"clone",axis:"y",start:instance.dragStartHandler,stop:function(e){e.data=instance,instance.dragEndHandler(e)}});var dragnodes=$(".path-mod-grouptool .mod_grouptool_sortlist tr[data-id] [data-drag]");$(".path-mod-grouptool .mod_grouptool_sortlist tr .js_invisible").removeClass("js_invisible"),dragnodes.removeClass("js_invisible"),dragnodes.css("cursor","pointer");var sortlistnode=$(".path-mod-grouptool .mod_grouptool_sortlist");sortlistnode.on("click","tr[data-id] a[data-movedown]",this,instance.moveDown),sortlistnode.on("click","tr[data-id] a[data-moveup]",this,instance.moveUp);var checkboxControlsAction=$('button[name="do_class_action"]');checkboxControlsAction?(require(["mod_grouptool/multiseltoggle"],(function(toggle){var select=$('select[name="classes[]"]');toggle.enable(select.get()[0])})),checkboxControlsAction.on("click",(function(e){var newstate="";$('input[name="class_action"]').each((function(idx,current){!0===$(current).prop("checked")&&(newstate=$(current).val(),log.info("Update checkboxes '"+newstate+"'!"),instance.updateCheckboxes(e,newstate))}))}))):log.info("No sortlist controller found!","grouptool"),$(".simple_select_all").on("click",(function(e){log.info("Bind select-all handler!","grouptool"),e.preventDefault(),e.stopPropagation(),$(".class0").prop("checked",!0)})),$(".simple_select_none").on("click",(function(e){log.info("Bind deselect-all handler!","grouptool"),e.preventDefault(),e.stopPropagation(),$(".class0").prop("checked",!1)}))},instance}));

//# sourceMappingURL=sortlist.min.js.map