<?php
// This file is part of mod_offlinequiz for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Internal library of functions for participants_corner
 *
 *
 *
 * @package       mod_offlinequiz
 * @subpackage    offlinequiz
 * @author        Thomas Wedekind <Thomas.Wedekind@univie.ac.at>
 * @copyright     2019 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @since         Moodle 3.8+
 * @license       http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
/**
 *
 * @author Thomas Wedekind <Thomas.Wedekind@univie.ac.at>
 *
 */
class mod_offlinequiz_corners {
    /**
     * upperleft corner
     * @var mod_offlinequiz_corners
     */
    private $upperleft;
    /**
     * upper right corner
     * @var mod_offlinequiz_corners
     */
    private $upperright;
    /**
     * lowerleft
     * @var mod_offlinequiz_corners
     */
    private $lowerleft;
    /**
     * lower right
     * @var mod_offlinequiz_corners
     */
    private $lowerright;
    /**
     * constructor
     * @param mixed $upperleft
     * @param mixed $upperright
     * @param mixed $lowerleft
     * @param mixed $lowerright
     */
    public function __construct($upperleft, $upperright, $lowerleft, $lowerright) {
        $this->upperleft = $upperleft;
        $this->upperright = $upperright;
        $this->lowerleft = $lowerleft;
        $this->lowerright = $lowerright;
    }
    /**
     *
     * @param string $cornerid id of the form uly (upperleft y value)
     */
    public function get_corner_value($cornerid) {
        $position = substr($cornerid, 0, 2);
        if ($position == 'ul') {
            $corner = $this->upperleft;
        } else if ($position == 'ur') {
            $corner = $this->upperright;
        } else if ($position == 'll') {
            $corner = $this->lowerleft;
        } else {
            $corner = $this->lowerright;
        }
        if (substr($cornerid, 2, 1) === 'y') {
            return $corner->y;
        } else {
            return $corner->x;
        }
    }
    /**
     *
     * @return array of all offlinequiz corners
     */
    public function all() {
        $result = [];
        $result[] = $this->upperleft;
        $result[] = $this->upperright;
        $result[] = $this->lowerleft;
        $result[] = $this->lowerright;
        return $result;
    }
}
