define("tiny_styles/commands",["exports","editor_tiny/utils","core/ajax","core/str","./common"],(function(_exports,_utils,_ajax,_str,_common){var obj;
/**
   * Commands for the editor.
   *
   * @ package tiny_styles
   * @author Karri Pajarinen
   * @copyright Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */async function fetchCategories(){const requests=[{methodname:"tiny_styles_fetch_categories",args:{}}];try{const[data]=await _ajax.default.call(requests);return data}catch(err){return[]}}function buildCategoryItems(editor,categories,icons,clearlabel){const items=[];return categories.forEach((cat=>{if("divider"===cat.menumode)return void items.push({type:"separator"});if("inline"===cat.menumode&&Array.isArray(cat.elements))return void cat.elements.forEach((elem=>{items.push({type:"menuitem",text:elem.name,onAction:()=>{applyStyle(editor,{className:elem.cssclasses,block:"block"===elem.type,custom:1===elem.custom,id:elem.id})}})}));const subItems=[];if(Array.isArray(cat.elements)&&cat.elements.forEach((elem=>{subItems.push({type:"menuitem",text:elem.name,onAction:()=>{applyStyle(editor,{className:elem.cssclasses,block:"block"===elem.type,custom:1===elem.custom,id:elem.id})}})})),subItems.length>0){let caticon=icons.default;const symbolname=(cat.symbol?cat.symbol:"").replace(".svg","").trim();icons[symbolname]&&(caticon=icons[symbolname]),items.push({type:"nestedmenuitem",icon:caticon,text:cat.name,title:"tooltip",getSubmenuItems:()=>subItems})}})),items.push({type:"separator"}),items.push({type:"menuitem",text:clearlabel,icon:icons.remove,onAction:()=>{!function(editor){const selection=editor.selection,selectedNode=selection.getNode();if(function(editor){const selectedNode=editor.selection.getNode(),listParent=editor.dom.getParent(selectedNode,"UL,OL");if(listParent){if(editor.selection.getContent({format:"html"}).trim()){const selectedListItems=editor.selection.getSelectedBlocks().filter((block=>"LI"===block.tagName));if(0===selectedListItems.length){const currentListItem=editor.dom.getParent(selectedNode,"LI");currentListItem&&selectedListItems.push(currentListItem)}let inlineStylesRemoved=!1;if(selectedListItems.forEach((li=>{li.querySelectorAll("span").forEach((span=>{isStyledInlineElement(span)&&(span.outerHTML=span.innerHTML,inlineStylesRemoved=!0)}))})),inlineStylesRemoved)return!0;const parentDiv=listParent.parentElement;if(parentDiv&&"DIV"===parentDiv.tagName&&isStyledBlockElement(parentDiv))return editor.dom.insertAfter(listParent,parentDiv),editor.dom.remove(parentDiv),!0}}return!1}(editor))return!0;const styledDiv=editor.dom.getParent(selectedNode,(function(node){return"DIV"===node.tagName&&isStyledBlockElement(node)}));if(styledDiv){const children=Array.from(styledDiv.childNodes).filter((node=>node.nodeType===Node.ELEMENT_NODE));if(children.some((child=>"UL"===child.tagName||"OL"===child.tagName))||children.length>1){let insertPoint=styledDiv;return children.forEach((child=>{editor.dom.insertAfter(child,insertPoint),insertPoint=child})),editor.dom.remove(styledDiv),children.length>0&&selection.setCursorLocation(children[0],0),editor.focus(),!0}}let styledSpanParent=null;styledSpanParent=selectedNode&&"SPAN"===selectedNode.tagName&&isStyledInlineElement(selectedNode)?selectedNode:editor.dom.getParent(selectedNode,(function(node){return isStyledInlineElement(node)}));if(!styledSpanParent){const range=selection.getRng();if(range&&range.startContainer){const spanParent=editor.dom.getParent(range.startContainer,(function(node){return isStyledInlineElement(node)}));spanParent&&(styledSpanParent=spanParent)}}if(styledSpanParent){const textContent=styledSpanParent.textContent||styledSpanParent.innerText,textNode=document.createTextNode(textContent);editor.dom.replace(textNode,styledSpanParent);const range=editor.dom.createRng();return range.setStartAfter(textNode),range.setEndAfter(textNode),selection.setRng(range),editor.focus(),!0}const blockParent=editor.dom.getParent(selectedNode,(function(node){return isStyledBlockElement(node)}));if(blockParent){const innerHTML=blockParent.innerHTML;if(innerHTML.includes("<br><br>")){const parts=innerHTML.split("<br><br>"),firstParagraph=editor.dom.create("p",{},parts[0]);editor.dom.insertAfter(firstParagraph,blockParent);let currentParagraph=firstParagraph;for(let i=1;i<parts.length;i++){const newParagraph=editor.dom.create("p",{},parts[i]);editor.dom.insertAfter(newParagraph,currentParagraph),currentParagraph=newParagraph}editor.dom.remove(blockParent),selection.setCursorLocation(firstParagraph,0)}else{const cleanParagraph=editor.dom.create("p",{},innerHTML);editor.dom.insertAfter(cleanParagraph,blockParent),editor.dom.remove(blockParent),selection.setCursorLocation(cleanParagraph,0)}return editor.focus(),!0}}(editor)}}),items}function applyStyle(editor,styleDef){const{className:className,block:block,custom:custom,id:id}=styleDef,selectedHtml=editor.selection.getContent({format:"html"}),selectedNode=editor.selection.getNode(),styledSpanParent=block?null:editor.dom.getParent(selectedNode,(function(node){return isStyledInlineElement(node)}));if(!selectedHtml.trim()&&!block&&!styledSpanParent)return;if(block){const listParent=editor.dom.getParent(selectedNode,"UL,OL");if(listParent)return function(editor,styleDef,listParent){const{className:className,custom:custom,id:id}=styleDef,parentDiv=listParent.parentElement;if(parentDiv&&"DIV"===parentDiv.tagName&&isStyledBlockElement(parentDiv))if(custom){const newCss=className+"; --tiny-styles-custom-id: "+id;editor.dom.setAttrib(parentDiv,"style",newCss),editor.dom.setAttrib(parentDiv,"data-mce-style",newCss),editor.dom.setAttrib(parentDiv,"class","")}else editor.dom.setAttrib(parentDiv,"class",className),editor.dom.setAttrib(parentDiv,"style",""),editor.dom.setAttrib(parentDiv,"data-mce-style","");else{const wrapperDiv=editor.dom.create("div");if(custom){const newCss=className+"; --tiny-styles-custom-id: "+id;editor.dom.setAttrib(wrapperDiv,"style",newCss),editor.dom.setAttrib(wrapperDiv,"data-mce-style",newCss)}else editor.dom.setAttrib(wrapperDiv,"class",className);editor.dom.insertAfter(wrapperDiv,listParent),wrapperDiv.appendChild(listParent)}return editor.focus(),!0}(editor,styleDef,listParent);const selectedBlocks=editor.selection.getSelectedBlocks(),hasLists=selectedBlocks.some((block=>"LI"===block.tagName||"UL"===block.tagName||"OL"===block.tagName)),hasTextBlocks=selectedBlocks.some((block=>["P","DIV","H1","H2","H3","H4","H5","H6"].includes(block.tagName)));return hasLists&&hasTextBlocks?function(editor,styleDef,selectedBlocks){const{className:className,custom:custom,id:id}=styleDef,elementsToWrap=[];for(let i=0;i<selectedBlocks.length;i++){const block=selectedBlocks[i];if("LI"===block.tagName){const list=editor.dom.getParent(block,"UL,OL");list&&!elementsToWrap.includes(list)&&elementsToWrap.push(list)}else("UL"===block.tagName||"OL"===block.tagName)&&elementsToWrap.includes(block)||elementsToWrap.push(block)}if(0===elementsToWrap.length)return!1;const wrapperDiv=editor.dom.create("div");if(custom){const newCss=className+"; --tiny-styles-custom-id: "+id;editor.dom.setAttrib(wrapperDiv,"style",newCss),editor.dom.setAttrib(wrapperDiv,"data-mce-style",newCss)}else editor.dom.setAttrib(wrapperDiv,"class",className);const lastElement=elementsToWrap[elementsToWrap.length-1];editor.dom.insertAfter(wrapperDiv,lastElement),elementsToWrap.forEach((element=>{wrapperDiv.appendChild(element)}));const nextParagraph=editor.dom.create("p",{},"");return editor.dom.insertAfter(nextParagraph,wrapperDiv),editor.selection.setCursorLocation(nextParagraph,0),editor.focus(),!0}(editor,styleDef,selectedBlocks):function(editor,styleDef){const{className:className,custom:custom,id:id}=styleDef,selection=editor.selection,targetBlockTypes=["P","DIV","H1","H2","H3","H4","H5","H6","BLOCKQUOTE","PRE","SECTION","ARTICLE","ASIDE"],targetBlocks=selection.getSelectedBlocks().filter((block=>targetBlockTypes.includes(block.tagName))),textContents=targetBlocks.map((block=>block.innerHTML.trim())).filter((content=>content.length>0));if(textContents.length>0){const combinedContent=textContents.join("<br><br>"),newParagraph=editor.dom.create("p",{},combinedContent);if(custom){const newCss=className+"; --tiny-styles-custom-id: "+id;editor.dom.setAttrib(newParagraph,"style",newCss),editor.dom.setAttrib(newParagraph,"data-mce-style",newCss)}else editor.dom.setAttrib(newParagraph,"class",className);const firstBlock=targetBlocks[0];editor.dom.insertAfter(newParagraph,firstBlock),targetBlocks.forEach((block=>{editor.dom.remove(block)}));const lastChild=newParagraph.lastChild;lastChild&&lastChild.nodeType===Node.TEXT_NODE&&selection.setCursorLocation(lastChild,lastChild.length)}editor.focus()}(editor,styleDef)}if(editor.dom.getParent(selectedNode,"UL,OL"))return function(editor,styleDef,selectedNode){const{className:className,custom:custom,id:id}=styleDef,selectedHtml=editor.selection.getContent({format:"html"}),selectedListItems=editor.selection.getSelectedBlocks().filter((block=>"LI"===block.tagName));if(0===selectedListItems.length){const currentListItem=editor.dom.getParent(selectedNode,"LI");currentListItem&&selectedListItems.push(currentListItem)}if(0===selectedListItems.length)return!1;if(selectedHtml.trim()&&selectedListItems.length>1)return function(editor,styleDef,selectedListItems){const{className:className,custom:custom,id:id}=styleDef,selection=editor.selection,originalRange=selection.getRng().cloneRange();return selectedListItems.forEach((li=>{li.querySelectorAll("span").forEach((span=>{isStyledInlineElement(span)&&(span.outerHTML=span.innerHTML)}));const span=editor.dom.create("span");if(span.innerHTML=li.innerHTML,custom){const newCss=className+"; --tiny-styles-custom-id: "+id;editor.dom.setAttrib(span,"style",newCss),editor.dom.setAttrib(span,"data-mce-style",newCss)}else editor.dom.setAttrib(span,"class",className);li.innerHTML="",li.appendChild(span)})),selection.setRng(originalRange),editor.focus(),!0}(editor,styleDef,selectedListItems);if(selectedHtml.trim()&&1===selectedListItems.length){const styledSpanParent=editor.dom.getParent(selectedNode,(function(node){return isStyledInlineElement(node)}));if(styledSpanParent){const spanTextContent=styledSpanParent.textContent||styledSpanParent.innerText,newWrapper=editor.dom.create("span");if(newWrapper.textContent=spanTextContent,custom){const newCss=className+"; --tiny-styles-custom-id: "+id;editor.dom.setAttrib(newWrapper,"style",newCss),editor.dom.setAttrib(newWrapper,"data-mce-style",newCss)}else editor.dom.setAttrib(newWrapper,"class",className);return editor.dom.replace(newWrapper,styledSpanParent),handleSpaceAfterInlineSpan(editor,newWrapper),editor.focus(),!0}const cleanSelectedHtml=editor.selection.getContent({format:"html"});return applyInlineStyle(editor,styleDef,cleanSelectedHtml),!0}if(!selectedHtml.trim()&&1===selectedListItems.length){const styledSpanParent=editor.dom.getParent(selectedNode,(function(node){return isStyledInlineElement(node)}));if(styledSpanParent){const spanTextContent=styledSpanParent.textContent||styledSpanParent.innerText,newWrapper=editor.dom.create("span");if(newWrapper.textContent=spanTextContent,custom){const newCss=className+"; --tiny-styles-custom-id: "+id;editor.dom.setAttrib(newWrapper,"style",newCss),editor.dom.setAttrib(newWrapper,"data-mce-style",newCss)}else editor.dom.setAttrib(newWrapper,"class",className);return editor.dom.replace(newWrapper,styledSpanParent),handleSpaceAfterInlineSpan(editor,newWrapper),editor.focus(),!0}}return!1}(editor,styleDef,selectedNode);if(styledSpanParent){const spanTextContent=styledSpanParent.textContent||styledSpanParent.innerText,newWrapper=editor.dom.create("span");if(newWrapper.textContent=spanTextContent,custom){const newCss=className+"; --tiny-styles-custom-id: "+id;editor.dom.setAttrib(newWrapper,"style",newCss),editor.dom.setAttrib(newWrapper,"data-mce-style",newCss)}else editor.dom.setAttrib(newWrapper,"class",className);return editor.dom.replace(newWrapper,styledSpanParent),handleSpaceAfterInlineSpan(editor,newWrapper),void editor.focus()}const cleanSelectedHtml=editor.selection.getContent({format:"html"});return applyInlineStyle(editor,styleDef,cleanSelectedHtml)}function isStyledBlockElement(node){if(!node||!node.tagName)return!1;if(!["DIV","P","SECTION","ARTICLE","ASIDE","UL","OL"].includes(node.tagName.toUpperCase()))return!1;if(node.className)return!0;if(node.style&&node.style.getPropertyValue("--tiny-styles-custom-id"))return!0;if(node.getAttribute&&node.getAttribute("data-mce-style")){if(node.getAttribute("data-mce-style").includes("--tiny-styles-custom-id"))return!0}return!1}function isStyledInlineElement(node){if(!node||"SPAN"!==node.tagName)return!1;if(node.className)return!0;if(node.style&&node.style.getPropertyValue("--tiny-styles-custom-id"))return!0;if(node.getAttribute&&node.getAttribute("data-mce-style")){if(node.getAttribute("data-mce-style").includes("--tiny-styles-custom-id"))return!0}return!1}function applyInlineStyle(editor,styleDef,selectedHtml){const{className:className,custom:custom,id:id}=styleDef,container=document.createElement("div");container.innerHTML=selectedHtml,Array.from(container.childNodes).forEach(stripText);const newWrapper=document.createElement("span");for(custom?(newWrapper.style.cssText=className,newWrapper.style.setProperty("--tiny-styles-custom-id",id.toString())):newWrapper.className=className;container.firstChild;)newWrapper.appendChild(container.firstChild);newWrapper.setAttribute("data-temp-inline-style","true"),editor.selection.setContent(newWrapper.outerHTML+"&nbsp;");const insertedSpan=editor.dom.select('[data-temp-inline-style="true"]')[0];if(insertedSpan){editor.dom.setAttrib(insertedSpan,"data-temp-inline-style",null);const nextNode=insertedSpan.nextSibling;if(nextNode&&nextNode.nodeType===Node.TEXT_NODE){const range=editor.dom.createRng();range.setStart(nextNode,1),range.setEnd(nextNode,1),editor.selection.setRng(range)}}editor.focus()}function stripText(root){root.nodeType===Node.ELEMENT_NODE&&(root.removeAttribute("class"),root.style&&(root.style.cssText=""),root.removeAttribute("style"),root.removeAttribute("data-mce-style"),Array.from(root.childNodes).forEach(stripText))}function handleSpaceAfterInlineSpan(editor,spanElement){const nextNode=spanElement.nextSibling;if(nextNode&&nextNode.nodeType===Node.TEXT_NODE){const textContent=nextNode.textContent;if(textContent.length>=1&&(" "===textContent[0]||" "===textContent[0]))return void editor.selection.setCursorLocation(nextNode,1);{const newText=textContent.substring(0,1)+" "+textContent.substring(1);return nextNode.textContent=newText,void editor.selection.setCursorLocation(nextNode,1)}}const spaceNode=document.createTextNode(" ");editor.dom.insertAfter(spaceNode,spanElement),editor.selection.setCursorLocation(spaceNode,1)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.editCustomStyles=async function(editor){const categoriesResponse=await fetchCategories();let categories=[];Array.isArray(categoriesResponse)?categories=categoriesResponse:categoriesResponse&&Array.isArray(categoriesResponse.categories)&&(categories=categoriesResponse.categories);const customStylesMap={};categories.forEach((cat=>{Array.isArray(cat.elements)&&cat.elements.forEach((elem=>{1===elem.custom&&(customStylesMap[elem.id]=elem)}))}));editor.getBody().querySelectorAll('[style*="--tiny-styles-custom-id"]').forEach((element=>{const customStyleId=window.getComputedStyle(element).getPropertyValue("--tiny-styles-custom-id").trim();if(!customStyleId)return;const styleDefinition=customStylesMap[customStyleId];if(styleDefinition){if(element.style.cssText!==styleDefinition.cssclasses){const newCss=styleDefinition.cssclasses+"; --tiny-styles-custom-id: "+styleDefinition.id;editor.dom.setAttrib(element,"style",newCss),editor.dom.setAttrib(element,"data-mce-style",newCss)}}else{const minimalCss="--tiny-styles-custom-id: ".concat(customStyleId,";");editor.dom.setAttrib(element,"style",minimalCss),editor.dom.setAttrib(element,"data-mce-style",minimalCss)}}))},_exports.getSetup=void 0,_ajax=(obj=_ajax)&&obj.__esModule?obj:{default:obj};_exports.getSetup=async()=>{const[categories,buttonImage,labelImage,boxImage,defaultImage,mainMenuLabel,previewImage,applyImage,checkImage,graduateImage,laptopImage,magnifyingImage,penImage,schoolImage,squareImage,flagImage,brushImage,infoImage,downloadImage,bookImage,folderImage,removeImage,clearLabel]=await Promise.all([fetchCategories(),(0,_utils.getButtonImage)("icon","tiny_styles"),(0,_utils.getButtonImage)("label","tiny_styles"),(0,_utils.getButtonImage)("box","tiny_styles"),(0,_utils.getButtonImage)("default","tiny_styles"),(0,_str.get_string)("menuitem_styles","tiny_styles"),(0,_utils.getButtonImage)("preview","tiny_styles"),(0,_utils.getButtonImage)("paint","tiny_styles"),(0,_utils.getButtonImage)("check","tiny_styles"),(0,_utils.getButtonImage)("graduate","tiny_styles"),(0,_utils.getButtonImage)("laptop","tiny_styles"),(0,_utils.getButtonImage)("magnify","tiny_styles"),(0,_utils.getButtonImage)("pen","tiny_styles"),(0,_utils.getButtonImage)("school","tiny_styles"),(0,_utils.getButtonImage)("square","tiny_styles"),(0,_utils.getButtonImage)("flag","tiny_styles"),(0,_utils.getButtonImage)("brush","tiny_styles"),(0,_utils.getButtonImage)("info","tiny_styles"),(0,_utils.getButtonImage)("download","tiny_styles"),(0,_utils.getButtonImage)("book","tiny_styles"),(0,_utils.getButtonImage)("folder","tiny_styles"),(0,_utils.getButtonImage)("remove","tiny_styles"),(0,_str.get_string)("editor:clearstyle","tiny_styles")]);return editor=>{editor.ui.registry.addIcon(_common.icon,buttonImage.html),editor.ui.registry.addIcon("labelIcon",labelImage.html),editor.ui.registry.addIcon("boxIcon",boxImage.html),editor.ui.registry.addIcon("defaultIcon",defaultImage.html),editor.ui.registry.addIcon("previewIcon",previewImage.html),editor.ui.registry.addIcon("applyIcon",applyImage.html),editor.ui.registry.addIcon("checkIcon",checkImage.html),editor.ui.registry.addIcon("graduateIcon",graduateImage.html),editor.ui.registry.addIcon("laptopIcon",laptopImage.html),editor.ui.registry.addIcon("magnifyingIcon",magnifyingImage.html),editor.ui.registry.addIcon("penIcon",penImage.html),editor.ui.registry.addIcon("schoolIcon",schoolImage.html),editor.ui.registry.addIcon("squareIcon",squareImage.html),editor.ui.registry.addIcon("flagIcon",flagImage.html),editor.ui.registry.addIcon("brushIcon",brushImage.html),editor.ui.registry.addIcon("infoIcon",infoImage.html),editor.ui.registry.addIcon("downloadIcon",downloadImage.html),editor.ui.registry.addIcon("bookIcon",bookImage.html),editor.ui.registry.addIcon("folderIcon",folderImage.html),editor.ui.registry.addIcon("removeIcon",removeImage.html);const icons={label:"labelIcon",box:"boxIcon",default:"defaultIcon",preview:"previewIcon",paint:"applyIcon",check:"checkIcon",graduate:"graduateIcon",laptop:"laptopIcon",magnify:"magnifyingIcon",pen:"penIcon",school:"schoolIcon",square:"squareIcon",flag:"flagIcon",brush:"brushIcon",info:"infoIcon",download:"downloadIcon",book:"bookIcon",folder:"folderIcon",remove:"removeIcon"},createEmptyParagraph=editor=>{const newPara=editor.dom.create("p");return newPara.appendChild(editor.dom.create("br")),newPara},focusParagraph=(editor,element)=>{editor.selection.setCursorLocation(element,0),editor.focus()};let continuedTyping=!1;editor.on("keydown",(e=>{if(continuedTyping&&1===e.key.length){const range=editor.selection.getRng();if(range.startContainer.nodeType!==Node.ELEMENT_NODE)return void(continuedTyping=!1);const container=range.startContainer,offset=range.startOffset;if(0===offset)return void(continuedTyping=!1);const nodeBefore=container.childNodes[offset-1];if((null==nodeBefore?void 0:nodeBefore.nodeType)===Node.TEXT_NODE){const text=nodeBefore.textContent;text.length>0&&160===text.charCodeAt(text.length-1)&&(nodeBefore.textContent=text.substring(0,text.length-1),offset>=container.childNodes.length&&editor.selection.setContent("<br>"))}continuedTyping=!1}if("Enter"===e.key&&!e.shiftKey){const node=editor.selection.getNode(),styledBlock=editor.dom.getParent(node,(el=>isStyledBlockElement(el)),editor.getBody());if(!styledBlock)return void(continuedTyping=!1);if(editor.dom.getParent(node,"ul,ol,li",editor.getBody()))return void(continuedTyping=!1);e.preventDefault(),continuedTyping=!1;const range=editor.selection.getRng(),currentPara=editor.dom.getParent(node,"p",styledBlock);if(currentPara&&currentPara!==styledBlock){const paraText=currentPara.textContent.trim(),onlyHasBR=1===currentPara.childNodes.length&&"BR"===currentPara.childNodes[0].nodeName;if(""===paraText||onlyHasBR){editor.dom.remove(currentPara);const newPara=createEmptyParagraph(editor);return editor.dom.insertAfter(newPara,styledBlock),void focusParagraph(editor,newPara)}}const{contentBefore:contentBefore,contentAfter:contentAfter}=((editor,range,currentBlock)=>{const beforeRange=editor.dom.createRng();beforeRange.setStart(currentBlock,0),beforeRange.setEnd(range.startContainer,range.startOffset);const contentBefore=beforeRange.toString().trim(),afterRange=editor.dom.createRng();return afterRange.setStart(range.endContainer,range.endOffset),afterRange.setEnd(currentBlock,currentBlock.childNodes.length),{contentBefore:contentBefore,contentAfter:afterRange.toString().trim()}})(editor,range,styledBlock);if(0===contentBefore.length&&contentAfter.length>0)return void((editor,styledBlock)=>{const newPara=createEmptyParagraph(editor);styledBlock.parentNode.insertBefore(newPara,styledBlock),focusParagraph(editor,newPara)})(editor,styledBlock);let elementToCheck=styledBlock;currentPara&&currentPara!==styledBlock&&(elementToCheck=currentPara);const children=Array.from(elementToCheck.childNodes);let hasTrailingBR=!1;for(let i=children.length-1;i>=0;i--){const child=children[i];if("BR"===child.nodeName){hasTrailingBR=!0;break}if(child.nodeType!==Node.TEXT_NODE||""!==child.textContent.trim())break}const isAtEnd=0===contentAfter.length;if(hasTrailingBR&&isAtEnd){for(let i=children.length-1;i>=0;i--){const child=children[i];if("BR"!==child.nodeName&&(child.nodeType!==Node.TEXT_NODE||""!==child.textContent.trim()))break;editor.dom.remove(child)}const newPara=createEmptyParagraph(editor);return editor.dom.insertAfter(newPara,styledBlock),void focusParagraph(editor,newPara)}editor.selection.setContent("<br>&nbsp;"),continuedTyping=!0}})),editor.ui.registry.addMenuButton("tiny_styles_button",{icon:_common.icon,tooltip:mainMenuLabel,fetch:callback=>{callback(buildCategoryItems(editor,categories,icons,clearLabel))}}),editor.ui.registry.addNestedMenuItem("tiny_styles_nestedmenu",{icon:_common.icon,text:mainMenuLabel,getSubmenuItems:()=>buildCategoryItems(editor,categories,icons,clearLabel)})}}}));

//# sourceMappingURL=commands.min.js.map