// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Common values helper for the Moodle tiny_styles plugin.
 *
 * @ package tiny_styles
 * @author Karri Pajarinen
 * @copyright Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

const component = 'tiny_styles';

export const pluginName = `${component}`;
export const styleMenuItemName = `${component}_styles`;
export const boxesButtonName = `${component}_boxes`;
export const labelsButtonName = `${component}_labels`;
export const boxesSubmenuName = `${component}_boxes_submenu`;
export const labelsSubmenuName = `${component}_labels_submenu`;
export const menuIconName = `${component}_menuicon`;
export const boxIconName = `${component}_boxicon`;
export const icon = component;
