/*
 * The module provides a function to refresh the user list with correct credential data.
 *
 * @module    mod_accredible
 * @package   accredible
 * @copyright Accredible <dev@accredible.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_accredible/mappings",["jquery","core/ajax","core/templates","core/notification"],(function($,Ajax,Templates,Notification){const element_mappingSelects='[id*="mapping_line"] select',element_addButton='[id*="_add_new_line"]',element_list=".attribute_mapping",requiresId=["coursecustomfieldmapping","userprofilefieldmapping"],mappings={init:function(){mappings.setSelectValues(),mappings.listenToAddAction(),mappings.listenToDeleteAction(),mappings.listenToSelectChanges()},listenToAddAction:function(){const addButton=$(element_addButton);addButton.on("click",mappings.addNewLine),addButton.each(((_,element)=>{const section=$(element).attr("data-section");mappings.toggleAddButton(section)}))},listenToDeleteAction:function(){$(element_list).on("click",".remove-line",mappings.removeLine)},listenToSelectChanges:function(){$(element_list).on("change",element_mappingSelects,(()=>{mappings.checkForDuplicates()}))},getAttributeValuesCount:function(){const valuesCount=new Map;return $(element_mappingSelects).each(((_,select)=>{var _valuesCount$get;const value=$(select).val();if(!value)return;const name=mappings.getOptionNameFromSelect(select),key="".concat(name,"_").concat(value);let occurrences=null!==(_valuesCount$get=valuesCount.get(key))&&void 0!==_valuesCount$get?_valuesCount$get:0;occurrences++,valuesCount.set(key,occurrences)})),valuesCount},checkForDuplicates:function(){const duplicateCount=mappings.getAttributeValuesCount(),rowHasError={};let hasDuplicate=!1;$(element_mappingSelects).each(((_,select)=>{const id=$(select).attr("id"),rowId=new RegExp(/(id_\w+_\d)_\w+/g).exec(id)[1],deleteIconWrapper=$("#".concat(rowId,"_delete_action"));$(select).removeClass("is-invalid");const value=$(select).val(),name=mappings.getOptionNameFromSelect(select),key="".concat(name,"_").concat(value);duplicateCount.get(key)>1&&($(select).addClass("is-invalid"),deleteIconWrapper.addClass("pb-xl-4"),hasDuplicate=!0,rowHasError[rowId]=!0),rowHasError[rowId]||deleteIconWrapper.removeClass("pb-xl-4"),mappings.disableSubmit(hasDuplicate)}))},addNewLine:function(){const section=$(this).attr("data-section"),options=mappings.getOptionsFromTemplate(section),data={index:mappings.countLines(section)+1,section:section,accredibleoptions:options.accredibleoptions,moodleoptions:options.moodleoptions,hasid:requiresId.includes(section)};mappings.renderMappingLine(data,"#".concat(section,"_content")),setTimeout((()=>{mappings.toggleAddButton(section)}),100)},removeLine:function(){const index=$(this).attr("data-id"),section=$(this).attr("data-section"),mappingLineId="#".concat(section,"_mapping_line_").concat(index);$(mappingLineId).remove(),mappings.toggleAddButton(section),mappings.checkForDuplicates()},countLines:function(section){return $('[id*="'.concat(section,'_mapping_line"]')).length},setSelectValues:function(){$(".attribute_mapping select.form-control").each(((_,element)=>{const selectEl=$(element),value=selectEl.attr("data-initial-value");selectEl.val(value)}))},toggleAddButton:function(section){const addBtn=$("#".concat(section,"_add_new_line"));mappings.countLines(section)==mappings.getMoodleOptionsCount(section)?addBtn.addClass("hidden"):addBtn.removeClass("hidden")},getOptionNameFromSelect(select){const value=$(select).val();return $(select).find('option[value="'.concat(value,'"]'))[0].innerHTML.replaceAll(/\W+/g,"_")},getOptionsFromTemplate:function(section){const template=$("#template_".concat(section))[0];if(!template)return{accredibleoptions:[],moodleoptions:[]};const accredibleselect=template.content.querySelector("#accredibleoptions_select"),moodleselect=template.content.querySelector("#moodleoptions_select");return{accredibleoptions:mappings.getOptionsFromSelect(accredibleselect),moodleoptions:mappings.getOptionsFromSelect(moodleselect)}},getOptionsFromSelect:function(select){return $(select).find("option").toArray().reduce(((options,optionElement)=>(options.push({name:optionElement.innerHTML,value:optionElement.value}),options)),[])},getMoodleOptionsCount:function(section){const template=$("#template_".concat(section))[0];if(!template)return 0;return template.content.querySelector("#moodleoptions_select option").length-1},disableSubmit:function(isFormInvalid){$('input:submit[id*="id_submitbutton"]').each(((_,button)=>{$(button).attr("disabled",isFormInvalid)}))},renderMappingLine:function(context,containerid){return Templates.renderForPromise("mod_accredible/mapping_line",context).then((function(_ref){return Templates.appendNodeContents(containerid,_ref.html,_ref.js),!0})).catch(Notification.exception)}};return mappings}));

//# sourceMappingURL=mappings.min.js.map