<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Joomdle web services definitions
 *
 * @package    auth_joomdle
 * @copyright  2009 Qontori Pte Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$functions = array(
    'joomdle_user_id' => array(     // Web service function name.
        'classname'   => 'joomdle_helpers_external', // Class containing the external function.
        'methodname'  => 'user_id', // External function name.
        'classpath'   => 'auth/joomdle/helpers/externallib.php', // File containing the class/external function.
        'description' => 'Get user id.', // Human readable description of the web service function.
        'type'        => 'read', // Database rights of the web service function (read, write).
    ),
    'joomdle_list_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'list_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'List courses',
        'type'        => 'read',
    ),
    'joomdle_my_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user courses',
        'type'        => 'read',
    ),
    'joomdle_get_course_info' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_info',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course info',
        'type'        => 'read',
    ),
    'joomdle_get_course_contents' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_contents',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course topics',
        'type'        => 'read',
    ),
    'joomdle_courses_by_category' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'courses_by_category',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get courses from a category',
        'type'        => 'read',
    ),
    'joomdle_get_course_categories' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_categories',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course categories',
        'type'        => 'read',
    ),
    'joomdle_get_course_editing_teachers' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_editing_teachers',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course editing teachers',
        'type'        => 'read',
    ),
    'joomdle_get_course_no' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_no',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get number of courses',
        'type'        => 'read',
    ),
    'joomdle_get_enrollable_course_no' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_enrollable_course_no',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get number of enrollable courses',
        'type'        => 'read',
    ),
    'joomdle_get_student_no' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_student_no',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get number of students',
        'type'        => 'read',
    ),
    'joomdle_get_total_assignment_submissions' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_total_assignment_submissions',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get number of submitted assignments',
        'type'        => 'read',
    ),
    'joomdle_get_course_students_no' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_students_no',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get number of students in a course',
        'type'        => 'read',
    ),
    'joomdle_get_assignment_submissions' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_assignment_submissions',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course submitted assignments',
        'type'        => 'read',
    ),
    'joomdle_get_assignment_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_assignment_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get assignments grades',
        'type'        => 'read',
    ),
    'joomdle_get_upcoming_events' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_upcoming_events',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get upcoming events',
        'type'        => 'read',
    ),
    'joomdle_get_news_items' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_news_items',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get news',
        'type'        => 'read',
    ),
    'joomdle_get_user_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_user_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user grades in a course',
        'type'        => 'read',
    ),
    'joomdle_get_course_grade_categories' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_grade_categories',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  grades categories of course',
        'type'        => 'read',
    ),
    'joomdle_search_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'search_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Search courses',
        'type'        => 'read',
    ),
    'joomdle_search_categories' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'search_categories',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Search course categories',
        'type'        => 'read',
    ),
    'joomdle_search_topics' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'search_topics',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Search course topics',
        'type'        => 'read',
    ),
    'joomdle_get_my_courses_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_my_courses_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user grades',
        'type'        => 'read',
    ),
    'joomdle_check_moodle_users' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'check_moodle_users',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Check usernames for moodle accounts',
        'type'        => 'read',
    ),
    'joomdle_get_moodle_only_users' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_moodle_only_users',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get users existing only in moodle',
        'type'        => 'read',
    ),
    'joomdle_get_moodle_users' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_moodle_users',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get moodle users',
        'type'        => 'read',
    ),
    'joomdle_get_moodle_users_number' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_moodle_users_number',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get moodle users',
        'type'        => 'read',
    ),
    'joomdle_user_exists' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'user_exists',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Check if username exists',
        'type'        => 'read',
    ),
    'joomdle_create_joomdle_user' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'create_joomdle_user',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Creates user account',
        'type'        => 'read',
    ),
    'joomdle_enrol_user' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'enrol_user',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Enrols user into course',
        'type'        => 'read',
    ),
    'joomdle_user_details' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'user_details',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user details',
        'type'        => 'read',
    ),
    'joomdle_user_details_by_id' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'user_details_by_id',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user details',
        'type'        => 'read',
    ),
    'joomdle_migrate_to_joomdle' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'migrate_to_joomdle',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user details',
        'type'        => 'read',
    ),
    'joomdle_my_events' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_events',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user events',
        'type'        => 'read',
    ),
    'joomdle_delete_user' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'delete_user',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user events',
        'type'        => 'read',
    ),
    'joomdle_get_mentees' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_mentees',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user mentees',
        'type'        => 'read',
    ),
    'joomdle_get_roles' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_roles',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get roles',
        'type'        => 'read',
    ),
    'joomdle_get_parents' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_parents',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get roles',
        'type'        => 'read',
    ),
    'joomdle_get_site_last_week_stats' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_site_last_week_stats',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get site stats',
        'type'        => 'read',
    ),
    'joomdle_get_course_daily_stats' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_daily_stats',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course stats',
        'type'        => 'read',
    ),
    'joomdle_get_last_user_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_last_user_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course stats',
        'type'        => 'read',
    ),
    'joomdle_system_check' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'system_check',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Joomdle system check',
        'type'        => 'read',
    ),
    'joomdle_add_parent_role' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'add_parent_role',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Adds parent role',
        'type'        => 'read',
    ),
    'joomdle_get_paypal_config' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_paypal_config',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get paypal config',
        'type'        => 'read',
    ),
    'joomdle_update_session' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'update_session',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Updates user session',
        'type'        => 'read',
    ),
    'joomdle_get_cat_name' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_cat_name',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get category name',
        'type'        => 'read',
    ),
    'joomdle_courses_abc' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'courses_abc',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course list for courses starting with chars',
        'type'        => 'read',
    ),
    'joomdle_teachers_abc' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'teachers_abc',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get teachers list for teacher names starting with chars',
        'type'        => 'read',
    ),
    'joomdle_teacher_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'teacher_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get courses teached by user',
        'type'        => 'read',
    ),
    'joomdle_user_custom_fields' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'user_custom_fields',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get custom fields',
        'type'        => 'read',
    ),
    'joomdle_course_enrol_methods' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'course_enrol_methods',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course available enrolment methods',
        'type'        => 'read',
    ),
    'joomdle_quiz_get_question' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'quiz_get_question',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get quiz question',
        'type'        => 'read',
    ),
    'joomdle_quiz_get_correct_answer' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'quiz_get_correct_answer',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get quiz question correct answer',
        'type'        => 'read',
    ),
    'joomdle_quiz_get_answers' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'quiz_get_answers',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get quiz question answers',
        'type'        => 'read',
    ),
   'joomdle_get_course_students' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_students',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course students',
        'type'        => 'read',
    ),
   'joomdle_my_teachers' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_teachers',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user teachers',
        'type'        => 'read',
    ),
   'joomdle_my_classmates' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_classmates',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user classmates',
        'type'        => 'read',
    ),
   'joomdle_suspend_enrolment' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'suspend_enrolment',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Suspend enrolment',
        'type'        => 'read',
    ),
    'joomdle_get_course_resources' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_resources',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course resources',
        'type'        => 'read',
    ),
    'joomdle_get_course_mods' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_mods',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course mods',
        'type'        => 'read',
    ),
    'joomdle_get_course_completion' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_completion',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course completion',
        'type'        => 'read',
    ),
    'joomdle_get_course_quizes' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_quizes',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course quizes',
        'type'        => 'read',
    ),
    'joomdle_my_certificates' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_certificates',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user certificates',
        'type'        => 'read',
    ),
    'joomdle_get_page' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_page',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get Moodle page',
        'type'        => 'read',
    ),
    'joomdle_get_label' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_label',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get Moodle label',
        'type'        => 'read',
    ),
    'joomdle_get_news_item' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_news_item',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get Moodle news item',
        'type'        => 'read',
    ),
    'joomdle_get_my_news' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_my_news',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user news',
        'type'        => 'read',
    ),
    'joomdle_get_my_events' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_my_events',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user events',
        'type'        => 'read',
    ),
    'joomdle_get_my_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_my_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user grades',
        'type'        => 'read',
    ),
    'joomdle_quiz_get_random_question' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'quiz_get_random_question',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get random question',
        'type'        => 'read',
    ),
    'joomdle_quiz_get_question_categories' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'quiz_get_question_categories',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  question categories',
        'type'        => 'read',
    ),
    'joomdle_multiple_enrol_and_addtogroup' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'multiple_enrol_and_addtogroup',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Enrol user in multiple courses and groups',
        'type'        => 'read',
    ),
    'joomdle_multiple_enrol' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'multiple_enrol',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Enrol user in multiple courses',
        'type'        => 'read',
    ),
    'joomdle_multiple_suspend_enrolment' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'multiple_suspend_enrolment',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Un-enrol user from multiple courses',
        'type'        => 'read',
    ),
    'joomdle_create_joomdle_user_additional' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'create_joomdle_user_additional',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Creates/updates user account using a different data source',
        'type'        => 'read',
    ),
    'joomdle_get_course_grade_categories_and_items' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_grade_categories_and_items',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  grades categories and  items of course',
        'type'        => 'read',
    ),
    'joomdle_get_course_grades_by_category' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_grades_by_category',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  course grades by category',
        'type'        => 'read',
    ),
    'joomdle_get_my_grades_by_category' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_my_grades_by_category',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  user grades by courses/category',
        'type'        => 'read',
    ),
    'joomdle_get_cohorts' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_cohorts',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  cohorts',
        'type'        => 'read',
    ),
    'joomdle_add_cohort_member' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'add_cohort_member',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Add user to cohort',
        'type'        => 'read',
    ),
    'joomdle_get_rubrics' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_rubrics',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get assignment rubrics',
        'type'        => 'read',
    ),
    'joomdle_get_grade_user_report' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_grade_user_report',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  user grade report for a course',
        'type'        => 'read',
    ),
    'joomdle_get_my_grade_user_report' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_my_grade_user_report',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  user grade report for all courses',
        'type'        => 'read',
    ),
    'joomdle_teacher_get_course_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'teacher_get_course_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  course grades for teacher',
        'type'        => 'read',
    ),
    'joomdle_get_course_groups' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_groups',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  course groups',
        'type'        => 'read',
    ),
    'joomdle_get_group_members' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_group_members',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  group members',
        'type'        => 'read',
    ),
    'joomdle_teacher_get_group_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'teacher_get_group_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get  group grades',
        'type'        => 'read',
    ),
    'joomdle_create_course' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'create_course',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Create course',
        'type'        => 'read',
    ),
    'joomdle_update_course' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'update_course',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Update course',
        'type'        => 'read',
    ),
    'joomdle_add_user_role' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'add_user_role',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Add user role',
        'type'        => 'read',
    ),
    'joomdle_get_all_parents' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_all_parents',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get all parent users',
        'type'        => 'read',
    ),
    'joomdle_get_course_parents' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_parents',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get all parent users of the course',
        'type'        => 'read',
    ),
    'joomdle_remove_cohort_member' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'remove_cohort_member',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Remove user from cohort',
        'type'        => 'read',
    ),
    'joomdle_multiple_add_cohort_member' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'multiple_add_cohort_member',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Add user to cohorts',
        'type'        => 'read',
    ),
    'joomdle_multiple_remove_cohort_member' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'multiple_remove_cohort_member',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Remove user from cohorts',
        'type'        => 'read',
    ),
    'joomdle_get_courses_and_groups' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_courses_and_groups',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get courses and their groups',
        'type'        => 'read',
    ),
    'joomdle_multiple_enrol_to_course_and_group' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'multiple_enrol_to_course_and_group',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Add user to courses and groups',
        'type'        => 'read',
    ),
    'joomdle_multiple_remove_from_group' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'multiple_remove_from_group',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Removes user from groups',
        'type'        => 'read',
    ),
    'joomdle_my_all_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_all_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get all users in which the has a role assgined',
        'type'        => 'read',
    ),
   'joomdle_unenrol_user' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'unenrol_user',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Unenrol user',
        'type'        => 'read',
    ),
   'joomdle_multiple_unenrol_user' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'multiple_unenrol_user',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Multiple unenrol user',
        'type'        => 'read',
    ),
    'joomdle_get_children_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_children_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get children grades',
        'type'        => 'read',
    ),
    'joomdle_get_children_grade_user_report' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_children_grade_user_report',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get children grade report',
        'type'        => 'read',
    ),
   'joomdle_enrol_user_with_start_date' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'enrol_user_with_start_date',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Enrols user into course with a defined start date',
        'type'        => 'read',
    ),
    'joomdle_remove_user_role' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'remove_user_role',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Remove user role',
        'type'        => 'read',
    ),
    'joomdle_get_themes' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_themes',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get themes list',
        'type'        => 'read',
    ),
    'joomdle_list_courses_scorm' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'list_courses_scorm',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'List courses along with scorm info',
        'type'        => 'read',
    ),
    'joomdle_create_moodle_only_user' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'create_moodle_only_user',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Create a new normal moodle user',
        'type'        => 'read',
    ),
   'joomdle_enrol_user_with_start_and_end_date' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'enrol_user_with_start_and_end_date',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Enrols user into course with  defined start and end date',
        'type'        => 'read',
    ),
   'joomdle_update_course_enrolments_dates' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'update_course_enrolments_dates',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Updates start and end dates for course enrolments',
        'type'        => 'read',
    ),
   'joomdle_get_system_roles' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_system_roles',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get system roles',
        'type'        => 'read',
    ),
   'joomdle_add_system_role' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'add_system_role',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Add system role',
        'type'        => 'read',
    ),
   'joomdle_my_badges' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_badges',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user badges',
        'type'        => 'read',
    ),
    'joomdle_get_course_grades' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_grades',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course grades for all grade items and students',
        'type'        => 'read',
    ),
    'joomdle_get_course_grades_items' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_grades_items',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course grade items names',
        'type'        => 'read',
    ),
    'joomdle_get_course_questionnaire_results' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_questionnaire_results',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get results of course questionnaire',
        'type'        => 'read',
    ),
    'joomdle_get_all_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_all_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get all courses',
        'type'        => 'read',
    ),
    'joomdle_get_events' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_events',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get events',
        'type'        => 'read',
    ),
    'joomdle_get_event' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_event',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get event',
        'type'        => 'read',
    ),
    'joomdle_get_certificates_credits' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_certificates_credits',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get certificates credits',
        'type'        => 'read',
    ),
    'joomdle_set_section_visible' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'set_section_visible',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Set section as visible',
        'type'        => 'read',
    ),
    'joomdle_create_events' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'create_events',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Create events',
        'type'        => 'read',
    ),
    'joomdle_get_courses_not_editing_teachers' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_courses_not_editing_teachers',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get not editing teachers for several courses',
        'type'        => 'read',
    ),
    'joomdle_get_course_progress' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_progress',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course progress',
        'type'        => 'read',
    ),
    'joomdle_my_courses_progress' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_courses_progress',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get courses progress',
        'type'        => 'read',
    ),
    'joomdle_set_course_visible' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'set_course_visible',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Change course visibility',
        'type'        => 'read',
    ),
    'joomdle_my_completed_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_completed_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user completed courses',
        'type'        => 'read',
    ),
    'joomdle_users_completed_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'users_completed_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get users completed courses',
        'type'        => 'read',
    ),
    'joomdle_remove_parent_role' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'remove_parent_role',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Remove parent role',
        'type'        => 'read',
    ),
    'joomdle_get_completed_course_users' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_completed_course_users',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get list of users that completed a course',
        'type'        => 'read',
    ),
    'joomdle_change_username' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'change_username',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Change username',
        'type'        => 'read',
    ),
    'joomdle_my_courses_and_groups' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_courses_and_groups',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user courses and groups',
        'type'        => 'read',
    ),
    'joomdle_create_groups' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'create_groups',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Create groups',
        'type'        => 'read',
    ),
    'joomdle_get_category_categories_and_courses' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_category_categories_and_courses',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get categories and courses in a category',
        'type'        => 'read',
    ),
    'joomdle_my_enrolments' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_enrolments',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get user enrolments',
        'type'        => 'read',
    ),
    'joomdle_my_courses_completion_progress' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'my_courses_completion_progress',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get courses completion progress',
        'type'        => 'read',
    ),
    'joomdle_get_mentees_certificates' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_mentees_certificates',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get mentees certificates',
        'type'        => 'read',
    ),
    'joomdle_get_moodle_version' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_moodle_version',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get Moodle version',
        'type'        => 'read',
    ),
    'joomdle_enable_user' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'enable_user',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Enable/Disable user',
        'type'        => 'read',
    ),
    'joomdle_get_course_users' => array(
        'classname'   => 'joomdle_helpers_external',
        'methodname'  => 'get_course_users',
        'classpath'   => 'auth/joomdle/helpers/externallib.php',
        'description' => 'Get course users',
        'type'        => 'read',
    ),

);
