# Security Policy

## Supported Versions

Security updates are provided for the following versions of Friction Radar:

| Version | Supported |
| ------- | --------- |
| main / latest release | ✔️ |
| Older releases | ❌ |

Only the latest released version on the `main` branch is actively maintained.  
Users are strongly encouraged to keep their installation up to date.

## Reporting a Vulnerability

If you discover a security vulnerability in this project, please **do not** report it via public GitHub issues.

Instead, report security issues responsibly by contacting the project maintainers through one of the following channels:

- GitHub Security Advisories (preferred, if available)
- Direct contact via the repository owner profile on GitHub

Please include as much information as possible:

- A clear description of the vulnerability
- Steps to reproduce the issue
- Affected Moodle and PHP versions
- Potential impact and risk assessment, if known

## Disclosure Process

After receiving a security report, we aim to:

- Acknowledge receipt within a reasonable time frame
- Assess the reported issue
- Provide a fix or mitigation if the issue is confirmed
- Coordinate responsible disclosure where applicable

Timelines may vary depending on severity, complexity, and available resources.

## Data Protection and Scope

Friction Radar is designed with privacy and data minimization as core principles:

- No personal learner data is stored
- No individual behavior is displayed
- All analysis is performed on aggregated, anonymized course-level data

Security reports must not include real learner data or sensitive personal information.

## Unsupported Issues

The following are **not** considered security issues:

- Misconfiguration of Moodle or server environments
- Access control decisions made by Moodle roles or capabilities
- Interpretative or didactic disagreements with calculated indicators

Such topics should be raised via regular GitHub issues or discussions instead.

Thank you for helping keep this project secure.
