/**
 * Base functions for the face recognition process.
 *
 * @module     quizaccess_videocapture/face_recognition_client
 * @author     Alberto Villani <alberto.villani@abacotechnology.it>
 * @copyright  2022 Abaco Technology
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("quizaccess_videocapture/face_recognition_client",["jquery","core/modal_factory","core/modal_events","core/templates","core/ajax"],(function($,ModalFactory,ModalEvents,Templates,ajax){var RecognitionClient=function(){this.width=210,this.height=0,this.streaming=!1,this.video=null,this.canvas=null,this.photo=null,this.photoTarget=null,this.stream=null,this.flow="check",this.step=0,this.uid=null,this.takepicture=this.takepicture.bind(this),this.formatDate=this.formatDate.bind(this),this.releaseStream=this.releaseStream.bind(this),this.clearphoto=this.clearphoto.bind(this),this.setFlow=this.setFlow.bind(this),this.setPhotoTarget=this.setPhotoTarget.bind(this),this.setUid=this.setUid.bind(this),this.saveandlogin=this.saveandlogin.bind(this),this.checkUploadedPicture=this.checkUploadedPicture.bind(this),this.checkPhoto=this.checkPhoto.bind(this)};return RecognitionClient.prototype.setFlow=function(flow){this.flow=flow},RecognitionClient.prototype.setStep=function(step){this.step=step},RecognitionClient.prototype.setUid=function(uid){this.uid=uid},RecognitionClient.prototype.setPhotoTarget=function(photoTargetId){this.photoTarget=document.getElementById(photoTargetId)},RecognitionClient.prototype.startVideoCap=function(videoid,canvasid,photoid){this.streaming=!1,this.video=document.getElementById(videoid),this.canvas=document.getElementById(canvasid),this.photo=document.getElementById(photoid);var constraints={video:!0,audio:!1},onSuccess=function(stream){if(this.stream=stream,"srcObject"in this.video)this.video.srcObject=stream;else if(navigator.mozGetUserMedia)this.video.mozSrcObject=stream;else{var vendorURL=window.URL||window.webkitURL;this.video.src=vendorURL.createObjectURL(stream)}this.video.play()}.bind(this),onError=function(){};if(navigator.mediaDevices&&navigator.mediaDevices.getUserMedia)navigator.mediaDevices.getUserMedia(constraints).then(onSuccess).catch(onError);else{var getMedia=navigator.getUserMedia||navigator.webkitGetUserMedia||navigator.mozGetUserMedia||navigator.msGetUserMedia;getMedia&&getMedia.call(navigator,constraints,onSuccess,onError)}this.video.addEventListener("canplay",function(){if(!this.streaming){let height=this.video.videoHeight/(this.video.videoWidth/this.width);isNaN(height)&&(height=this.width/(4/3)),this.height=height,this.video.setAttribute("width",this.width),this.video.setAttribute("height",height),this.canvas.setAttribute("width",this.width),this.canvas.setAttribute("height",height),this.streaming=!0,"check"==this.flow||"attempt"==this.flow?window.setTimeout(this.takepicture,1e3):"upload"==this.flow&&window.setTimeout(this.saveandlogin,1e3)}}.bind(this),!1)},RecognitionClient.prototype.releaseStream=function(){null!==this.stream&&this.stream.getTracks().forEach((function(track){track.stop()})),this.stream=null},RecognitionClient.prototype.takepicture=function(){var context=this.canvas.getContext("2d");if(this.width&&this.height){this.canvas.width=this.width,this.canvas.height=this.height,context.drawImage(this.video,0,0,this.width,this.height),context.font="10px Arial";var date=new Date;context.fillText(this.formatDate(date),20,20);var data=this.canvas.toDataURL("image/png");"check"==this.flow||"attempt"==this.flow?(this.photo.setAttribute("src",data),this.checkPhoto()):"shoot"==this.flow?0===this.step?(this.photoTarget.setAttribute("src",data),this.checkNewPicture()):this.photo.setAttribute("src",data):"upload"==this.flow&&this.photo.setAttribute("src",data)}else this.clearphoto()},RecognitionClient.prototype.checkPhoto=function(){ajax.call([{methodname:"quizaccess_videocapture_check_snapshot",args:{file:this.photo.getAttribute("src"),target:null}}])[0].done((function(j){if(j.match>0){var event=document.createEvent("Event");event.initEvent("snapshotCheckSuccess",!0,!0),document.dispatchEvent(event)}else document.dispatchEvent(new CustomEvent("snapshotCheckFailed",{detail:{remote_error:j.remote_error,httpcode:j.httpcode,failed_attempt:j.failed_attempt}}))})).fail((function(){}))},RecognitionClient.prototype.checkNewPicture=function(){ajax.call([{methodname:"quizaccess_videocapture_check_profile_picture",args:{file:this.photoTarget.getAttribute("src"),uid:this.uid}}])[0].done((function(j){if(j.success){this.photo_target.setAttribute("src",j.picture);var event=document.createEvent("Event");event.initEvent("newpictureCheckSuccess",!0,!0),document.dispatchEvent(event)}else document.dispatchEvent(new CustomEvent("newpictureCheckFailed",{detail:{remote_error:j.remote_error,httpcode:j.httpcode,msgcod:j.msgcod}}))})).fail((function(){}))},RecognitionClient.prototype.checkUploadedPicture=function(formData){ajax.call([{methodname:"quizaccess_videocapture_check_uploaded_profile_picture",args:{jsonformdata:JSON.stringify(formData),uid:this.uid}}])[0].done((function(j){if($("#upldretry").show(),j.success){this.photo_target.setAttribute("src",j.picture);var event=document.createEvent("Event");event.initEvent("uploadedPictureCheckSuccess",!0,!0),document.dispatchEvent(event)}else document.dispatchEvent(new CustomEvent("ploadedPictureCheckFailed",{detail:{remote_error:j.remote_error,httpcode:j.httpcode,msgcod:j.msgcod}}))})).fail((function(){}))},RecognitionClient.prototype.saveandlogin=function(){this.takepicture();var promises=ajax.call([{methodname:"quizaccess_videocapture_check_snapshot",args:{file:this.photo.getAttribute("src"),target:this.photoTarget.getAttribute("src")}}]);promises[0].done(function(j){j.match>0?(promises=ajax.call([{methodname:"quizaccess_videocapture_save_profile_picture",args:{file:this.photoTarget.getAttribute("src"),uid:this.uid}}]))[0].done((function(jj){if(jj.success){var event=document.createEvent("Event");event.initEvent("saveandloginCheckSuccess",!0,!0),document.dispatchEvent(event)}})):document.dispatchEvent(new CustomEvent("saveandloginCheckFailed",{detail:{remote_error:j.remote_error,httpcode:j.httpcode}}))}.bind(this)).fail((function(){}))},RecognitionClient.prototype.clearphoto=function(){var context=this.canvas.getContext("2d");context.fillStyle="#AAA",context.fillRect(0,0,this.canvas.width,this.canvas.height);var data=this.canvas.toDataURL("image/png");this.photo.setAttribute("src",data)},RecognitionClient.prototype.formatDate=function(date){var result="";result+=date.getFullYear(),result+="-";var month=date.getMonth()+1;return result+=this.padNumber(month),result+="-",result+=this.padNumber(date.getDate()),result+=" ",result+=this.padNumber(date.getHours()),result+=":",result+=this.padNumber(date.getMinutes()),result+=":",result+=this.padNumber(date.getSeconds())},RecognitionClient.prototype.padNumber=function(n){return n>9?n:"0"+n},new RecognitionClient}));

//# sourceMappingURL=face_recognition_client.min.js.map