<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Event observers configuration for block_progressanalytics
 *
 * @package    block_progressanalytics
 * @copyright  2024 Progress Analytics Block
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$observers = array(

    array(
        'eventname' => '\mod_quiz\event\attempt_submitted',
        'callback' => '\block_progressanalytics\observer::quiz_attempt_submitted',
    ),

    array(
        'eventname' => '\mod_quiz\event\attempt_finished',
        'callback' => '\block_progressanalytics\observer::quiz_attempt_finished',
    ),

    array(
        'eventname' => '\mod_quiz\event\quiz_grade_updated',
        'callback' => '\block_progressanalytics\observer::quiz_grade_updated',
    ),

    array(
        'eventname' => '\core\event\course_module_completion_updated',
        'callback' => '\block_progressanalytics\observer::course_module_completion_updated',
    ),

);