<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Amanote message producer definitions.
 *
 * @package     filter_amanote
 * @copyright   2023 Amaplex Software
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// Set enabled flag to ensure backwards compatibility.
$enabledflag = defined('MESSAGE_DEFAULT_ENABLED') ? MESSAGE_DEFAULT_ENABLED : MESSAGE_DEFAULT_LOGGEDIN + MESSAGE_DEFAULT_LOGGEDOFF;

// Define default settings for message providers.
$defaultsettings = [
    'pop-up' => MESSAGE_PERMITTED + $enabledflag,
    'email' => MESSAGE_PERMITTED,
];

$messageproviders = [
    // Notify teacher that a student has submitted a work.
    'submission' => [
        'defaults' => $defaultsettings,
    ],
    // Notify teacher that a student has submitted a feedback.
    'feedback' => [
        'defaults' => $defaultsettings,
    ],
    // Notify teacher that a student has submitted a question.
    'question' => [
        'defaults' => $defaultsettings,
    ],
];
