<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English strings for Amanote filter.
 *
 * @package     filter_amanote
 * @copyright   2020 Amaplex Software
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

 $string['aiassistant'] = 'AI Assistant';
 $string['aiassistant_help'] = 'By default, the "AI Assistant" button is visible only to administrators. Uncheck this option to completely disable the "AI Assistant" button, including for administrators.';
 $string['aiassistantheader_help'] = 'The AI Assistant is an integrated chatbot that answers student questions directly from course materials.

- Teachers must be assigned the **Amanote AI Creator** role to create an AI Assistant for their courses.
- A default monthly AI credit limit is included for testing. Contact Amanote Support to request additional credits.';
 $string['amanote:createaiassistant'] = 'Create Amanote AI Assistant';
 $string['annotateresource'] = 'Annotate';
 $string['anonymous'] = 'Anonymous';
 $string['anonymous_help'] = 'With this option, users are anonymous in Amanote and no authentication is required. However, the collaboration and podcast features will no longer be available. Finally, to activate this feature you must enable the saving in the private files and add an activation key.';
 $string['deletefilewarning'] = 'Please note, if you delete this resource, any notes associated with it will no longer be accessible by students. If your intention is to update the resource, consider editing it instead of deleting it. This will preserve student notes.';
 $string['downloadnotes'] = 'Download annotated file';
 $string['feedbacknotification'] = 'You have received new feedback in the course {$a->course}';
 $string['feedbacknotification_body'] = 'Feedback has been provided on the document <strong>{$a->filename}</strong> in the course <strong>{$a->course}</strong>.<br><br><a href="{$a->url}" target="_blank">Open document analytics</a>.';
 $string['filtername'] = 'Amanote';
 $string['foldereditwarning'] = 'Deleting or renaming files in this folder may affect students who have already taken notes on those files.';
 $string['importantinformationdescription'] = 'In order for the module to work properly, please check that the following requirements are met on your Moodle site:

 1. Amanote filter is enabled (Site administration > Plugins > Filters > Manage filters)

 2. Web services are enabled (Site administration > Advanced feature)

 3. *Moodle mobile web service* is enabled (Site administration > Plugins > Web services > External services)

 4. REST protocol is activated (Site administration > Plugins > Web services > Manage protocols)

 5. Capability *webservice/rest:use* is allowed for *authenticated users* (Site administration > Users > Permissions > Define Roles > Authenticated Users > Manage roles)';
 $string['importantinformationheading'] = 'Important installation information';
 $string['key'] = 'Activation key';
 $string['key_help'] = 'This key is required for advanced features such as Podcast Creator and for anonymous mode.';
 $string['messageprovider:feedback'] = 'Submission of a feedback';
 $string['messageprovider:question'] = 'Submission of a question';
 $string['messageprovider:submission'] = 'Submission of a student\'s notes or work';
 $string['modaldescription'] = 'You can take clear and structured notes directly on your course materials by clicking on the button below.';
 $string['openanalytics'] = 'See learning analytics';
 $string['openingmode'] = 'Opening mode';
 $string['openingmode_fileclick'] = 'Click on the resource (best user experience)';
 $string['openingmode_help'] = 'Select the method to open a resource with Amanote.';
 $string['openingmode_iconnexttofile'] = 'Small icon next to resources';
 $string['openingmode_iconnexttofilewithtext'] = '"Take notes" button next to the resources';
 $string['openingmode_logonexttofile'] = 'Amanote logo next to resources';
 $string['openpodcast'] = 'Add oral explanations';
 $string['openstudentsworks'] = 'Open student works';
 $string['pluginadministration'] = 'Amanote module administration';
 $string['pluginname'] = 'Amanote';
 $string['preventdownload'] = 'Prevent download';
 $string['preventdownload_help'] = 'When enabled, this option prevents users from downloading the original course material (i.e. the teacher\'s PDF file).';
 $string['privacy:metadata'] = 'In order to integrate with Amanote, some user data need to be sent to the Amanote client application (remote system).';
 $string['privacy:metadata:access_token'] = 'The user\'s access token is required to save the notes in the Moodle\'s private files space.';
 $string['privacy:metadata:access_token_expiration'] = 'The access token\'s expiration is sent to prevent the user to use the app with an expired token.';
 $string['privacy:metadata:email'] = 'The user\'s email is sent to the remote system to allow a better user experience (note sharing, etc.).';
 $string['privacy:metadata:fullname'] = 'The user\'s full name is sent to the remote system to allow a better user experience.';
 $string['privacy:metadata:subsystem:corefiles'] = 'Files (PDF, AMA) are stored using Moodle\'s file system.';
 $string['privacy:metadata:userid'] = 'The userid is sent from Moodle to Amanote in order to speed up the authentication process.';
 $string['questionnotification'] = 'There is a new question in the course {$a->course}';
 $string['questionnotification_body'] = 'There is a new question on the file <strong>{$a->filename}</strong> in the course <strong>{$a->course}</strong>.<br><br><a href="{$a->url}" target="_blank">Open course material</a>. ';
 $string['saveinprivate'] = 'Save notes in private files';
 $string['saveinprivate_help'] = 'When enabled, it saves annotated files in the user\'s private files on Moodle rather than on the Amanote servers.';
 $string['seeguide'] = 'See how in our guide';
 $string['settingsadvancedoptions'] = 'Advanced options';
 $string['stopmodal'] = 'Stop showing this message';
 $string['submissionnotification'] = '{$a->user} has submitted a work';
 $string['submissionnotification_body'] = '{$a->user} has submitted a work in course <strong>{$a->course}</strong>.<br><br><a href="{$a->url}" target="_blank">Open</a>. ';
 $string['takenotesicon'] = 'note-icon-en';
 $string['target'] = 'Target';
 $string['target_help'] = 'Select the location where the user will be redirected to annotate the resource.';
 $string['target_inamanote'] = 'Amanote site (best user experience)';
 $string['target_inmoodle'] = 'Embedded in Moodle';
 $string['target_inmoodlefullscreen'] = 'Moodle in full screen';
 $string['teacher'] = 'Teacher';
 $string['viewresource'] = 'View here';
 $string['worksheet'] = 'Send to teacher';
 $string['worksheet_help'] = 'This option allows learners to send their notes or assignments to the teacher. The teacher can then correct the notes and send them back to the learner.';
