<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Amanote launch page.
 *
 * @package     filter_amanote
 * @copyright   2025 Amaplex Software
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../../config.php');
require_once('../../lib/externallib.php');
require_once('./amanote.php');

// Verify that the current user is logged in.
require_login();

// Initialize params.
$annotatableid = required_param('annotatableId', PARAM_RAW);
$pagenumber = optional_param('pagenumber', null, PARAM_INT);
$route = optional_param('route', null, PARAM_RAW);

if (!validate_annotatableid($annotatableid)) {
    throw new moodle_exception('invalidannotatableid' . $annotatableid, 'filter_amanote');
}

$amanoteurl = generate_amanote_url($annotatableid, null, $pagenumber, $route);

redirect($amanoteurl);
