<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Amanote role helper functions.
 *
 * @package     filter_amanote
 * @copyright   2025 Amaplex Software
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Ensure the Amanote AI Creator role exists.
 *
 * @return void
 */
function filter_amanote_ensure_aicreator_role_exists() {
    if (!role_shortname_exists('aicreator')) {
        // Create the role.
        $roleid = create_role(
            'Amanote AI Creator',
            'aicreator',
            'Teachers allowed to create AI Assistants with Amanote',
            '',
        );

        // Set the role as available in the system context.
        set_role_contextlevels($roleid, [CONTEXT_SYSTEM]);

        // Assign Create AI Assistant capability to the role.
        assign_capability(
            'filter/amanote:createaiassistant',
            CAP_ALLOW,
            $roleid,
            context_system::instance()
        );
    }
}

/**
 * Check if a role with the given shortname exists.
 *
 * @param string $shortname The shortname of the role to check.
 *
 * @return bool True if the role exists, false otherwise.
 */
function role_shortname_exists(string $shortname) {
    $roles = get_all_roles();

    foreach ($roles as $role) {
        if ($role->shortname === $shortname) {
            return true;
        }
    }

    return false;
}
