<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     media_mediasite
 * @category    string
 * @copyright   2025 Andrew Rowatt <A.J.Rowatt@massey.ac.nz>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['authorization'] = 'Authorization header value';
$string['authorization_desc'] = 'Value assigned to the Authorization header in the HTTP request.';
$string['basemediasiteurl'] = 'Base Mediasite URL';
$string['basemediasiteurl_desc'] = 'The base or root URL for the Mediasite server';
$string['pluginname'] = 'Mediasite';
$string['presentationisprivate'] = 'Presentation is currently private. Your students will not be able to view it.';
$string['presentationispublic'] = 'Presentation is viewable.';
$string['presentationnotfound'] = 'Presentation not found.  Check the presentation ID.';
$string['presentationregex'] = 'Presentation regex';
$string['presentationregex_desc'] = 'Regex to match a Mediasite presentation URL';
$string['presentationstatusunknown'] = 'Error accessing the presentation.  Contact Stream Support.';
$string['presentationsubstitution'] = 'Presentation replacement';
$string['presentationsubstitution_desc'] = 'Template for replacement content for the presentation link';
$string['privacy:metadata'] = 'This plugin does not store any data at all.';
$string['sfapikey'] = 'API key (sfapikey)';
$string['sfapikey_desc'] = 'Value assigned to the sfapikey header in the HTTP request.';
