define("tiny_persistentresize/storage",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.setItem=_exports.removeItem=_exports.getItem=_exports.getAllKeys=void 0;
/**
   * IndexedDB storage utility for persistent resize plugin
   *
   * @module     tiny_persistentresize/storage
   * @copyright  2025 Andrew Rowatt <A.J.Rowatt@massey.ac.nz>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const STORE_NAME="editorSizes",openDB=()=>new Promise(((resolve,reject)=>{const request=indexedDB.open("tiny_persistentresize",1);request.onerror=()=>reject(request.error),request.onsuccess=()=>resolve(request.result),request.onupgradeneeded=event=>{const db=event.target.result;db.objectStoreNames.contains(STORE_NAME)||db.createObjectStore(STORE_NAME)}}));_exports.setItem=async(key,value)=>{const db=await openDB();return new Promise(((resolve,reject)=>{const transaction=db.transaction([STORE_NAME],"readwrite"),request=transaction.objectStore(STORE_NAME).put(value,key);request.onerror=()=>reject(request.error),request.onsuccess=()=>resolve(),transaction.oncomplete=()=>db.close()}))};_exports.getItem=async key=>{const db=await openDB();return new Promise(((resolve,reject)=>{const transaction=db.transaction([STORE_NAME],"readonly"),request=transaction.objectStore(STORE_NAME).get(key);request.onerror=()=>reject(request.error),request.onsuccess=()=>resolve(request.result||null),transaction.oncomplete=()=>db.close()}))};_exports.removeItem=async key=>{const db=await openDB();return new Promise(((resolve,reject)=>{const transaction=db.transaction([STORE_NAME],"readwrite"),request=transaction.objectStore(STORE_NAME).delete(key);request.onerror=()=>reject(request.error),request.onsuccess=()=>resolve(),transaction.oncomplete=()=>db.close()}))};_exports.getAllKeys=async()=>{const db=await openDB();return new Promise(((resolve,reject)=>{const transaction=db.transaction([STORE_NAME],"readonly"),request=transaction.objectStore(STORE_NAME).getAllKeys();request.onerror=()=>reject(request.error),request.onsuccess=()=>resolve(request.result||[]),transaction.oncomplete=()=>db.close()}))}}));

//# sourceMappingURL=storage.min.js.map