<?php
define('AJAX_SCRIPT', true);

require_once(__DIR__ . '/../../config.php');

require_login();

$context = context_system::instance();
require_capability('local/asyntai:manage', $context);

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!is_array($data)) {
    $data = array();
}

if (empty($data['sesskey']) || !confirm_sesskey($data['sesskey'])) {
    header('Content-Type: application/json');
    http_response_code(403);
    echo json_encode(array('success' => false, 'error' => 'forbidden'));
    die;
}

$action = isset($data['action']) ? (string)$data['action'] : '';
if ($action !== 'save') {
    header('Content-Type: application/json');
    http_response_code(400);
    echo json_encode(array('success' => false, 'error' => 'invalid action'));
    die;
}

$siteid = isset($data['site_id']) ? trim((string)$data['site_id']) : '';
$scripturl = isset($data['script_url']) ? trim((string)$data['script_url']) : '';
$accountemail = isset($data['account_email']) ? trim((string)$data['account_email']) : '';

if ($siteid === '') {
    header('Content-Type: application/json');
    http_response_code(400);
    echo json_encode(array('success' => false, 'error' => 'missing site_id'));
    die;
}

set_config('site_id', $siteid, 'local_asyntai');
if ($scripturl !== '') {
    set_config('script_url', $scripturl, 'local_asyntai');
}
if ($accountemail !== '') {
    set_config('account_email', $accountemail, 'local_asyntai');
}

header('Content-Type: application/json');
echo json_encode(array('success' => true));
die;

