<?php
namespace local_asyntai\privacy;

defined('MOODLE_INTERNAL') || die();

use core_privacy\local\metadata\collection;
use core_privacy\local\metadata\provider as metadata_provider;
use core_privacy\local\request\contextlist;
use core_privacy\local\request\plugin\provider as request_provider;

/**
 * Privacy provider: this plugin stores only site configuration, no user data.
 */
class provider implements metadata_provider, request_provider {
    public static function get_metadata(collection $items) : collection {
        // No user data stored. Admin configuration only.
        return $items;
    }

    public static function get_contexts_for_userid(int $userid) : contextlist {
        // No user contexts.
        return new contextlist();
    }

    public static function export_user_data(\core_privacy\local\request\approved_contextlist $contextlist) {
        // Nothing to export.
    }

    public static function delete_data_for_all_users_in_context(\context $context) {
        // Nothing to delete.
    }

    public static function delete_data_for_user(\core_privacy\local\request\approved_contextlist $contextlist) {
        // Nothing to delete.
    }
}

