<?php
defined('MOODLE_INTERNAL') || die();

/**
 * Inject the Asyntai chat widget on all pages when configured.
 * This runs on most page loads as navigation is built.
 *
 * @param global_navigation $nav
 * @return void
 */
function local_asyntai_extend_navigation(global_navigation $nav) {
    global $PAGE;

    // Inject the Asyntai chat widget on all pages when configured.
    $siteid = (string) get_config('local_asyntai', 'site_id');
    if ($siteid === '') {
        return;
    }
    $scripturl = (string) get_config('local_asyntai', 'script_url');
    if ($scripturl === '') {
        $scripturl = 'https://asyntai.com/static/js/chat-widget.js';
    }

    // Inline loader mirrors other CMS plugins: async+defer and data-asyntai-id attribute.
    $code = '(function(){var s=document.createElement("script");s.async=true;s.defer=true;s.src=' . json_encode($scripturl) . ';s.setAttribute("data-asyntai-id",' . json_encode($siteid) . ');s.charset="UTF-8";var f=document.getElementsByTagName("script")[0];if(f&&f.parentNode){f.parentNode.insertBefore(s,f);}else if(document.head){document.head.appendChild(s);}})();';
    $PAGE->requires->js_init_code($code);
}


