<?php
require_once(__DIR__ . '/../../config.php');

require_login();

$context = context_system::instance();
require_capability('local/asyntai:manage', $context);

$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/asyntai/manage.php'));
$PAGE->set_pagelayout('admin');
$PAGE->set_title('Asyntai AI Chatbot');
$PAGE->set_heading('Asyntai AI Chatbot');

$reset = optional_param('reset', 0, PARAM_INT);
if ($reset && confirm_sesskey()) {
    set_config('site_id', '', 'local_asyntai');
    set_config('script_url', '', 'local_asyntai');
    set_config('account_email', '', 'local_asyntai');
    redirect(new moodle_url('/local/asyntai/manage.php'));
}

$siteid = (string) get_config('local_asyntai', 'site_id');
$accountemail = (string) get_config('local_asyntai', 'account_email');

echo $OUTPUT->header();

// Status line (match wording from other plugins).
$statushtml = '';
if ($siteid !== '') {
    $statushtml = html_writer::div(
        'Status: ' . html_writer::span('Connected', '', array('style' => 'color:#008a20;')) .
        ($accountemail !== '' ? (' as ' . s($accountemail)) : '') .
        ' ' . html_writer::link(new moodle_url('/local/asyntai/manage.php', array('reset' => 1, 'sesskey' => sesskey())), 'Reset', array('class' => 'btn btn-secondary', 'style' => 'margin-left:8px;')),
        '', array('id' => 'asyntai-status', 'style' => 'margin:10px 0;')
    );
} else {
    $statushtml = html_writer::div('Status: ' . html_writer::span('Not connected', '', array('style' => 'color:#a00;')), '', array('id' => 'asyntai-status', 'style' => 'margin:10px 0;'));
}
echo $statushtml;

// Alert placeholder
echo html_writer::div('', 'alert', array('id' => 'asyntai-alert', 'style' => 'display:none;margin-top:10px;'));

// Connected box
echo html_writer::start_div('', array('id' => 'asyntai-connected-box', 'style' => 'display:' . ($siteid ? 'block' : 'none') . ';'));
echo html_writer::start_div('', array('style' => 'max-width:820px;margin:20px auto;padding:20px;border:1px solid #ddd;border-radius:8px;background:#fff;text-align:center;'));
echo html_writer::div('Asyntai is now enabled', '', array('style' => 'font-size:20px;font-weight:700;margin-bottom:8px;'));
echo html_writer::div('Set up your AI chatbot, review chat logs and more:', '', array('style' => 'font-size:16px;margin-bottom:16px;'));
echo html_writer::link(new moodle_url('https://asyntai.com/dashboard'), 'Open Asyntai Panel', array('class' => 'btn btn-primary', 'target' => '_blank', 'rel' => 'noopener'));
// Add tip section
echo html_writer::div(
    html_writer::tag('strong', 'Tip: ') . 'If you want to change how the AI answers, please ' . 
    html_writer::link('https://asyntai.com/dashboard#setup', 'go here', array('target' => '_blank', 'rel' => 'noopener', 'style' => 'color:#3182ce;text-decoration:underline;')) . '.',
    '', 
    array('style' => 'margin-top:16px;font-size:14px;color:#666;')
);
echo html_writer::end_div();
echo html_writer::end_div();

// Popup connect UI
echo html_writer::start_div('', array('id' => 'asyntai-popup-wrap', 'style' => 'display:' . ($siteid ? 'none' : 'block') . ';'));
echo html_writer::start_div('', array('style' => 'max-width:960px;margin:60px auto;padding:32px;border:1px solid #ddd;border-radius:16px;background:#fff;text-align:center;'));
echo html_writer::div('Create a free Asyntai account or sign in to enable the chatbot', '', array('style' => 'font-size:18px;margin-bottom:12px;'));
echo html_writer::tag('button', 'Get started', array('id' => 'asyntai-connect-btn', 'class' => 'btn btn-primary'));
$connecturl = 'https://asyntai.com/moodle-auth?platform=moodle';
echo html_writer::div('If it doesn\'t work, ' . html_writer::link('#', 'open the connect window', array('id' => 'asyntai-fallback-link', 'target' => '_blank', 'rel' => 'noopener')) . '.', '', array('style' => 'margin-top:12px;color:#666;'));
echo html_writer::end_div();
echo html_writer::end_div();

// Inline JS configuration and logic (mirrors WP/Joomla popup+poll flow).
$cfg = array(
    'ajaxUrl' => (new moodle_url('/local/asyntai/ajax.php'))->out(false),
    'sesskey' => sesskey(),
    'expectedOrigin' => 'https://asyntai.com',
    'isConnected' => (bool) $siteid,
    'resetUrl' => (new moodle_url('/local/asyntai/manage.php', array('reset' => 1, 'sesskey' => sesskey())))->out(false),
    'connectUrl' => $connecturl,
);

$inlinejs = '(function(){var currentState=null;function showAlert(msg,ok){var el=document.getElementById("asyntai-alert");if(!el)return;el.style.display="block";el.className="alert "+(ok?"alert-success":"alert-danger");el.textContent=msg;}function generateState(){return"moodle_"+Math.random().toString(36).substr(2,9);}function updateFallbackLink(){var fallbackLink=document.getElementById("asyntai-fallback-link");if(fallbackLink&&currentState){fallbackLink.href="https://asyntai.com/moodle-auth?platform=moodle&state="+encodeURIComponent(currentState);}}function openPopup(){currentState=generateState();updateFallbackLink();var base=(window.ASYNTAI_CONFIG&&ASYNTAI_CONFIG.connectUrl)||"";if(!base)return;var url=base+(base.indexOf("?")>-1?"&":"?")+"state="+encodeURIComponent(currentState);var w=800,h=720;var y=window.top.outerHeight/2+window.top.screenY-(h/2);var x=window.top.outerWidth/2+window.top.screenX-(w/2);var pop=window.open(url,"asyntai_connect","toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width="+w+",height="+h+",top="+y+",left="+x);if(!pop){showAlert("Popup blocked. Please allow popups or use the link below.",false);return;}pollForConnection(currentState);}currentState=generateState();updateFallbackLink();function pollForConnection(state){var attempts=0;function check(){if(attempts++>60)return;var script=document.createElement("script");var cb="asyntai_cb_"+Date.now();var origin=(window.ASYNTAI_CONFIG&&ASYNTAI_CONFIG.expectedOrigin)||"https://asyntai.com";script.src=origin+"/connect-status.js?state="+encodeURIComponent(state)+"&cb="+cb;window[cb]=function(data){try{delete window[cb]}catch(e){}if(data&&data.site_id){saveConnection(data);return;}setTimeout(check,500);};script.onerror=function(){setTimeout(check,1000);};document.head.appendChild(script);}setTimeout(check,800);}function saveConnection(data){showAlert("Asyntai connected. Saving…",true);var t=window.ASYNTAI_CONFIG||{};var payload={action:"save",sesskey:t.sesskey||"",site_id:data.site_id||""};if(data.script_url)payload.script_url=data.script_url;if(data.account_email)payload.account_email=data.account_email;fetch(t.ajaxUrl,{method:"POST",credentials:"same-origin",headers:{"Content-Type":"application/json"},body:JSON.stringify(payload)}).then(function(r){if(!r.ok)throw new Error("HTTP "+r.status);return r.json()}).then(function(json){if(!json||!json.success)throw new Error(json&&json.error||"Save failed");showAlert("Asyntai connected. Chatbot enabled on all pages.",true);var status=document.getElementById("asyntai-status");if(status){var html="Status: <span style=\\"color:#008a20;\\">Connected</span>";if(data.account_email){html+=" as "+data.account_email+" <a class=\\"btn btn-secondary\\" style=\\"margin-left:8px;\\" href=\\""+(t.resetUrl||"#")+"\\">Reset</a>";}status.innerHTML=html;}var box=document.getElementById("asyntai-connected-box");if(box)box.style.display="block";var wrap=document.getElementById("asyntai-popup-wrap");if(wrap)wrap.style.display="none";}).catch(function(err){try{console.error("[Asyntai] save error",err)}catch(e){}showAlert("Could not save settings: "+(err&&err.message||err),false)});}document.addEventListener("click",function(ev){var t=ev.target;if(t&&t.id==="asyntai-connect-btn"){ev.preventDefault();openPopup();}if(t&&t.id==="asyntai-fallback-link"){currentState=generateState();updateFallbackLink();setTimeout(function(){pollForConnection(currentState);},1000);}});})();';

// Output the config and inline logic.
echo html_writer::script('window.ASYNTAI_CONFIG = ' . json_encode($cfg) . ';');
echo html_writer::script($inlinejs);

echo $OUTPUT->footer();

