/* This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// any later version.
/**
 * Privacy Subsystem implementation for mod_mooproof
 *
 * @package    block_moochat
 * @copyright  2025 Brian A. Pool
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_moochat/chat",["jquery","core/ajax","core/notification"],(function($,Ajax,Notification){return{init:function(instanceid,strings){var conversationHistory=[],remainingQuestions=-1,messagesDiv=$("#moochat-messages-"+instanceid),inputField=$("#moochat-input-"+instanceid),sendButton=$("#moochat-send-"+instanceid),clearButton=$("#moochat-clear-"+instanceid),remainingDiv=$('<div class="moochat-remaining" id="moochat-remaining-'+instanceid+'"></div>');$("#moochat-"+instanceid).prepend(remainingDiv);var updateRemaining=function(remaining){if(remaining>=0){var message=strings.questionsremaining.replace("{$a}",remaining);remainingDiv.html('<p class="alert alert-info">'+message+"</p>"),remainingDiv.show()}else remainingDiv.hide()},sendMessage=function(){var message=inputField.val().trim();if(""!==message){inputField.prop("disabled",!0),sendButton.prop("disabled",!0),addMessage("user",message),conversationHistory.push({role:"user",content:message}),inputField.val("");var thinkingId="thinking-"+Date.now();messagesDiv.append('<div class="moochat-message moochat-assistant" id="'+thinkingId+'"><em>'+strings.thinking+"</em></div>"),scrollToBottom(),Ajax.call([{methodname:"block_moochat_send_message",args:{instanceid:instanceid,message:message,history:JSON.stringify(conversationHistory)},done:function(response){$("#"+thinkingId).remove(),response.success?response.success&&response.reply&&(addMessage("assistant",response.reply),conversationHistory.push({role:"assistant",content:response.reply}),void 0!==response.remaining&&(remainingQuestions=response.remaining,updateRemaining(remainingQuestions),0===remainingQuestions&&(inputField.prop("disabled",!0),sendButton.prop("disabled",!0)))):void 0!==response.remaining&&0===response.remaining?(Notification.alert(strings.ratelimitreached_title,response.error,"OK"),inputField.prop("disabled",!0),sendButton.prop("disabled",!0),updateRemaining(0)):response.error===strings.maxmessagesreached?Notification.alert(strings.chatlimitreached,response.error,"OK"):Notification.alert(strings.error,response.error,"OK"),0!==remainingQuestions&&(inputField.prop("disabled",!1),sendButton.prop("disabled",!1),inputField.focus())},fail:function(){$("#"+thinkingId).remove(),Notification.alert(strings.error,strings.connectionerror,"OK"),inputField.prop("disabled",!1),sendButton.prop("disabled",!1)}}])}},addMessage=function(role,content){var messageHtml='<div class="moochat-message '+("user"===role?"moochat-user":"moochat-assistant")+'">'+escapeHtml(content)+"</div>";messagesDiv.append(messageHtml),scrollToBottom()},scrollToBottom=function(){messagesDiv.scrollTop(messagesDiv[0].scrollHeight)},escapeHtml=function(text){var div=document.createElement("div");return div.textContent=text,div.innerHTML};sendButton.on("click",sendMessage),inputField.on("keypress",(function(e){13!==e.which||e.shiftKey||(e.preventDefault(),sendMessage())})),clearButton.on("click",(function(){confirm(strings.confirmclear)&&(conversationHistory=[],messagesDiv.html('<p class="moochat-welcome">'+strings.chatcleared+"</p>"),inputField.val("").focus())})),inputField.focus()}}}));

//# sourceMappingURL=chat.min.js.map