/**
 * AMD module for AI Check button
 *
 * @module     local_aicheck/check_button
 * @copyright  2026 Brian A. Pool, National Trail Local Schools
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_aicheck/check_button",["jquery","core/ajax","core/str","core/notification"],(function($,Ajax,Str,Notification){return{init:function(cmid,buttonText){var insertButton=function(){if($(".aicheck-button-injected").length>0)return!0;var button=$("<button>").attr("type","button").addClass("btn btn-secondary aicheck-button-injected").css("margin-left","10px").text(buttonText).on("click",(function(){var btn=$(this),originalText=btn.text();Str.get_strings([{key:"checking",component:"local_aicheck"},{key:"feedback_title",component:"local_aicheck"},{key:"feedback_close",component:"local_aicheck"},{key:"error_processing",component:"local_aicheck"}]).done((function(strings){btn.prop("disabled",!0).text(strings[0]),Ajax.call([{methodname:"local_aicheck_check_submission",args:{cmid:cmid}}])[0].done((function(response){if(response.success)showFeedbackModal(strings[1],response.feedback,strings[2]);else{var errorMsg=response.error||"Unknown error";Notification.alert(strings[1],errorMsg,strings[2])}btn.prop("disabled",!1).text(originalText)})).fail((function(error){var errorMsg=error.message||"Unknown error";Notification.alert(strings[1],strings[3].replace("{$a}",errorMsg),strings[2]),btn.prop("disabled",!1).text(originalText)}))})).fail((function(){btn.prop("disabled",!0).text("Checking..."),Ajax.call([{methodname:"local_aicheck_check_submission",args:{cmid:cmid}}])[0].done((function(response){response.success?showFeedbackModal("AI Feedback",response.feedback,"Close"):alert("Error: "+(response.error||"Unknown error")),btn.prop("disabled",!1).text(originalText)})).fail((function(error){alert("Error: "+(error.message||"Unknown error")),btn.prop("disabled",!1).text(originalText)}))}))})),inserted=!1,submitButton=$('input[type="submit"][name="submitbutton"]');if(submitButton.length&&(submitButton.after(button),inserted=!0),!inserted){var statusTable=$(".submissionstatustable");statusTable.length&&(statusTable.after($("<div>").addClass("aicheck-button-container").css({"margin-top":"10px","text-align":"center"}).append(button)),inserted=!0)}if(!inserted){var pageContent=$("#region-main").first();pageContent.length&&(pageContent.prepend($("<div>").addClass("alert alert-info").css("margin","15px").append(button)),inserted=!0)}return inserted},showFeedbackModal=function(title,feedback,closeText){var modal=$("<div>").addClass("modal fade").attr("tabindex","-1").attr("role","dialog"),modalDialog=$("<div>").addClass("modal-dialog modal-lg").attr("role","document"),modalContent=$("<div>").addClass("modal-content"),modalHeader=$("<div>").addClass("modal-header");modalHeader.append($("<h5>").addClass("modal-title").text(title)),modalHeader.append($("<button>").addClass("close").attr("type","button").attr("data-dismiss","modal").attr("aria-label",closeText).html("&times;"));var modalBody=$("<div>").addClass("modal-body").css({"white-space":"pre-wrap","font-size":"14px","line-height":"1.6"}).text(feedback),modalFooter=$("<div>").addClass("modal-footer");modalFooter.append($("<button>").addClass("btn btn-primary").attr("type","button").attr("data-dismiss","modal").text(closeText)),modalContent.append(modalHeader,modalBody,modalFooter),modalDialog.append(modalContent),modal.append(modalDialog),$("body").append(modal),modal.modal("show"),modal.on("hidden.bs.modal",(function(){modal.remove()}))};$(document).ready((function(){if(!insertButton())var checkCount=0,insertInterval=setInterval((function(){checkCount++,(insertButton()||checkCount>=10)&&clearInterval(insertInterval)}),500)})),$(window).on("load",(function(){insertButton()}))}}}));

//# sourceMappingURL=check_button.min.js.map