/**
 * AMD module for AI Grade bulk grading button
 *
 * @module     local_aigrade/grade_bulk
 * @copyright  2025 Brian A. Pool, National Trail Local Schools
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_aigrade/grade_bulk",["jquery","core/notification"],(function($,Notification){return{init:function(buttonUrl,buttonText,sesskey){var insertButton=function(){if($(".aigrade-button-injected").length>0)return!0;var button=$("<button>").attr("type","button").addClass("btn btn-primary aigrade-button-injected").text(buttonText).on("click",(function(){var btn=$(this),originalText=btn.text(),groupParam=new URLSearchParams(window.location.search).get("group")||"",groupQuery=groupParam?"&group="+groupParam:"";confirm("Grade all ungraded submissions with AI? This may take a few moments.")&&(btn.prop("disabled",!0).text("Grading all submissions..."),$.ajax({url:buttonUrl+"&action=grade&sesskey="+sesskey+groupQuery,method:"POST",dataType:"json",success:function(response){response.success?(Notification.addNotification({message:"Successfully graded "+response.count+" submission(s).",type:"success"}),window.location.reload()):(Notification.addNotification({message:"Error: "+(response.error||"Unknown error occurred"),type:"error"}),btn.prop("disabled",!1).text(originalText))},error:function(xhr,status,error){Notification.addNotification({message:"Error communicating with server: "+error,type:"error"}),btn.prop("disabled",!1).text(originalText)}}))})),container=$("<div>").addClass("mb-3").append(button),submissionsTable=$("table.flexible, table.generaltable").first();if(submissionsTable.length)return submissionsTable.before(container),!0;var mainContent=$("#region-main").first();return!!mainContent.length&&(mainContent.prepend(container),!0)};setTimeout(insertButton,100),$(document).ready((function(){setTimeout(insertButton,100)})),$(window).on("load",(function(){setTimeout(insertButton,200)}));var checkCount=0,checkInterval=setInterval((function(){checkCount++,(insertButton()||checkCount>=20)&&clearInterval(checkInterval)}),500)}}}));

//# sourceMappingURL=grade_bulk.min.js.map