/*
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Clean Grader Report
 *
 * This plugin allows teachers to print student grades more cleanly for parent conferences.
 *
 * @package    local_cleangradereport
 * @copyright  2025 Brian A. Pool, National Trail Local Schools
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_cleangradereport/print_grades",["jquery","core/str"],(function($,str){return{init:function(){$(document).ready((function(){var gradeContent=$('.path-grade-report-user, .grade-report-user, [data-region="grade-report"]');if(gradeContent.length>0){var urlParams=new URLSearchParams(window.location.search),userid=urlParams.get("userid"),courseid=urlParams.get("id");if(userid||(userid=$('input[name="userid"]').val()||M.cfg.userid),courseid&&userid){var printUrl=M.cfg.wwwroot+"/local/cleangradereport/print_report.php?courseid="+courseid+"&userid="+userid;str.get_string("printcleanreport","local_cleangradereport").then((function(printText){var printButton=$('<div class="mb-3 local-cleangradereport-print-button"><a href="'+printUrl+'" target="_blank" class="btn btn-primary"><i class="fa fa-print" aria-hidden="true"></i> '+printText+"</a></div>"),insertLocation=$(".grade-report-user table").first();insertLocation.length>0?insertLocation.before(printButton):gradeContent.first().prepend(printButton)})).catch((function(){window.console.error("Failed to load language string")}))}}}))}}}));

//# sourceMappingURL=print_grades.min.js.map