# eFlow Ai Tutor for Moodle

This plugin integrates an AI tutoring system into Moodle, providing real-time assistance to students and teachers.

## Features

- Floating chat button that can be positioned anywhere on the screen
- Real-time AI responses through API integration
- Customizable appearance
- Iframe mode support with dynamic Moodle variable insertion
- Automatic polling for new responses

## Installation

1. Extract the plugin files to `/local/eflow_aitutor` in your Moodle installation
2. Visit Site Administration > Notifications to complete the installation
3. Configure the plugin in Site Administration > Plugins > Local plugins > eFlow Ai Tutor

## Configuration

1. Enable the plugin
2. Set the API credentials (username and password)
3. Configure the appearance settings
4. Customize which courses have the tutor enabled

## API Polling

The plugin automatically polls the eFlow API every 30 seconds to check for new responses. This happens when:

1. The chat interface is open
2. The user is active on the page

Polling is automatically paused when the chat is closed to conserve resources.

### Default Parameters

The API polling includes these default hardcoded parameters:
- `group_id`: 2
- `course_id`: 298
- `flag`: with_option

These values will be used for all API calls. In future versions, these will be made configurable.

## Technical Details

### API Integration

The plugin connects to the eFlow API for AI responses. The flow is:

1. User sends a message from the chat interface
2. Message is sent to the API via AJAX
3. Plugin polls the API every 30 seconds for new responses with default parameters
4. New responses are displayed in the chat interface automatically

### Iframe Mode

When iframe mode is enabled, the plugin can display external content in an iframe instead of the chat interface. The iframe URL can include the following Moodle variable placeholders:

- `moodle_user_id`: The current user's ID
- `moodle_course_id`: The current course's ID
- `moodle_activity_id`: The current activity's ID (if available)

For example, if you set the iframe URL to:
```
https://learn.eflow.app/embed/eL990000316938e/moodle_user_id/moodle_course_id/moodle_activity_id/app
```

The plugin will automatically replace the placeholders with actual values:
```
https://learn.eflow.app/embed/eL990000316938e/42/123/456/app
```

This allows the iframe content to be aware of the Moodle context in which it's being displayed.

### JavaScript Components

- `chat.js`: Main chat interface
- `poller.js`: Handles API polling functionality

### PHP Components

- `classes/external/send_message.php`: Sends messages to the API
- `classes/external/check_responses.php`: Checks for new responses
- `lib.php`: Contains utility functions including API authentication

## License

This plugin is licensed under the GNU GPL v3 or later.
