/**
 * eFlow Ai Tutor chat module.
 *
 * @module     local_eflow_aitutor/chat
 * @copyright  2025 Nawaz sharif<shasharif02@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_eflow_aitutor/chat",["jquery","core/ajax","core/notification","core/str","./poller"],function($,Ajax,Notification,Str,ApiPoller){return{init:function(params){if(console.log("eFlow Ai Tutor chat module initialized with params:",params),$&&"function"==typeof $){var poller=null,selectedImage=null;console.log("Initial selectedImage:",selectedImage),$(document).ready(function(){if(window.location.href.includes("course/view.php?id="))var id=0;else id=new URLSearchParams(window.location.search).get("id")??0;var element=$(".floating-chat");if(console.log("Found floating-chat elements:",element.length),0!==element.length){params.userProfileImageUrl?$("<style>").prop("type","text/css").html('.floating-chat .messages li.self:before { background-image: url("'+params.userProfileImageUrl+'") !important; background-size: cover !important; }').appendTo("head"):params.defaultImageUrl&&$("<style>").prop("type","text/css").html('.floating-chat .messages li.self:before { background-image: url("'+params.defaultImageUrl+'") !important; background-size: cover !important; }').appendTo("head");var isIframeMode=element.find(".iframe-container").length>0;console.log("Iframe mode is "+(isIframeMode?"enabled":"disabled")),console.log("Iframe container elements found:",element.find(".iframe-container").length),console.log("Iframe elements found:",element.find("iframe").length);var floatOption="with_option";void 0!==params.floatOption&&(floatOption=params.floatOption),console.log("Float option is set to:",floatOption),poller=new ApiPoller({courseId:params.courseId,userId:params.userId,interval:3e4,onNewResponse:function(responses){if(hideMainLoader(),hideMessageLoader(),element.find("#sendMessage").prop("disabled",!1),!responses||!responses.length)return;var messagesContainer=element.find(".messages");1===messagesContainer.find("li").length&&0===messagesContainer.find("li").first().text().indexOf("Hello! I'm your AI tutor assistant")&&messagesContainer.empty();responses.sort(function(a,b){return a.id-b.id}),console.log("Processing responses:",responses),responses.forEach(function(response){if(!(messagesContainer.find('[id="'+response.id+'"]').length>0)){if(response.is_user){var existingUserMsg=messagesContainer.find("li.self:not([id])").last();if(existingUserMsg.length>0)if(existingUserMsg.html().replace(/<[^>]*>/g,"").trim()===(response.message||"").replace(/<[^>]*>/g,"").trim())return void existingUserMsg.attr("id",response.id)}var messageClass=response.is_user?"self":"other",messageContent=response.message;if(console.log("Processing message:",response),response.media&&null!==response.media&&""!==response.media){var mediaUrl=response.media;console.log("Original media URL:",mediaUrl),mediaUrl.startsWith("http")||(mediaUrl="https://eflow-static01.s3-us-west-2.amazonaws.com/media/"+mediaUrl,console.log("Updated media URL:",mediaUrl)),messageContent+=getMediaHtml(mediaUrl)}messagesContainer.append(['<li class="'+messageClass+'" id="'+response.id+'">',messageContent,"</li>"].join(""))}}),messagesContainer.finish().animate({scrollTop:messagesContainer.prop("scrollHeight")},250)},floatOption:floatOption}),element.find(".header button").on("click",function(e){e.preventDefault(),e.stopPropagation(),function(){console.log("Closing chat panel"),element.find(".chat").removeClass("enter").hide(),element.find("i.fa-comments, img.custom-logo").show(),element.removeClass("expand"),isIframeMode||(element.find("#sendMessage").off("click",sendNewMessage),element.find(".text-box").off("keydown",onMetaAndEnter).prop("disabled",!0).blur(),poller.stop());setTimeout(function(){element.find(".chat").show()},500)}()});var myStorage=localStorage;myStorage.getItem("chatID")||myStorage.setItem("chatID",function(){for(var s=[],hexDigits="0123456789abcdef",i=0;i<36;i++)s[i]=hexDigits.substr(Math.floor(16*Math.random()),1);return s[14]="4",s[19]=hexDigits.substr(3&s[19]|8,1),s[8]=s[13]=s[18]=s[23]="-",s.join("")}()),setTimeout(function(){console.log("Adding enter class to floating chat element"),element.addClass("enter"),element.on("click",function(e){element.hasClass("expand")&&!$(e.target).is(".floating-chat, .custom-logo, i.fa-comments")||element.hasClass("expand")||function(){if(console.log("Opening chat panel"),element.find("i.fa-comments, img.custom-logo").hide(),element.addClass("expand"),element.find(".chat").addClass("enter"),!isIframeMode){var messages=element.find(".messages"),textInput=element.find(".text-box");hideMainLoader(),setTimeout(function(){console.log("Showing main loader"),element.find(".loader-container").addClass("active"),element.find("#sendMessage").prop("disabled",!0).css("background-color","#9dbacd")},50),textInput.prop("disabled",!1).focus(),element.find("#sendMessage").click(sendNewMessage),textInput.keydown(onMetaAndEnter),textInput.on("focus",updateSendButtonState),textInput.on("blur",updateSendButtonState),textInput.on("input",updateSendButtonState),updateSendButtonState(),messages.scrollTop(messages.prop("scrollHeight")),poller.start()}}()})},1e3),element.find(".file-upload").on("change",function(e){console.log("File upload triggered",e.target.files);var file=e.target.files[0];if(!file)return void console.log("No file selected");if(!file.type.match("image.*"))return console.error("Invalid file type:",file.type),void Notification.alert(strings.error,strings.selectImageError);if(file.size>5242880)return console.error("File too large:",file.size),void Notification.alert(strings.error,strings.imageSizeError);console.log("Valid image selected:",file.name,file.type,file.size);var safeCopy=createSafeFileCopy(file);safeCopy?(selectedImage=safeCopy,console.log("Image stored in selectedImage variable:",selectedImage)):(console.error("Failed to create safe copy, using original file"),selectedImage=file,console.log("Using original file object:",selectedImage));var reader=new FileReader;reader.onload=function(e){try{console.log("Image preview loaded");var preview=element.find(".image-preview");preview.find("img").attr("src",e.target.result),preview.css("display","block"),updateSendButtonState()}catch(err){console.error("Error showing image preview:",err)}},reader.onerror=function(err){console.error("Error reading image file for preview:",err)};try{reader.readAsDataURL(file)}catch(err){console.error("Error calling readAsDataURL for preview:",err)}}),element.find(".remove-image").on("click",removeSelectedImage),element.find(".upload-btn").on("click",function(e){e.preventDefault(),e.stopPropagation(),console.log("Upload button clicked"),element.find(".file-upload").click()})}else console.error("No floating-chat element found in the DOM");function updateSendButtonState(){var textBox=element.find(".text-box"),sendButton=element.find("#sendMessage"),cleanContent=textBox.html().replace(/<div><br><\/div>|<div><\/div>|<br>|&nbsp;/gi,"").trim(),hasText=cleanContent.length>0,hasFocus=textBox.is(":focus"),hasImage=null!==selectedImage;console.log("Updating send button state - hasText:",hasText,"hasFocus:",hasFocus,"hasImage:",hasImage,"cleanContent:",cleanContent),hasText||hasFocus||hasImage?sendButton.prop("disabled",!1).css("background-color","#308bba"):sendButton.prop("disabled",!0).css("background-color","#9dbacd")}function removeSelectedImage(){console.log("Removing selected image"),selectedImage=null,console.log("selectedImage after removal:",selectedImage),element.find(".image-preview").css("display","none"),element.find(".file-upload").val(""),updateSendButtonState()}function getMediaHtml(mediaUrl){return[".mp4",".webm",".mov",".ogg"].some(function(ext){return mediaUrl.toLowerCase().endsWith(ext)})?'<div class="media-container"><video src="'+mediaUrl+'" controls class="chat-media"></video></div>':'<div class="media-container"><img src="'+mediaUrl+'" alt="Media" class="chat-media" onerror="this.style.display=\'none\'"></div>'}function hideMainLoader(){console.log("Hiding main loader"),element.find(".loader-container").removeClass("active"),updateSendButtonState()}function showMessageLoader(){console.log("Showing message loader"),element.find(".message-loader").addClass("active"),element.find("#sendMessage").prop("disabled",!0).css("background-color","#9dbacd")}function hideMessageLoader(){console.log("Hiding message loader"),element.find(".message-loader").removeClass("active")}function sendNewMessage(){var userInput=element.find(".text-box"),newMessage=userInput.html().replace(/\<div\>|\<br.*?\>/gi,"\n").replace(/\<\/div\>/g,"").trim().replace(/\n/g,"<br>"),sendButton=element.find("#sendMessage");if(console.log("sendNewMessage called, selectedImage:",selectedImage),sendButton.prop("disabled"))console.log("Send button is disabled, not sending message");else if(newMessage||selectedImage){var messagesContainer=element.find(".messages"),messageContent=newMessage,currentImage=selectedImage?createSafeFileCopy(selectedImage):null;if(currentImage&&currentImage instanceof Blob){console.log("Sending message with image:",currentImage.name||strings.unnamedImage);var reader=new FileReader;reader.onload=function(e){try{messageContent+='<div class="media-container"><img src="'+e.target.result+'" alt="'+strings.uploadedImageAlt+'" class="chat-media"></div>',messagesContainer.append(['<li class="self">',messageContent,"</li>"].join("")),messagesContainer.finish().animate({scrollTop:messagesContainer.prop("scrollHeight")},250),function(message,image){if(console.log("sendMessageWithImage called with:",message,image),!image)return console.error("No image provided to sendMessageWithImage"),void hideMessageLoader();if(!(image instanceof Blob))return console.error("Invalid image object provided to sendMessageWithImage, type:",typeof image),void hideMessageLoader();console.log("Image validation passed:",image.name,image.type,image.size),hideMessageLoader(),setTimeout(function(){showMessageLoader()},50);var reader=new FileReader;reader.onload=function(e){try{console.log("Image loaded successfully for API call");var base64data=e.target.result.split(",")[1];console.log("Base64 data prepared, length:",base64data.length),Ajax.call([{methodname:"local_eflow_aitutor_send_message",args:{courseid:params.courseId,message:message,filecontents:base64data,filename:image.name||strings.unnamedImage,filetype:image.type,userid:params.userId||0,activity_id:0==id?0:id}}])[0].then(function(response){console.log("API response received:",response);try{if(response.status){var messagesContainer=element.find(".messages"),messageContent=response.message;if(response.data)try{var jsonData=JSON.parse(response.data);if(console.log("Parsed response data:",jsonData),jsonData&&jsonData.media&&null!==jsonData.media&&""!==jsonData.media){var mediaUrl=jsonData.media;console.log("Media URL from response:",mediaUrl),mediaUrl.startsWith("http")||(mediaUrl="https://eflow-static01.s3-us-west-2.amazonaws.com/media/"+mediaUrl,console.log("Updated media URL:",mediaUrl)),messageContent+=getMediaHtml(mediaUrl)}else console.log("No media in response or media is empty")}catch(jsonError){console.error("Error parsing response data JSON:",jsonError)}else console.log("No response.data available");messageContent&&""!==messageContent.trim()&&(hideMessageLoader(),messagesContainer.append(['<li class="other">',messageContent,"</li>"].join("")),messagesContainer.finish().animate({scrollTop:messagesContainer.prop("scrollHeight")},250))}else console.error("API response received but invalid format:",response),element.find(".message-loader").removeClass("active")}catch(e){console.error("Error processing API response:",e),element.find(".message-loader").removeClass("active")}}).catch(function(error){console.error("Image upload failed:",error),element.find(".message-loader").removeClass("active")}),setTimeout(function(){console.log("Checking for new messages 5 seconds after sending a message with image"),poller.poll()},5e3)}catch(e){console.error("Error in FileReader onload handler:",e),element.find(".message-loader").removeClass("active")}},reader.onerror=function(e){console.error("Error reading image file:",e),element.find(".message-loader").removeClass("active")};try{console.log("Starting to read image as data URL"),reader.readAsDataURL(image),console.log("readAsDataURL called successfully")}catch(e){console.error("Error calling readAsDataURL:",e),element.find(".message-loader").removeClass("active")}}(newMessage,currentImage)}catch(err){console.error("Error processing image in sendNewMessage:",err),messagesContainer.append(['<li class="self">',newMessage,"</li>"].join("")),sendTextMessage(newMessage)}},reader.onerror=function(err){console.error("Error reading image in sendNewMessage:",err),messagesContainer.append(['<li class="self">',newMessage,"</li>"].join("")),sendTextMessage(newMessage)};try{reader.readAsDataURL(currentImage)}catch(err){console.error("Error calling readAsDataURL in sendNewMessage:",err),messagesContainer.append(['<li class="self">',newMessage,"</li>"].join("")),sendTextMessage(newMessage)}removeSelectedImage()}else console.log("No valid image, sending text-only message"),messagesContainer.append(['<li class="self">',messageContent,"</li>"].join("")),sendTextMessage(newMessage);userInput.html(""),userInput.focus(),sendButton.prop("disabled",!0).css("background-color","#9dbacd"),messagesContainer.finish().animate({scrollTop:messagesContainer.prop("scrollHeight")},250)}else console.log("No message or image to send")}function sendTextMessage(message){hideMessageLoader(),setTimeout(function(){showMessageLoader()},50),Ajax.call([{methodname:"local_eflow_aitutor_send_message",args:{courseid:params.courseId,message:message,userid:params.userId||0,activity_id:0==id?0:id}}])[0].then(function(response){try{if(response.status){var messagesContainer=element.find(".messages"),messageContent=response.message;if(response.data)try{var jsonData=JSON.parse(response.data);if(console.log("Parsed response data:",jsonData),jsonData&&jsonData.media&&null!==jsonData.media&&""!==jsonData.media){var mediaUrl=jsonData.media;console.log("Media URL from response:",mediaUrl),mediaUrl.startsWith("http")||(mediaUrl="https://eflow-static01.s3-us-west-2.amazonaws.com/media/"+mediaUrl,console.log("Updated media URL:",mediaUrl)),messageContent+=getMediaHtml(mediaUrl)}else console.log("No media in response or media is empty")}catch(jsonError){console.error("Error parsing response data JSON:",jsonError)}else console.log("No response.data available");messageContent&&""!==messageContent.trim()&&(hideMessageLoader(),messagesContainer.append(['<li class="other">',messageContent,"</li>"].join("")),messagesContainer.finish().animate({scrollTop:messagesContainer.prop("scrollHeight")},250))}else console.error("API response received but invalid format:",response)}catch(e){console.error("Error processing API response:",e)}}).catch(function(error){console.error("API call failed:",error),element.find(".message-loader").removeClass("active")}),setTimeout(function(){console.log("Checking for new messages 5 seconds after sending a message"),poller.poll()},5e3)}function onMetaAndEnter(event){(event.metaKey||event.ctrlKey)&&13==event.keyCode&&(element.find("#sendMessage").prop("disabled")?console.log("Send button is disabled, not sending message on Ctrl/Meta+Enter"):sendNewMessage())}function createSafeFileCopy(originalFile){if(!(originalFile&&originalFile instanceof Blob))return console.error("Invalid file provided to createSafeFileCopy"),null;try{return window.File&&originalFile instanceof File?new File([originalFile],originalFile.name,{type:originalFile.type,lastModified:originalFile.lastModified}):new Blob([originalFile],{type:originalFile.type})}catch(err){return console.error("Error creating safe file copy:",err),originalFile}}})}else console.error("jQuery is not available")}}});
//# sourceMappingURL=chat.min.js.map