<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Course settings page for the eFlow AI Tutor plugin.
 *
 * @package    local_eflow_aitutor
 * @copyright  2025 Nawaz sharif<shasharif02@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../../config.php');
require_once($CFG->dirroot . '/local/eflow_aitutor/lib.php');
require_once($CFG->dirroot . '/local/eflow_aitutor/course_settings_form.php');

$id = required_param('id', PARAM_INT); // Course ID.

// Ensure the course exists.
$course = $DB->get_record('course', array('id' => $id), '*', MUST_EXIST);
$context = context_course::instance($course->id);

// Check capabilities.
require_login($course);
require_capability('local/eflow_aitutor:manage', $context);

// Set up page.
$PAGE->set_url(new moodle_url('/local/eflow_aitutor/course_settings.php', array('id' => $id)));
$PAGE->set_pagelayout('admin');
$PAGE->set_title(get_string('eflow_aitutorsettings', 'local_eflow_aitutor'));
$PAGE->set_heading(format_string($course->fullname));
$PAGE->navbar->add(get_string('eflow_aitutorsettings', 'local_eflow_aitutor'));

// Get existing settings.
$settings = local_eflow_aitutor_get_course_settings($course);

// Create form.
$form = new local_eflow_aitutor_course_settings_form(null, array('settings' => $settings));

// Form processing and displaying.
if ($form->is_cancelled()) {
    // Cancel button was pressed.
    redirect(new moodle_url('/course/view.php', array('id' => $id)));
} else if ($data = $form->get_data()) {
    // Form was submitted.
    $data->courseid = $id; // Add courseid for the settings save function
    local_eflow_aitutor_save_course_settings($data);
    redirect(new moodle_url('/course/view.php', array('id' => $id)),
        get_string('settingssaved', 'local_eflow_aitutor'), null, \core\output\notification::NOTIFY_SUCCESS);
} else {
    // Display the form.
    echo $OUTPUT->header();
    echo $OUTPUT->heading(get_string('eflow_aitutorsettings', 'local_eflow_aitutor'));
    $form->display();
    echo $OUTPUT->footer();
}
