<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Course settings form for the eFlow AI Tutor plugin.
 *
 * @package    local_eflow_aitutor
 * @copyright  2025 Nawaz sharif<shasharif02@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/formslib.php');

/**
 * Form for course settings.
 */
class local_eflow_aitutor_course_settings_form extends moodleform {

    /**
     * Form definition.
     */
    public function definition() {
        global $CFG;

        $mform = $this->_form;
        $settings = $this->_customdata['settings'];

        // Add a header.
        $mform->addElement('header', 'general', get_string('coursesettings', 'local_eflow_aitutor'));

        // Get global enabled status.
        $globalenabled = get_config('local_eflow_aitutor', 'enabled');
        if (empty($globalenabled)) {
            $mform->addElement('static', 'globaldisabled', '',
                get_string('globaldisabled', 'local_eflow_aitutor'));
        }

        // Enable/Disable the eFlow AI Tutor for this course.
        $mform->addElement('advcheckbox', 'enabled', get_string('enableforcourse', 'local_eflow_aitutor'),
            get_string('enableforcourse_desc', 'local_eflow_aitutor'));
        $mform->setDefault('enabled', $settings->enabled);
        $mform->addHelpButton('enabled', 'enableforcourse', 'local_eflow_aitutor');

        // Add course ID as hidden field.
        $mform->addElement('hidden', 'id');
        $mform->setType('id', PARAM_INT);
        $mform->setDefault('id', $settings->courseid);

        // Add submit and cancel buttons.
        $this->add_action_buttons();
    }
}
