<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * External functions and service definitions for the eflow_aitutor plugin.
 *
 * @package    local_eflow_aitutor
 * @copyright  2025 Nawaz sharif<shasharif02@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = [
    'local_eflow_aitutor_send_message' => [
        'classname'     => 'local_eflow_aitutor\external\send_message',
        'methodname'    => 'execute',
        'description'   => 'Sends a message from the AI tutor chat to the external API',
        'type'          => 'write',
        'capabilities'  => 'local/eflow_aitutor:view',
        'ajax'          => true,
    ],
    'local_eflow_aitutor_check_responses' => [
        'classname'     => 'local_eflow_aitutor\external\check_responses',
        'methodname'    => 'execute',
        'description'   => 'Polls the external API for new responses',
        'type'          => 'read',
        'capabilities'  => 'local/eflow_aitutor:view',
        'ajax'          => true,
    ],
];

$services = [
    'AI Tutor Service' => [
        'functions' => [
            'local_eflow_aitutor_send_message',
            'local_eflow_aitutor_check_responses',
            'core_enrol_get_users_courses'
        ],
        'restrictedusers' => 0,
        'enabled' => 1,
    ],
];
