<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings for the eflow_aitutor plugin.
 *
 * @package    local_eflow_aitutor
 * @copyright  2025 Nawaz sharif<shasharif02@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General plugin strings.
$string['pluginname'] = 'eFlow AI Tutor';
$string['privacy:metadata'] = 'The eFlow AI Tutor plugin sends user data to an external eFlow API service.';
$string['privacy:metadata:eflow_api'] = 'The eFlow AI Tutor plugin sends data to the eFlow API external service to provide AI tutoring functionality.';
$string['privacy:metadata:eflow_api:userid'] = 'The user ID is sent to the eFlow API to identify the user in the external system.';
$string['privacy:metadata:eflow_api:courseid'] = 'The course ID is sent to the eFlow API to provide context-specific tutoring.';
$string['privacy:metadata:eflow_api:message'] = 'Any messages sent by the user in the chat are transmitted to the eFlow API.';
$string['privacy:metadata:eflow_api:activity_id'] = 'The activity ID may be sent to the eFlow API when interacting with specific course activities.';
$string['privacy:metadata:eflow_api:timestamp'] = 'The timestamp of when messages are sent is transmitted to the eFlow API.';
$string['privacy:metadata:eflow_api:fullname'] = 'The user\'s full name may be sent to the eFlow API to personalize the tutoring experience.';

// Capability strings.
$string['eflow_aitutor:view'] = 'View the eFlow AI Tutor';
$string['eflow_aitutor:manage'] = 'Manage eFlow AI Tutor settings';

// Course settings strings.
$string['eflow_aitutorsettings'] = 'eFlow AI Tutor Settings';
$string['coursesettings'] = 'Course Settings';
$string['globaldisabled'] = 'Note: eFlow AI Tutor is currently disabled globally. Enabling it here will have no effect until it is enabled in the site administration.';
$string['enableforcourse'] = 'Enable eFlow AI Tutor';
$string['enableforcourse_desc'] = 'Enable or disable the eFlow AI Tutor for this course.';
$string['enableforcourse_help'] = 'When enabled, the eFlow AI Tutor will be available to users with the appropriate permissions in this course.';
$string['settingssaved'] = 'eFlow AI Tutor settings saved';
$string['status'] = 'eFlow AI Tutor Status';
$string['enabled'] = 'Enabled';
$string['disabled'] = 'Disabled';

// Settings strings.
$string['enabled'] = 'Enable eFlow AI Tutor';
$string['enabled_desc'] = 'Enable or disable the eFlow AI Tutor plugin.';
$string['apikey'] = 'API Key';
$string['apikey_desc'] = 'API key for the AI service.';
$string['apiurl'] = 'API Base URL';
$string['apiurl_desc'] = 'Base URL for the eFlow API (e.g., https://api7.eflow.app/api/v2).';
$string['apiurlnotset'] = 'API URL is not configured. Please set it in the plugin settings.';
$string['chattitle'] = 'Chat Title';
$string['chattitle_desc'] = 'The title displayed in the chat header.';
$string['defaultchattitle'] = 'eFlow AI Tutor';
$string['buttoncolor'] = 'Button Color';
$string['buttoncolor_desc'] = 'The color of the floating chat button.';
$string['buttonposition'] = 'Button Position';
$string['buttonposition_desc'] = 'The position of the floating chat button on the screen.';
$string['bottomright'] = 'Bottom Right';
$string['bottomleft'] = 'Bottom Left';
$string['topright'] = 'Top Right';
$string['topleft'] = 'Top Left';
$string['buttonsize'] = 'Button Size';
$string['buttonsize_desc'] = 'The size of the floating chat button in pixels.';
$string['chatwidth'] = 'Chat Width';
$string['chatwidth_desc'] = 'The width of the chat window in pixels.';
$string['chatheight'] = 'Chat Height';
$string['chatheight_desc'] = 'The height of the chat window in pixels.';
$string['logo'] = 'Custom Logo';
$string['logo_desc'] = 'Upload a custom logo for the chat button. If not provided, a default icon will be used.';

// AI Avatar setting
$string['ai_avatar'] = 'AI Profile Picture';
$string['ai_avatar_desc'] = 'Upload a custom profile picture for the AI in chat messages. If not provided, a default avatar will be used.';

// New color customization settings
$string['headerbgcolor'] = 'Header Background Color';
$string['headerbgcolor_desc'] = 'The background color of the chat header.';
$string['bodybgcolor'] = 'Chat Background Color';
$string['bodybgcolor_desc'] = 'The background color of the chat body.';
$string['headerfontcolor'] = 'Header Font Color';
$string['headerfontcolor_desc'] = 'The color of the text in the chat header.';
$string['bodyfontcolor'] = 'Chat Font Color';
$string['bodyfontcolor_desc'] = 'The color of the text in the chat messages.';

// API integration settings
$string['apiheading'] = 'eFlow API Integration';
$string['apiheading_desc'] = 'Settings for integrating with the eFlow API.';
$string['api_username'] = 'API Username';
$string['api_username_desc'] = 'Username for authenticating with the eFlow API.';
$string['api_password'] = 'API Password';
$string['api_password_desc'] = 'Password for authenticating with the eFlow API.';
$string['group_id'] = 'Group ID';
$string['group_id_desc'] = 'The ID of the group to send messages to in eFlow.';
$string['course_id'] = 'Course ID';
$string['course_id_desc'] = 'The ID of the course in eFlow API (default is 298).';

// Iframe settings
$string['iframe_enabled'] = 'Enable Iframe Mode';
$string['iframe_enabled_desc'] = 'When enabled, the chat will load content from an external iframe URL instead of using the built-in chat interface.';
$string['iframe_url'] = 'Iframe URL';
$string['iframe_url_desc'] = 'The URL to load in the iframe when iframe mode is enabled. You can include placeholders like "moodle_user_id", "moodle_course_id", and "moodle_activity_id" which will be replaced with the actual values.';

// Float option settings
$string['float_option_heading'] = 'Float Option Settings';
$string['float_option_heading_desc'] = 'Configure settings related to the float option API parameter.';
$string['default_float_option'] = 'Default Float Option';
$string['default_float_option_desc'] = 'Select the default option for the eFlow AI Tutor.';
$string['with_option'] = 'With Option';
$string['without_option'] = 'Without Option';
$string['float_custom_width'] = 'Custom Width';
$string['float_custom_width_desc'] = 'Width of the eFlow AI Tutor in pixels when using custom dimensions.';
$string['float_custom_height'] = 'Custom Height';
$string['float_custom_height_desc'] = 'Height of the eFlow AI Tutor in pixels when using custom dimensions.';
$string['float_option_disabled'] = 'Disabled';

// API error messages
$string['apicredentialsnotset'] = 'API credentials are not configured. Please set the username and password in the plugin settings.';
$string['apiauthfailed'] = 'Authentication with the API failed. Please check your credentials.';

// Image upload error messages
$string['invalidfiletype'] = 'Invalid file type. Only JPEG, PNG, and GIF images are allowed.';
$string['invalidfilecontents'] = 'Invalid file contents. The file could not be decoded.';
$string['cannotwritefile'] = 'Could not write file to temporary directory.';
$string['apiurlnotset'] = 'API URL is not configured.';
$string['apicredentialsnotset'] = 'API credentials are not configured.';
$string['apiauthfailed'] = 'Failed to authenticate with the API.';

// Chat interface strings
$string['chat_welcome_message'] = 'Hello! I\'m your AI tutor assistant. How can I help you with this course?';
$string['chat_close'] = 'Close';
$string['chat_send'] = 'Send';
$string['chat_upload_image'] = 'Upload image';
$string['chat_select_image'] = 'Select an image to upload';
$string['chat_uploaded_image_alt'] = 'Uploaded Image';
$string['chat_ai_tutor_alt'] = 'AI Tutor';
$string['chat_loading'] = 'Loading...';
$string['chat_sending'] = 'Sending...';
$string['chat_failed_to_connect'] = 'Failed to connect to AI service';
$string['chat_error_code'] = 'AI service returned error code';
$string['chat_unnamed_image'] = 'unnamed-image';
$string['chat_sending_message_with_image'] = 'Sending message with image';
$string['chat_error'] = 'Error';
$string['chat_select_image_error'] = 'Please select an image file';
$string['chat_image_size_error'] = 'Image size must be less than 5MB';
$string['chat_media_alt'] = 'Media';
$string['chat_failed_to_connect_with_error'] = 'Failed to connect to AI service: {$a}';
$string['chat_error_code_with_number'] = 'AI service returned error code: {$a}';
$string['chat_responses_success'] = 'Successfully checked for new responses';
