<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Settings for the eflow_aitutor plugin.
 *
 * @package    local_eflow_aitutor
 * @copyright  2025 Nawaz sharif<shasharif02@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

if ($hassiteconfig) {
    $settings = new admin_settingpage('local_eflow_aitutor', get_string('pluginname', 'local_eflow_aitutor'));

    // Enable/Disable the AI Tutor
    $settings->add(new admin_setting_configcheckbox(
        'local_eflow_aitutor/enabled',
        get_string('enabled', 'local_eflow_aitutor'),
        get_string('enabled_desc', 'local_eflow_aitutor'),
        1
    ));

    // API URL for webhook
    $settings->add(new admin_setting_configtext(
        'local_eflow_aitutor/apiurl',
        get_string('apiurl', 'local_eflow_aitutor'),
        get_string('apiurl_desc', 'local_eflow_aitutor'),
        'https://api7.eflow.app/api/v2',
        PARAM_URL
    ));

    // Chat title
    $settings->add(new admin_setting_configtext(
        'local_eflow_aitutor/chattitle',
        get_string('chattitle', 'local_eflow_aitutor'),
        get_string('chattitle_desc', 'local_eflow_aitutor'),
        get_string('defaultchattitle', 'local_eflow_aitutor'),
        PARAM_TEXT
    ));

    // Button color
    $settings->add(new admin_setting_configcolourpicker(
        'local_eflow_aitutor/buttoncolor',
        get_string('buttoncolor', 'local_eflow_aitutor'),
        get_string('buttoncolor_desc', 'local_eflow_aitutor'),
        '#199393' // Default color matches the sample CSS
    ));

    // Button position
    $positionoptions = array(
        'bottom-right' => get_string('bottomright', 'local_eflow_aitutor'),
        'bottom-left' => get_string('bottomleft', 'local_eflow_aitutor'),
        'top-right' => get_string('topright', 'local_eflow_aitutor'),
        'top-left' => get_string('topleft', 'local_eflow_aitutor')
    );
    $settings->add(new admin_setting_configselect(
        'local_eflow_aitutor/buttonposition',
        get_string('buttonposition', 'local_eflow_aitutor'),
        get_string('buttonposition_desc', 'local_eflow_aitutor'),
        'bottom-right',
        $positionoptions
    ));

    // Button size
    $settings->add(new admin_setting_configtext(
        'local_eflow_aitutor/buttonsize',
        get_string('buttonsize', 'local_eflow_aitutor'),
        get_string('buttonsize_desc', 'local_eflow_aitutor'),
        '40',
        PARAM_INT
    ));

    // Chat window width
    $settings->add(new admin_setting_configtext(
        'local_eflow_aitutor/chatwidth',
        get_string('chatwidth', 'local_eflow_aitutor'),
        get_string('chatwidth_desc', 'local_eflow_aitutor'),
        '250',
        PARAM_INT
    ));

    // Chat window height
    $settings->add(new admin_setting_configtext(
        'local_eflow_aitutor/chatheight',
        get_string('chatheight', 'local_eflow_aitutor'),
        get_string('chatheight_desc', 'local_eflow_aitutor'),
        '400',
        PARAM_INT
    ));

    // Custom logo URL
    $settings->add(new admin_setting_configstoredfile(
        'local_eflow_aitutor/logo',
        get_string('logo', 'local_eflow_aitutor'),
        get_string('logo_desc', 'local_eflow_aitutor'),
        'logo',
        0,
        array('maxfiles' => 1, 'accepted_types' => array('.png', '.jpg', '.gif', '.svg'))
    ));

    // AI Profile Picture
    $settings->add(new admin_setting_configstoredfile(
        'local_eflow_aitutor/ai_avatar',
        get_string('ai_avatar', 'local_eflow_aitutor'),
        get_string('ai_avatar_desc', 'local_eflow_aitutor'),
        'ai_avatar',
        0,
        array('maxfiles' => 1, 'accepted_types' => array('.png', '.jpg', '.gif', '.svg'))
    ));

    // Header background color
    $settings->add(new admin_setting_configcolourpicker(
        'local_eflow_aitutor/headerbgcolor',
        get_string('headerbgcolor', 'local_eflow_aitutor'),
        get_string('headerbgcolor_desc', 'local_eflow_aitutor'),
        '#183850' // Default color from the gradient
    ));

    // Body background color
    $settings->add(new admin_setting_configcolourpicker(
        'local_eflow_aitutor/bodybgcolor',
        get_string('bodybgcolor', 'local_eflow_aitutor'),
        get_string('bodybgcolor_desc', 'local_eflow_aitutor'),
        '#cde6fa' // Default color from the gradient
    ));

    // Header font color
    $settings->add(new admin_setting_configcolourpicker(
        'local_eflow_aitutor/headerfontcolor',
        get_string('headerfontcolor', 'local_eflow_aitutor'),
        get_string('headerfontcolor_desc', 'local_eflow_aitutor'),
        '#FFFFFF' // Default white
    ));

    // Body font color
    $settings->add(new admin_setting_configcolourpicker(
        'local_eflow_aitutor/bodyfontcolor',
        get_string('bodyfontcolor', 'local_eflow_aitutor'),
        get_string('bodyfontcolor_desc', 'local_eflow_aitutor'),
        '#0EC879' // Default message color
    ));

    // Iframe settings
    $settings->add(new admin_setting_heading(
        'local_eflow_aitutor/iframeheading',
        get_string('iframe_enabled', 'local_eflow_aitutor'),
        ''
    ));

    // Enable/Disable iframe mode
    $settings->add(new admin_setting_configcheckbox(
        'local_eflow_aitutor/iframe_enabled',
        get_string('iframe_enabled', 'local_eflow_aitutor'),
        get_string('iframe_enabled_desc', 'local_eflow_aitutor'),
        0
    ));

    // Iframe URL
    $settings->add(new admin_setting_configtext(
        'local_eflow_aitutor/iframe_url',
        get_string('iframe_url', 'local_eflow_aitutor'),
        get_string('iframe_url_desc', 'local_eflow_aitutor') . ' ' .
        'You can use placeholders such as "moodle_user_id", "moodle_course_id", and "moodle_activity_id" in the URL, which will be automatically replaced with the actual Moodle values.',
        '',
        PARAM_URL
    ));

    // API settings header
    $settings->add(new admin_setting_heading(
        'local_eflow_aitutor/apiheading',
        get_string('apiheading', 'local_eflow_aitutor'),
        get_string('apiheading_desc', 'local_eflow_aitutor')
    ));

    // API Username for eflow.app
    $settings->add(new admin_setting_configtext(
        'local_eflow_aitutor/api_username',
        get_string('api_username', 'local_eflow_aitutor'),
        get_string('api_username_desc', 'local_eflow_aitutor'),
        '',
        PARAM_TEXT
    ));

    // API Password for eflow.app
    $settings->add(new admin_setting_configpasswordunmask(
        'local_eflow_aitutor/api_password',
        get_string('api_password', 'local_eflow_aitutor'),
        get_string('api_password_desc', 'local_eflow_aitutor'),
        ''
    ));

    // Group ID for messages
    $settings->add(new admin_setting_configtext(
        'local_eflow_aitutor/group_id',
        get_string('group_id', 'local_eflow_aitutor'),
        get_string('group_id_desc', 'local_eflow_aitutor'),
        '2',
        PARAM_INT
    ));

    // Course ID for API
    // $settings->add(new admin_setting_configtext(
    //     'local_eflow_aitutor/course_id',
    //     get_string('course_id', 'local_eflow_aitutor'),
    //     get_string('course_id_desc', 'local_eflow_aitutor'),
    //     '298',
    //     PARAM_INT
    // ));

    $ADMIN->add('localplugins', $settings);
}
