/**
 * Defines Kicstart javascript.
 * @module   format_kickstart/formatkickstart
 * @category  Classes - autoloading
 * @copyright 2021, bdecent gmbh bdecent.de
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("format_kickstart/formatkickstart",["jquery","core/str","core/notification","core/config","core/ajax","core/fragment","core/templates","core/modal_events","core/modal_factory","core/toast"],(function($,str,notification,Config,Ajax,Fragment,Templates,ModalEvents,ModalFactory,Toast){var Formatkickstart=function(contextid,courseid,menuid,filteroptions){var self=this,useTemplate=document.querySelectorAll(".templates-block .use-template");if(self.contextId=contextid,self.courseId=courseid,self.menuid=menuid,useTemplate&&useTemplate.forEach((element=>{element.addEventListener("click",self.templateHandler.bind(this))})),filteroptions){var templateview=document.querySelectorAll(".kickstart-page .listing-view-block a");templateview&&templateview.forEach((element=>{element.addEventListener("click",self.templateviewHandler.bind(this))}));var templatesearch=document.querySelectorAll(".kickstart-page #search-template");templatesearch&&templatesearch.forEach((element=>{element.addEventListener("change",self.templateSearchHandler.bind(this))}));var librarycourse=document.querySelectorAll(".librarycourse-filter-item .filter-item");librarycourse&&librarycourse.forEach((element=>{element.addEventListener("change",self.libraryCourseHandler.bind(this))}));var librarysort=document.querySelectorAll(".kickstart-courselibrary-sort.sort-options a");librarysort&&librarysort.forEach((element=>{element.addEventListener("click",(e=>{librarysort.forEach((link=>link.classList.remove("sort-active"))),element.classList.add("sort-active"),self.libraryCourseHandler.bind(this)(e)}))}))}var pagination=document.querySelectorAll(".kickstart-page .pagination li");pagination&&pagination.forEach((element=>{element.addEventListener("click",self.libraryCourseHandler.bind(this))}));var showcontentHandler=document.querySelectorAll(".import-course-list-section .show-content-button");showcontentHandler&&showcontentHandler.forEach((element=>{element.addEventListener("click",(()=>{str.get_strings([{key:"showcontents",component:"format_kickstart"},{key:"hidecontents",component:"format_kickstart"}]).then((function(strings){element.textContent.trim()===strings[0]?element.textContent=strings[1]:element.textContent.trim()===strings[1]&&(element.textContent=strings[0])}))}))}));var importActivity=document.querySelectorAll(".import-course-list-section .activity-items .import-activity");importActivity&&importActivity.forEach((element=>{element.addEventListener("click",self.importActivityHandler.bind(this))})),$("body").delegate(self.fullDescription,"click",self.fullmodcontentHandler.bind(this)),$("body").delegate(self.trimDescription,"click",self.trimmodcontentHandler.bind(this))};return Formatkickstart.prototype.confirmbutton=".buttons .singlebutton form button",Formatkickstart.prototype.loadiconElement="#modal-footer span#load-action",Formatkickstart.prototype.fullDescription=".list-library-courses .trim-summary .section-summary-action",Formatkickstart.prototype.trimDescription=".list-library-courses .fullcontent-summary .section-summary-action",Formatkickstart.prototype.contextId=null,Formatkickstart.prototype.courseId=null,Formatkickstart.prototype.menuid=null,Formatkickstart.prototype.importActivityHandler=function(event){event.preventDefault();let self=this;var args={courseid:event.currentTarget.getAttribute("data-course"),cmid:event.currentTarget.getAttribute("data-module"),maincourse:event.currentTarget.getAttribute("data-maincourse"),modname:event.currentTarget.getAttribute("data-modname")};ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:str.get_string("importactivity","format_kickstart"),body:Fragment.loadFragment("format_kickstart","get_import_module_box",self.contextId,args)}).then(function(modal){modal.setButtonText("save",str.get_string("importandview","format_kickstart")),modal.setButtonText("cancel",str.get_string("importandreturn","format_kickstart")),modal.getRoot().on(ModalEvents.save,function(){var sectionId=$("#import-module-section").val();args.sectionid=sectionId,args.action="view",self.importCourse(args),modal.destroy()}.bind(this)),modal.getRoot().on(ModalEvents.cancel,function(){var sectionId=$("#import-module-section").val();args.sectionid=sectionId,args.action="return",self.importCourse(args),modal.destroy()}.bind(this)),modal.show()}.bind(this))},Formatkickstart.prototype.importCourse=function(args){Fragment.loadFragment("format_kickstart","import_activity_courselib",this.contextId,args).then((viewurl=>{"view"==args.action?window.location.href=viewurl:str.get_string("importactivitysuccessfully","format_kickstart").then((function(string){Toast.add(string,{type:"success"})}))})).catch()},Formatkickstart.prototype.fullmodcontentHandler=function(event){var THIS=$(event.currentTarget);let fullContent=$(THIS).closest(".accordion-item").find(".fullcontent-summary"),trimcontent=$(THIS).closest(".accordion-item").find(".trim-summary");trimcontent.hasClass("summary-show")&&(trimcontent.removeClass("summary-show"),fullContent.addClass("summary-show"))},Formatkickstart.prototype.trimmodcontentHandler=function(event){var THIS=$(event.currentTarget);let fullContent=$(THIS).closest(".accordion-item").find(".fullcontent-summary"),trimcontent=$(THIS).closest(".accordion-item").find(".trim-summary");fullContent.hasClass("summary-show")&&(fullContent.removeClass("summary-show"),trimcontent.addClass("summary-show"))},Formatkickstart.prototype.libraryCourseHandler=function(event){event.preventDefault();let page=event.currentTarget.getAttribute("data-page-number");page=page?page-1:0;let sort=event.currentTarget.getAttribute("data-sort");if(!sort){var sorthandler=document.querySelector(".kickstart-courselibrary-sort .sort-link.sort-active");sorthandler&&(sort=sorthandler.getAttribute("data-sort"))}let searchcourse=document.querySelector("#search-course-library").value,customfieldsitems=document.querySelectorAll(".library-customfield-field.librarycourse-filter-item .filter-item"),customvalues={};customfieldsitems&&customfieldsitems.forEach((element=>{customvalues[element.getAttribute("data-value")]=element.value})),this.getlibarycourse(searchcourse,customvalues,sort,page)},Formatkickstart.prototype.getlibarycourse=function(searchcourse,customvalues,sort,page){let courselist=document.querySelector(".import-course-list-section");if(courselist){let self=this,args={contextid:self.contextId,courseid:self.courseId,menuid:self.menuid,searchcourse:searchcourse,customvalues:JSON.stringify(customvalues),sort:sort,page:page};Fragment.loadFragment("format_kickstart","get_library_courselist",self.contextId,args).then(((html,js)=>{Templates.replaceNode(courselist,html,js)})).catch()}},Formatkickstart.prototype.getKickstartTemplate=function(action,value){let templatelist=document.querySelector(".template-list"),searchBox=document.querySelector(".kickstart-page #search-template"),searchvalue=null!=searchBox?searchBox.value:"";if(templatelist){let self=this,args={contextid:self.contextId,courseid:self.courseId,menuid:self.menuid,action:action,value:value,search:searchvalue};Fragment.loadFragment("format_kickstart","get_kickstart_templatelist",self.contextId,args).then(((html,js)=>{Templates.replaceNode(templatelist,html,js)})).catch()}},Formatkickstart.prototype.templateSearchHandler=function(event){let value=event.currentTarget.value;this.getKickstartTemplate("searchtemplate",value)},Formatkickstart.prototype.templateviewHandler=function(event){let value=event.currentTarget.getAttribute("data-value");const tileView=document.getElementById("tile-view"),listView=document.getElementById("list-view");"tile"===value?(tileView.classList.add("active"),listView.classList.remove("active")):(listView.classList.add("active"),tileView.classList.remove("active")),this.getKickstartTemplate("changetemplate",value)},Formatkickstart.prototype.templateHandler=function(event){event.preventDefault();let templateName=event.target.getAttribute("data-templatename"),templateId=event.target.getAttribute("data-template");this.confirmImportTemplate(templateId,templateName)},Formatkickstart.prototype.confirmImportTemplate=function(templateId,templateName){let self=this;var plugindata={name:templateName};str.get_strings([{key:"confirm",component:"core"},{key:"confirmtemplate",param:plugindata,component:"format_kickstart"},{key:"import"},{key:"no"}]).done((function(s){notification.confirm(s[0],s[1],s[2],s[3],(function(){document.querySelectorAll("body")[0].classList.add("kickstart-icon"),Ajax.call([{methodname:"format_kickstart_import_template",args:{templateid:templateId,courseid:self.courseId},done:function(response){if(response){let redirect=Config.wwwroot+"/course/view.php?id="+self.courseId;window.location.assign(redirect)}}}])}))}))},{init:function(contextid,courseid,menuid,filteroptions){return new Formatkickstart(contextid,courseid,menuid,filteroptions)}}}));

//# sourceMappingURL=formatkickstart.min.js.map