<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component kickstart format.
 *
 * @package    format_kickstart
 * @copyright  2021 bdecent gmbh <https://bdecent.de>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['automatictemplate'] = 'Automatic template';
$string['automatictemplate_desc'] = 'If only one template is available to the user it will automatically be imported. The user will be notified on the page when this happens.';
$string['automatictemplate_help'] = 'The course template was automatically applied. If you require a different template, please contact the system administrator.';
$string['buypro'] = 'Buy Kickstart Pro';
$string['buypromaxtemplates'] = 'You are using the maximum number (<b>4</b>) of templates allowed in Kickstart free edition. To create more templates, purchase <a target="_blank" href="http://bdecent.de/kickstart">Kickstart Pro</a>.';
$string['buyprosummary'] = 'To unlock all Kickstart features purchase Kickstart Pro.';
$string['categorypath'] = "Category path";
$string['choosesectionimportactivity'] = "Choose the section to import the activity";
$string['confirmtemplate'] = 'Are you sure you want to use this Template "{$a->name}"?';
$string['course_backup'] = 'Course backup file (.mbz)';
$string['course_backup_help'] = 'When a user selects this template from within a course, this .mbz course backup will be imported into the course.';
$string['course_fullname'] = "Course full name";
$string['course_templates'] = 'Course templates';
$string['coursebackupnotset'] = 'Template has no course backup set.';
$string['coursecreatorinstructions'] = "Course creator instructions";
$string['coursecreatorinstructions_default'] = "<p> Please choose a name for your course. Then select a category. In the next step you will be able to enrol users to the course. In the last step, you can choose a template for your course.</p>";
$string['coursecreatorinstructions_desc'] = "Default content displayed to the course creator Show the 'create from template' page";
$string['coursecreatorredirect'] = 'Course creator redirect';
$string['coursecreatorredirect_desc'] = 'Force course creators to use Kickstart\'s "create from template" page when creating new courses. For example, when a course creator clicks "Add new course", they will be redirected to Kickstart.';
$string['courseformatoptions'] = "Course format";
$string['courseidnumber'] = "Course idnumber";
$string['courselibrary'] = "Course library";
$string['courselibraryfilterscf'] = "Course Library custom fields filters";
$string['courselibraryfilterscf_desc'] = "This is a multi-select field that allows you to specify up to three custom course fields to be displayed in the course library.";
$string['courselibraryperpage'] = "Course Library per page";
$string['courselibraryperpage_desc'] = "This is a numeric input field that allows you to specify how many courses should be displayed per page in the course library.";
$string['courselibsortsettings'] = "Course library sort weight settings";
$string['courselibsortsettings_help'] = " The admin shall be able to select how important the following criteria to determine the similarity on a scale from 0 (not taken into account) to 10 (very important):";
$string['coursestartdate'] = "Course start date";
$string['coursetags'] = "Course Tags";
$string['coursetemplate'] = "Course template";
$string['coursetemplatecreated'] = "Course template successfully created";
$string['coursetemplateexistsuser'] = "The current user already has a template for this course.";
$string['coursetemplatesearchbox'] = "Search for template name, tag or description";
$string['create_template'] = 'Create template';
$string['createcoursefromtemplate'] = 'Create course from template';
$string['createtemplaefromcourse'] = "Create template from course";
$string['default_templatebackground'] = "Default templates background images";
$string['default_templatebackground_desc'] = "";
$string['defaultteacherinstructions'] = 'Default teacher instructions';
$string['defaultteacherinstructions_default'] = '<p>Currently, there\'s nothing in here, so start adding your content. We\'ve made creating courses really easy for you. First, you choose a template that suits your course, then you can start adding content.</p>';
$string['defaultteacherinstructions_desc'] = 'Default content displayed to teachers before a template has been chosen.';
$string['defaulttemplatesview'] = 'Default templates view';
$string['defaulttemplatesview_desc'] = 'Default templates displayed to tiles or list view.';
$string['defaultuserinstructions'] = 'Default student instructions';
$string['defaultuserinstructions_default'] = '<p>Your teacher has not added any content into this course (yet).</p><p>If you have any questions, contact your teacher.</p>';
$string['defaultuserinstructions_desc'] = 'Default content displayed to students before a template has been chosen by the teacher.';
$string['delete'] = 'Delete';
$string['delete_template'] = 'Delete template';
$string['description'] = 'Description';
$string['disable'] = "Disable";
$string['displaycourselibraryfields'] = "Display course library fields";
$string['displaycourselibraryfields_desc'] = "With this setting, you can enable or disable the course library fields.";
$string['edit'] = 'Edit';
$string['edit_template'] = 'Edit template';
$string['editactivity'] = "Edit activity";
$string['enrollmenthelp'] = 'Before continuing you may enroll teachers (or any users). Click <b>Proceed to course content</b> to choose a template to import.';
$string['general_settings'] = 'General settings';
$string['generalsettings'] = "General settings";
$string['getpro'] = 'Get more templates with Kickstart Pro';
$string['goprotoenable'] = 'Go Pro to enable';
$string['gotocourse'] = 'Go to course';
$string['help'] = "Help";
$string['hidecontents'] = "Hide contents";
$string['importactivity'] = "Import activity";
$string['importactivitysuccessfully'] = 'Activity imported successfully';
$string['importandreturn'] = "Import and return";
$string['importandview'] = "Import and view";
$string['importcourse'] = 'Import course';
$string['importexplanation'] = 'Here is a list of courses you are enrolled in as a teacher. You can import contents from these courses. Use the search box to narrow down the list of courses.';
$string['importmoduleinformation'] = "Import activity into the sections";
$string['importtarget'] = 'Import target';
$string['importtarget_desc'] = 'Choose how Kickstart templates should be imported into courses.';
$string['includesubcategories'] = 'Include subcategories';
$string['includesubcategories_help'] = 'If checked, subcategories of chosen categories will also have access to this template.';
$string['kickstart:import_from_template'] = 'Import from templates';
$string['kickstart:manage_templates'] = 'Manage templates';
$string['kickstartnavigationmenu'] = 'Kickstart navigation menu';
$string['learnmore'] = 'Learn more';
$string['less'] = "Less";
$string['manage_templates'] = 'Manage templates';
$string['migratefromcourses'] = 'Migrate content from other courses';
$string['missingcategory'] = "Missing category";
$string['modtrimlength'] = "Module Trim Length on Course Library";
$string['modtrimlength_desc'] = 'This is a numeric input field that allows you to specify how much text should be displayed in the collapsed state. Enter the desired character count to control the length of the trimmed description.';
$string['moreresults'] = 'There are more results, enter a more specific search';
$string['nocoursesexists'] = 'No courses exist';
$string['notemplates'] = 'No templates are available.';
$string['plugin_description'] = 'Create courses faster and make them more consistent across your organization using course templates.';
$string['pluginname'] = 'Kickstart format';
$string['previewurl'] = 'Preview URL';
$string['previewurl_help'] = 'If provided a button will display on the template that will open this URL in a new tab';
$string['privacy:metadata'] = 'The Kickstart format plugin does not store any personal data.';
$string['restoretoexistingcourseadding'] = 'Merge Kickstart templates into courses';
$string['restoretoexistingcoursedeleting'] = 'Delete existing content when importing Kickstart templates';
$string['restrictcategory'] = 'Restrict by categories';
$string['restrictcohort'] = 'Restrict by cohorts';
$string['restrictrole'] = 'Restrict by roles';
$string['restrictuser'] = "Restrict by user";
$string['search_templates'] = "Search for template name, tag or description";
$string['searchcourselibrary'] = "Search for courses and activities by name, tag or desc";
$string['searchterm'] = 'Showing results for "{$a->term}"';
$string['sectionname'] = 'Kickstart';
$string['selectcategory'] = "Select Category";
$string['selectvalue'] = "All";
$string['shortname'] = "Short name:";
$string['showcontents'] = "Show contents";
$string['showing'] = 'Showing {$a->count} course(s)';
$string['sortby'] = "Sort by:";
$string['sortbyalpha'] = 'Alphabetically';
$string['sortbylastaccessed'] = 'Last accessed';
$string['sortbyrelevance'] = 'Relevance';
$string['staffonthiscourse'] = 'Staff on this course';
$string['strconfirmtemplate'] = 'Are you sure you want to use this Template';
$string['strkickstart'] = "Kickstart";
$string['strlist'] = "List";
$string['strtile'] = "Tile";
$string['studentview'] = "Student view";
$string['studentviewnotavailable'] = "Student view is not available for this course.";
$string['tagarea_kickstart_template'] = 'Kickstart templates';
$string['teacherinstructions'] = 'Teacher instructions';
$string['teacherinstructions_help'] = 'Content displayed to teachers before a template has been chosen.';
$string['teacherstudentview'] = "This page shows how students will view the current course when no template is applied.";
$string['template_created'] = 'Template successfully created';
$string['template_deleted'] = 'Template successfully deleted';
$string['template_edited'] = 'Template successfully edited';
$string['templateaccess'] = 'Template access';
$string['templatebackimg'] = "Template background images";
$string['templatebackimg_help'] = "Allow uploading images to a template.";
$string['templatesview'] = "Templates view";
$string['templatesview_help'] = "Templates displayed to tiles or list view";
$string['title'] = 'Title';
$string['usedefault'] = 'Use default restore setting';
$string['usedefault_help'] = 'These settings are applied when importing a template.';
$string['userinstructions'] = 'Student instructions';
$string['userinstructions_help'] = 'Content displayed to students before a template has been chosen by the teacher.';
$string['usetemplate'] = 'Use template';
$string['viewactivity'] = "View activity";
$string['waitingadhoctasktemplate'] = "The template is currently being processed under cron task. Please wait.";
$string['weight_customfield'] = 'Custom field {$a} weight';
$string['weight_customfield_desc'] = 'Weight for custom field {$a} (0-10). Higher values increase this field\'s importance in relevance sorting.';
$string['weight_customfields'] = 'Custom fields weight';
$string['weight_customfields_desc'] = 'Weight for custom fields relevance (0-10). Higher values give more importance to custom field matching.';
$string['weight_fullname'] = 'Course full name weight';
$string['weight_fullname_desc'] = 'Weight for course full name relevance (0-10). Higher values give more importance to full name matching.';
$string['weight_shortname'] = 'Course short name weight';
$string['weight_shortname_desc'] = 'Weight for course short name relevance (0-10). Higher values give more importance to short name matching.';
$string['weight_starred'] = 'Starred course weight';
$string['weight_starred_desc'] = 'Weight for starred courses (0-10). Higher values give more importance to starred courses.';
$string['weight_tags'] = 'Course tags weight';
$string['weight_tags_desc'] = 'Weight for course tags relevance (0-10). Higher values give more importance to tag matching.';
$string['welcometo'] = 'Welcome to';
$string['welcometoyourcourse'] = 'Welcome to your new course';
