/**
 * Notes ltool define js.
 * @module   ltool_note
 * @category  Classes - autoloading
 * @copyright 2021, bdecent gmbh bdecent.de
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("ltool_note/learningnote",["jquery","core/modal_factory","core/str","core/fragment","core/modal_events","core/ajax","core/notification","core/utils","core/config"],(function($,ModalFactory,String,Fragment,ModalEvents,Ajax,notification,Utils,Config){var printWindow=null;function learningToolNoteAction(contextid){const params=window.ltool_note_config||{};!function(contextid,params){var notesinfo=document.querySelector(".ltnoteinfo #ltnote-action");if(notesinfo){notesinfo.addEventListener("click",(function(){params.itemtype="",params.itemid=0,modalshowHandler(contextid,params)}));var notehovercolor=notesinfo.getAttribute("data-hovercolor"),notefontcolor=notesinfo.getAttribute("data-fontcolor");notehovercolor&&notefontcolor&&notesinfo.addEventListener("mouseover",(function(){document.querySelector("#ltnoteinfo p").style.background=notehovercolor,document.querySelector("#ltnoteinfo p").style.color=notefontcolor}))}}(contextid,params);var sorttypefilter=document.querySelector(".ltnote-sortfilter i#notessorttype");sorttypefilter&&sorttypefilter.addEventListener("click",(function(){!function(sorttype){var pageurl=window.location.href;pageurl=function(url,parameter){var urlparts=url.split("?");if(urlparts.length>=2){for(var prefix=encodeURIComponent(parameter)+"=",pars=urlparts[1].split(/[&;]/g),i=pars.length;i-- >0;)-1!==pars[i].lastIndexOf(prefix,0)&&pars.splice(i,1);return url=urlparts[0]+(pars.length>0?"?"+pars.join("&"):"")}return url}(pageurl,"sorttype"),"asc"==sorttype?sorttype="desc":"desc"==sorttype&&(sorttype="asc");var para="";para=pageurl.indexOf("?")>-1?"&":"?";pageurl=pageurl+para+"sorttype="+sorttype,window.open(pageurl,"_self")}(this.getAttribute("data-type"))})),$(document).on("click",".content-designer-learningtool-note",(function(e){var button=$(this),itemType=button.data("itemtype"),itemId=button.data("itemid"),pageurl=button.data("pageurl");params.itemtype=itemType,params.itemid=itemId,params.pageurl=pageurl,modalshowHandler(contextid,params,!0)}));var noteprintblock=document.querySelector(".note-print-block");noteprintblock&&noteprintblock.addEventListener("click",notePrintHandler.bind(contextid,params));const clearIcon=document.querySelector('.ltool-navigation [data-action="clearsearch"]');var searchinput=document.querySelector('.ltool-navigation [data-action="search"]');clearIcon&&clearIcon.addEventListener("click",(()=>{searchinput.value="",searchinput.focus(),clearSearch(clearIcon),performSearch("",contextid,params)})),searchinput&&searchinput.addEventListener("input",Utils.debounce((()=>{if(""===searchinput.value)clearSearch(clearIcon),performSearch("",contextid,params);else{activeSearch(clearIcon);var search=searchinput.value.trim();console.log(searchinput.value.trim()),performSearch(search,contextid,params)}}),1e3))}function performSearch(searchTerm,contextid,params){var notesContainer=document.querySelector(".ltool-notes-container, .note-list-container, .ltool-notes-grid");if(!notesContainer){var currentUrl=new URL(window.location.href);return currentUrl.searchParams.set("search",searchTerm),void(window.location.href=currentUrl.toString())}notesContainer.innerHTML='<div class="text-center p-4"><i class="fa fa-spinner fa-spin fa-2x"></i><p class="mt-2">Searching notes...</p></div>';var fragmentParams={courseid:params.course,search:searchTerm,sectionid:0,activity:0,filter:"",print:!1};Fragment.loadFragment("ltool_note","get_notes_list",contextid,fragmentParams).then((html=>{notesContainer.innerHTML=html;var currentUrl=new URL(window.location.href);currentUrl.searchParams.set("search",searchTerm),window.history.pushState({},"",currentUrl.toString())})).catch((error=>{console.error("Search error:",error),notesContainer.innerHTML='<div class="alert alert-danger">Error loading search results. Please try again.</div>'}))}const clearSearch=clearIcon=>{clearIcon.classList.add("d-none")},activeSearch=clearIcon=>{clearIcon.classList.remove("d-none")};function modalshowHandler(contextid,params){let contentDesigner=arguments.length>2&&void 0!==arguments[2]&&arguments[2];var newnote=String.get_string("newnote","local_learningtools");$.when(newnote).done((function(localizedEditString){var ltoolnotebody=document.getElementsByTagName("body")[0];ltoolnotebody.classList.contains("learningtool-note")||ltoolnotebody.classList.add("learningtool-note"),ModalFactory.create({title:localizedEditString+getPopoutAction(),type:ModalFactory.types.SAVE_CANCEL,body:getnoteaction(contextid,params),large:!0}).then((function(modal){return modal.show(),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.getRoot().on(ModalEvents.save,(function(e){e.preventDefault(),$(e.target).find("button[data-action=save]").attr("disabled",!0),modal.getRoot().find("form").submit()})),modal.getRoot().on("submit","form",(e=>{e.preventDefault(),submitFormData(modal,contextid,params,contentDesigner)})),document.querySelector("#popout-action").addEventListener("click",(function(){var pageurlobj=params.pageurl.split("&"),pageurljson=JSON.stringify(pageurlobj),url=M.cfg.wwwroot+"/local/learningtools/ltool/note/pop_out.php?contextid="+params.contextid+"&pagetype="+params.pagetype+"&contextlevel="+params.contextlevel+"&course="+params.course+"&user="+params.user+"&pageurl="+pageurljson+"&pagetitle="+params.pagetitle+"&heading="+params.heading+"&sesskey="+params.sesskey;params.itemtype&&(url+="&itemtype="+params.itemtype+"&itemid="+params.itemid),modal.hide(),window.open(url,"_blank")})),modal})).catch(notification.exception)}))}function getPopoutAction(){return"<div class='popout-block'><button type='submit' id='popout-action'name='popoutsubmit'>Pop out</button> <i class='fa fa-window-restore'></i></div>"}function submitFormData(modal,contextid,params){let contentDesigner=arguments.length>3&&void 0!==arguments[3]&&arguments[3];var modalform=document.querySelectorAll(".ltoolusernotes form")[0],formData=new URLSearchParams(new FormData(modalform)).toString(),notesuccess=String.get_string("successnotemessage","local_learningtools");Ajax.call([{methodname:"ltool_note_save_usernote",args:{contextid:contextid,formdata:formData},done:function(response){if(response)if(contentDesigner)require(["mod_contentdesigner/elements"],(function(Elements){params.itemid&&(Elements.removeWarning(),Elements.refreshContent())}));else{var noteinfo=document.querySelector(".ltnoteinfo span");noteinfo.classList.contains("ticked")||noteinfo.classList.add("ticked"),noteinfo.innerHTML=response}modal.hide(),$.when(notesuccess).done((function(localizedEditString){notification.addNotification({message:localizedEditString,type:"success"})})),0!=ltools.disappertimenotify&&setTimeout((function(){document.querySelector("span.notifications").innerHTML=""}),ltools.disappertimenotify)}}])}function getnoteaction(contextid,params){return params.contextid=contextid,""==params.pagetitle&&(params.pagetitle=document.querySelector("title").innerHTML),Fragment.loadFragment("ltool_note","get_note_form",contextid,params)}function notePrintHandler(args){if(printWindow&&!printWindow.closed)return printWindow.focus(),!0;var printUrl=Config.wwwroot+"/local/learningtools/ltool/note/print.php",params=new URLSearchParams;params.append("contextid",args.contextid),params.append("courseid",args.course||0),params.append("sesskey",args.sesskey);var currentUrl=new URL(window.location.href),search=currentUrl.searchParams.get("search")||"",filter=currentUrl.searchParams.get("filter")||"",sectionid=currentUrl.searchParams.get("sectionid")||0,activity=currentUrl.searchParams.get("activity")||0;search&&params.append("search",search),filter&&params.append("filter",filter),sectionid&&params.append("sectionid",sectionid),activity&&params.append("activity",activity);var fullUrl=printUrl+"?"+params.toString();return(printWindow=window.open(fullUrl,"printNotes","width=1000,height=700,scrollbars=yes,resizable=yes,toolbar=no,location=no,status=no"))&&printWindow.focus(),!0}return{init:contextid=>{learningToolNoteAction(contextid)}}}));

//# sourceMappingURL=learningnote.min.js.map