/**
 * Provides actions for the content designer editor, including update, edit, and move element functionalities.
 *
 * @module mod_contentdesigner/editor
 * @copyright  2024 bdecent gmbh <https://bdecent.de>
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_contentdesigner/editor",["jquery","core/modal_factory","core/modal_events","core/str","core/fragment","core/templates","core/notification","core/loadingicon","core/modal"],(function($,ModalFactory,ModalEvents,Str,Fragment,Templates,Notification,LoadingIcon,Modal){var contextID,cmID;let loaderItem=".contentdesigner-content";const initEventListeners=()=>{document.body.addEventListener("click",(e=>{var addElement=e.target.closest(".contentdesigner-addelement"),elementAction=e.target.closest(".element-item .element-actions .action-item"),moduleElement=e.target.closest("div.element-item");if(elementAction&&null!=elementAction&&moduleElement&&null!=moduleElement){var action=elementAction.getAttribute("data-action"),elementId=moduleElement.getAttribute("data-elementid"),element=moduleElement.getAttribute("data-elementshortname"),instanceId=moduleElement.getAttribute("data-instanceid");"delete"===action&&confirmDeleteElement(element,(function(){editElement(moduleElement,elementId,instanceId,action)})),"moveup"!=action&&"movedown"!=action||moveElement(moduleElement,action),"status"==action&&updateStatus(moduleElement)}if(addElement&&null!=addElement){e.preventDefault();var position=addElement.dataset.position,chapter=addElement.dataset.chapter;buildAddElementModal(position,chapter)}}))},moveElement=(moduleElement,action)=>{var promise;if("chapter"==moduleElement.dataset.elementshortname){var item=moduleElement.closest(".chapters-list");"moveup"==action?item.parentNode.insertBefore(item,item.previousElementSibling):item.parentNode.insertBefore(item,item.nextElementSibling.nextElementSibling);let contents=[];document.querySelectorAll("ul.course-content-list .chapters-content").forEach((item=>{contents.push(item.dataset.id)}));let params={chapters:contents.join(","),cmid:cmID};promise=Fragment.loadFragment("mod_contentdesigner","move_chapter",contextID,params).done(((html,js)=>{Templates.replaceNode(".contentdesigner-content",html,js)})).fail(Notification.exception),LoadingIcon.addIconToContainerRemoveOnCompletion(loaderItem,promise)}else{let chapter=moduleElement.closest(".chapters-content"),item=moduleElement.parentNode;if("moveup"==action)if(null===item.previousElementSibling){let previousChapter=item.closest(".chapters-list").previousElementSibling;var append=!1;null!==previousChapter&&(previousChapter.querySelector(".chapter-elements-list").append(item),append=!0),append&&null!=previousChapter.childNodes[1]&&updateChapterElements(previousChapter.childNodes[1])}else item.parentNode.insertBefore(item,item.previousElementSibling);else if(null===item.nextElementSibling){let nextChapter=item.closest(".chapters-list").nextElementSibling;var prepend=!1;null!==nextChapter&&(nextChapter.querySelector(".chapter-elements-list").prepend(item),prepend=!0),prepend&&null!=nextChapter.childNodes[1]&&updateChapterElements(nextChapter.childNodes[1])}else item.parentNode.insertBefore(item,item.nextElementSibling.nextElementSibling);promise=updateChapterElements(chapter),LoadingIcon.addIconToContainerRemoveOnCompletion(loaderItem,promise)}},updateChapterElements=chapter=>{let contents=[];chapter.querySelectorAll("li.element-item > div.element-item").forEach((item=>{contents.push(item.dataset.contentid)}));let params={contents:contents.join(","),chapterid:chapter.dataset.id,cmid:cmID};var promise=Fragment.loadFragment("mod_contentdesigner","move_element",contextID,params);return promise.done(((html,js)=>{Templates.replaceNode(".contentdesigner-content",html,js)})),promise};var updateStatus=moduleElement=>{let statusElement=moduleElement.querySelector('[data-action="status"] > i');var params={element:moduleElement.dataset.elementshortname,instance:moduleElement.dataset.instanceid,status:1!=moduleElement.dataset.visibility,cmid:cmID};1==moduleElement.dataset.visibility?(statusElement.classList.remove("fa-eye"),statusElement.classList.add("fa-eye-slash"),moduleElement.dataset.visibility=!1):(statusElement.classList.remove("fa-eye-slash"),statusElement.classList.add("fa-eye"),moduleElement.dataset.visibility=!0);var promise=Fragment.loadFragment("mod_contentdesigner","update_visibility",contextID,params).then((()=>!0));LoadingIcon.addIconToContainerRemoveOnCompletion(loaderItem,promise)},editElement=function(moduleElement,elementId,instanceId,action){var args={cmid:cmID,action:action,elementid:elementId,instanceid:instanceId};Fragment.loadFragment("mod_contentdesigner","edit_element",contextID,args).then((html=>{moduleElement.parentNode.replaceWith(html)})).fail(Notification.exception)},confirmDeleteElement=function(element,onconfirm){var elementTypename="cdelement_".element;Str.get_string("pluginname",elementTypename).done((function(){var plugindata={element:element};Str.get_strings([{key:"confirm",component:"core"},{key:"deletechecktype",component:"mod_contentdesigner",param:plugindata},{key:"yes"},{key:"no"}]).done((function(s){Notification.confirm(s[0],s[1],s[2],s[3],onconfirm)}))}))};const buildAddElementModal=function(){let position=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"bottom",chapter=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;var params={cmid:cmID};if(void 0!==Modal.registerModalType)var promise=Modal.create({type:ModalFactory.TYPE,title:Str.get_string("addelement","contentdesigner"),body:Fragment.loadFragment("mod_contentdesigner","get_elements_list",contextID,params),large:!1});else promise=ModalFactory.create({type:ModalFactory.TYPE,title:Str.get_string("addelement","contentdesigner"),body:Fragment.loadFragment("mod_contentdesigner","get_elements_list",contextID,params),large:!1});promise.then((modal=>(modal.getRoot().on(ModalEvents.bodyRendered,(function(){modal.getRoot().get(0).querySelectorAll(".element-item").forEach((e=>{e.addEventListener("click",(function(e){if(e.target.closest(".element-item")){var element=e.currentTarget.dataset.element,params={cmid:cmID,element:element,chapter:chapter,position:position,sesskey:M.cfg.sesskey};const urlParams=new URLSearchParams(params);window.location=M.cfg.wwwroot+"/mod/contentdesigner/element.php?"+urlParams.toString()}}))}))})),modal.show(),modal)))};return{init:function(contextid,cmid){return((contextid,cmid)=>("page-mod-contentdesigner-editor"!==document.body.id||(contextID=contextid,cmID=cmid,initEventListeners()),null))(contextid,cmid)}}}));

//# sourceMappingURL=editor.min.js.map