/**
 * Initializes event listeners and manages chapter completion and progress updates
 * for the content designer module. Handles user interactions such as completing
 * chapters and updating the progress bar. Supports both standard and popup formats.
 * Utilizes AJAX calls to update chapter completion status and refreshes content
 * accordingly. Ensures sticky progress bar behavior during scrolling.
 *
 * @module cdelement_chapter/chapter
 * @copyright  2024 bdecent gmbh <https://bdecent.de>
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("cdelement_chapter/chapter",["jquery","mod_contentdesigner/elements","core/ajax","core/fragment","core/templates","core/loadingicon","core/notification","core/str"],(function($,Elements,AJAX,Fragment,Templates,LoadingIcon,Notification,Str){let completionIcon,completionStr;const completeChapterListener=e=>{var completeCTA=e.target.closest("button.complete-chapter");if(null!=completeCTA){e.preventDefault();var chapter=completeCTA.dataset.chapterid;completeChapter(chapter,completeCTA).done((()=>{updateProgress(),completeCTA.classList.remove("btn-outline-secondary"),completeCTA.classList.add("btn-success"),completeCTA.innerHTML=completionIcon+" "+completionStr,Elements.removeWarning(),Elements.refreshContent();let chapterlist=e.target.closest(".chapters-list");chapterlist&&!chapterlist.classList.contains("completed")&&chapterlist.classList.add("completed")})).catch(Notification.exception)}},stickyProgress=function(){var progressElem=document.querySelector(".contentdesigner-progress"),contentWrapper=document.querySelector(".contentdesigner-content");null!=contentWrapper&&contentWrapper.getBoundingClientRect().top<50?(contentWrapper.classList.add("sticky-progress"),progressElem.classList.add("fixed-top")):(progressElem.classList.remove("fixed-top"),contentWrapper.classList.remove("sticky-progress"))},completeChapter=(chapter,button)=>{var promises=AJAX.call([{methodname:"cdelement_chapter_update_completion",args:{chapter:chapter,cmid:Elements.contentDesignerData().cmid}}]);return LoadingIcon.addIconToContainerRemoveOnCompletion(button,promises[0]),promises[0]},updateProgress=()=>{var params={cmid:Elements.contentDesignerData().cmid};Fragment.loadFragment("cdelement_chapter","update_progressbar",Elements.contentDesignerData().contextid,params).done(((html,js)=>{Templates.replaceNode("div#contentdesigner-progressbar",html,js)})).catch(Notification.exception)};return{init:function(){(()=>{Templates.renderPix("e/tick","core").done((function(img){completionIcon=img})),Str.get_string("completion_manual:done","course").done((str=>{completionStr=str})),document.body.removeEventListener("click",completeChapterListener),document.body.addEventListener("click",completeChapterListener),document.querySelector("#page").addEventListener("scroll",(()=>{stickyProgress()}));var popup=document.querySelector("body.format-popups .modal-content .modal-body");null!==popup&&popup.addEventListener("scroll",(()=>{stickyProgress()})),window.addEventListener("scroll",(()=>{stickyProgress()}))})()}}}));

//# sourceMappingURL=chapter.min.js.map