<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'Content designer', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package    mod_contentdesigner
 * @copyright  2024 bdecent gmbh <https://bdecent.de>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['abovecolorbg'] = "Background color/gradient (above)";
$string['abovecolorbg_help'] = 'Apply a gradient as the background for the element. You can create a smooth transition between two or more colors. Use either linear or radial gradients and specify the colors and direction for the gradient.<br>
<b>Gradient Example:</b>linear-gradient(#ff5733, #f1c40f) (This will create a gradient from red to yellow).<br>
<b>Color Example:</b> #ff5733 (This will set the background color of the element to a shade of red).';
$string['addelement'] = 'Insert Element';
$string['animationheading'] = "Entrance animation";
$string['animationtitle'] = 'Entrance Animation';
$string['backbehindelement'] = "Background behind element";
$string['backgroundtitle'] = "Background";
$string['belowcolorbg'] = "Background color/gradient (below)";
$string['belowcolorbg_help'] = 'Set the background color or gradient for the element. You can choose a single color or a gradient that smoothly transitions between two or more colors. The background color or gradient will be applied below the content area of the element.<br>
<b>Gradient Example:</b>linear-gradient(#ff5733, #f1c40f) (This will create a gradient from red to yellow).<br>
<b>Color Example:</b> #ff5733 (This will set the background color of the element to a shade of red).';
$string['chapterdone'] = 'Done';
$string['chaptertitle'] = "Chapter Title";
$string['completeprevelement'] = 'Complete the element above to continue.';
$string['completionby'] = 'Completed BY';
$string['completioncta'] = 'Complete chapter';
$string['completiondetail:reachend'] = 'Reach the end of the contents to complete';
$string['content'] = "Content";
$string['content_help'] = 'Enter the main text for this element. This content will be displayed as body text, ideal for providing details, descriptions, or supporting information within your content layout.';
$string['contentdesigner:addinstance'] = 'Add a new content designer';
$string['contentdesigner:view'] = 'View content designer activity';
$string['contentdesigner:viewcontenteditor'] = 'Access the content editor options';
$string['contenteditor'] = "Content editor";
$string['createchapter'] = "Create chapter";
$string['creategeneral'] = 'Create general';
$string['createnewelement'] = 'Create new element - Content Designer';
$string['deletechecktype'] = 'Are you sure that you want to delete this {$a->element} element?';
$string['disabled'] = 'Disabled';
$string['element:creategeneral'] = "Create a general element";
$string['element:viewgeneral'] = "View the general element";
$string['elementbgimage'] = "Background image";
$string['elementbgimage_help'] = 'Set a background image for the element. You can upload an image or provide a URL to an image. The image will be displayed behind the content of the element.';
$string['elementcreate'] = "Create element";
$string['elementsettings'] = '{$a} element settings';
$string['elementstrgeneralsettings'] = "Element general settings";
$string['elementtitle'] = "Title";
$string['elementtitle_help'] = 'Enter the title for the element. This title will only be displayed on the content editor page to help organize and identify the element within the editor. It will not appear on the final content page.';
$string['elementupdate'] = "Update element";
$string['enabled'] = 'Enabled';
$string['fadein'] = "Fade in";
$string['generaltitle'] = "General settings";
$string['gerneralsettings'] = "General settings";
$string['headingtext'] = "Heading text";
$string['headingtext_help'] = 'Enter the main text for your heading. This will be prominently displayed to guide users through the content or section.';
$string['headingurl'] = "Heading URL";
$string['headingurl_help'] = 'Enter a URL if you want to make the heading clickable. When users click on the heading, they will be redirected to the specified link. Leave blank if no link is needed.';
$string['hidden'] = "Hidden";
$string['hideondesktop'] = "Hide on desktop";
$string['hideondesktop_help'] = "Hide this element when viewed on a desktop screen.";
$string['hideonmobile'] = "Hide on mobile";
$string['hideonmobile_help'] = "Hide this element when viewed on a mobile screen.";
$string['hideontablet'] = "Hide on tablet";
$string['hideontablet_help'] = "Hide this element when viewed on a tablet screen.";
$string['horizontalalign'] = "Horizontal Alignment";
$string['horizontalalign_help'] = 'Choose the horizontal position for the text within the element:<br>
<b>Left:</b> Aligns the text to the left side.<br>
<b>Center:</b> Centers the text within the element.<br>
<b>Right:</b> Aligns the text to the right side.<br>
Selecting the alignment helps control the visual layout of your content.';
$string['invaildelement'] = "Invalid content designer element";
$string['invaildrecord'] = "Invaild record";
$string['learningtools'] = 'Learning Tools';
$string['learningtools_help'] = 'If enabled, learning tools such as bookmarks and notes will be available for this chapter.';
$string['mainheading'] = "Main heading (h2)";
$string['mandatory'] = "Mandatory";
$string['mandatory_help'] = 'Specify whether completing this element is required to unlock the next one:<br>
<b>Yes:</b> The user must complete this element before the next one is displayed.<br>
<b>No:</b> The next element is available regardless of whether this one is completed.<br>
This setting is useful for creating a sequential flow, guiding users through the content step-by-step.';
$string['margin'] = "Margin";
$string['margin_help'] = 'Margin controls the space outside the element, creating distance between it and other elements. Set a single value to apply the same margin on all sides of the element.<br> <b>Example:</b> 10px (This will apply a 10px margin on all four sides: top, right, bottom, and left).';
$string['modulename'] = 'Content Designer';
$string['modulenameplural'] = "Content Designers";
$string['newvalue'] = 'New value for';
$string['outro:btnbacktocourse'] = 'Back to course';
$string['outro:btnbacktosection'] = 'Back to section';
$string['outro:btncustom'] = 'Custom';
$string['outro:btnnext'] = 'Next';
$string['padding'] = "Padding";
$string['padding_help'] = 'Padding controls the space inside the element, between the content and its borders. Set a single value to apply the same padding on all sides of the element.<br><b>Example:</b> 10px (This will apply a 10px padding on all four sides: top, right, bottom, and left).';
$string['pluginadministration'] = 'Content designer administration';
$string['pluginname'] = 'Content Designer';
$string['primarybutton'] = 'Primary button';
$string['primarybutton_help'] = '<b>Primary Button</b><br>
<b>Disabled:</b> The primary button is hidden by default.<br>
<b>Custom:</b> Displays a primary button where you can enter custom text and a URL.<br>
<b>Next:</b> Displays a "Next" button that links to the next activity in the course sequence.<br>
<b>Back to Course:</b> Displays a button that redirects to the course overview page.<br>
<b>Back to Section:</b> Displays a button that links back to the current activity\'s section within the course.';
$string['primarybuttontext'] = "primary button text";
$string['primarybuttontext_help'] = "Enter the text that will appear on the primary button. This button typically represents the main action, such as 'Continue', 'Next', or 'Submit'.";
$string['primarybuttonurl'] = "primary button URL";
$string['primarybuttonurl_help'] = 'Enter the URL the primary button will link to when clicked. This can be a link to another page, an external website, or another section within the content.';

$string['responsiveheading'] = "Responsive";
$string['responsivetitle'] = 'Responsive settings';
$string['richtext'] = "Rich Text";
$string['richtext_help'] = "Use the rich text editor to add and format content with full styling options, including text formatting, lists, links, and media. This editor supports file uploads, so you can include images, videos, and other media to enhance your content.";
$string['scrolleffectsheading'] = "Scrolling effects (horizontal)";
$string['scrollingeffectstitle'] = 'Scrolling Effects';
$string['secondarybutton'] = 'Secondary button';
$string['secondarybutton_help'] = '<b>Secondary Button</b><br>
<b>Disabled:</b> The secondary button is hidden by default.<br>
<b>Custom:</b> Displays a secondary button where you can enter custom text and a URL.<br>
<b>Next:</b> Displays a "Next" button that links to the next activity in the course sequence.<br>
<b>Back to Course:</b> Displays a button that redirects to the course overview page.<br>
<b>Back to Section:</b> Displays a button that links back to the current activity\'s section within the course.';
$string['secondarybuttontext'] = "Secondary button text";
$string['secondarybuttontext_help'] = "Enter the text for the secondary button. This button is typically used for alternative actions, such as 'Cancel', 'Back', or 'Skip'. Choose a label that clearly indicates the secondary action.";
$string['secondarybuttonurl'] = "Secondary button URL";
$string['secondarybuttonurl_help'] = 'Enter the URL the secondary button will link to when clicked. This could direct users to an alternative action or page.';
$string['slidefromleft'] = "Slide in from left";
$string['slidefromright'] = "Slide in from right";
$string['speed'] = "Speed";
$string['speed_help'] = 'Set the speed of the scrolling effect. This controls how fast or slow the element will move as the user scrolls the page.<br>Example: Set 1 for a slower scroll';
$string['stranimation'] = "Animation";
$string['stranimation_help'] = "Choose an entrance animation for the element. This animation will play when the element first appears on the screen as the user scrolls into view or interacts with the content.<br>Select <b>None</b> if you don't want any animation effect for the element";
$string['strblank'] = "Open a new window";
$string['strbookmark'] = "Bookmark";
$string['strbookmarked'] = "Bookmarked";
$string['strbottom'] = "Bottom";
$string['strcenter'] = "Center";
$string['strdelay'] = "Delay";
$string['strdelay_help'] = 'Set a delay before the entrance animation begins. This setting defines how much time should pass before the animation starts after the element comes into view.<br>Example: Set 2 (2 seconds delay).';
$string['strdirection'] = "Direction";
$string['strdirection_help'] = 'Apply scrolling effects to your element, making it move as the user scrolls through the page. These effects can help create dynamic interactions and draw attention to key content.<br><b>None: </b>No scrolling effect applied. The element will remain stationary as the user scrolls.<br><b>To Left: </b>The element will move from right to left as the user scrolls down the page.<br><b>To Right: </b>The element will move from left to right as the user scrolls down the page.';
$string['strduration'] = "Duration";
$string['strduration_help'] = 'Choose the speed at which the entrance animation will occur. This setting determines how quickly or slowly the animation will play, adding different levels of emphasis and pacing.';
$string['strfast'] = "Fast";
$string['strheading'] = "Heading";
$string['strheading_help'] = 'Choose the type of heading to display. You have two options:<br>
<b>Main Heading (H2):</b> A larger, prominent heading typically used for main sections or titles.<br>
<b>Sub Heading (H3):</b> A slightly smaller heading used for subsections or supporting information within a main section.
Selecting the right heading type helps organize content and improves readability."';
$string['strimage'] = "Image";
$string['strimage_help'] = 'Upload an image to display in the outro section. This image will appear at the end of the content, adding a visual element to enhance the closing message or theme.';
$string['strleft'] = "Left";
$string['strmiddle'] = "Middle";
$string['strnormal'] = "Normal";
$string['strnotes'] = "Notes";
$string['strright'] = "Right";
$string['strself'] = "Open a same window";
$string['strslow'] = "Slow";
$string['strtop'] = "Top";
$string['subheading'] = "Sub heading (h3)";
$string['subplugintype_cdelement'] = 'Element plugin';
$string['subplugintype_cdelement_plural'] = 'Element plugins';
$string['target'] = "Target";
$string['target_help'] = 'Select how the link should open if a Heading URL is provided:<br>
<b>Same Window:</b> Opens the link in the current browser tab, replacing the current page.<br>
<b>New Window:</b> Opens the link in a new browser tab, keeping the current page open.
Choose ‘New Window’ if you want users to keep this page open while viewing the link.';
$string['titleeditable'] = 'Edit instance title';
$string['titlestatus'] = 'Display title';
$string['titlestatus_help'] = 'Enable this option to display the chapter\'s title to learners. When unchecked, the title will only be used for administrative purposes and will not be visible to learners. Checking this option makes the chapter title visible on the learner\'s view.';
$string['toleft'] = "To left";
$string['toright'] = "To Right";
$string['verticalalign'] = "Vertical Alignment";
$string['verticalalign_help'] = 'Select the vertical position of the text within the element:<br>
<b>Top:</b> Aligns the text to the top of the element.<br>
<b>Middle:</b> Centers the text vertically within the element.<br>
<b>Bottom:</b> Aligns the text to the bottom of the element.<br>
This setting is useful for fine-tuning the text position within your design layout.';
$string['viewport'] = "Viewport";
$string['viewport_help'] = 'Define when the scrolling effect should start relative to the user\'s viewport. This helps control how soon the effect is triggered based on how much of the element is visible on the screen.';
$string['visibility'] = "Visibility";
$string['visibility_help'] = "Show / Hide the element";

$string['learningtools'] = 'Learning Tools';
$string['learningtools_help'] = 'If enabled, learning tools such as bookmarks and notes will be available for this chapter.';
$string['enabled'] = 'Enabled';
$string['disabled'] = 'Disabled';
$string['strbookmark'] = "Bookmark";
$string['strnotes'] = "Notes";
$string['strbookmarked'] = "Bookmarked";
