# Content Designer

Create engaging and interactive content, directly in your Moodle course. Content Designer is developed specifically for instructional designers and collaborative content creation. The architecture of Content Designer was inspired by content management systems and built around the workflow of instructional designer: starting with a high-level concept, then broken down into individual elements and then adding content for each part of the concept. Content Designer�s chapter structure allows simultaneous collaborative editing of contents. 

In Content Designer, content is organised in chapters. Chapters then contain elements, such as headings, paragraphs or rich text. Each element comes with customization options for appearance, animations and responsiveness. Elements can be styled globally according to their type to match the organization�s branding guidelines and create a visually appealing look. This architecture makes it much easier to maintain a consistent look and feel. At the same time, content creation is easier and faster. The separation of content, layout and style is perfectly suited for quality management tasks and corporate design compliance.

At the end of each activity, the outro element visually indicates the end of the activity. This event is also used to trigger activity completion.

The dedicated h5p element gives teachers a great way to incorporate interactions into their content. For many content types, students can be required to complete the interaction before they can proceed.


# Requirements

This plugin requires Moodle 3.9

# Motivation for this plugin

Content designer simplifies mobile first content authoring, improves productivity with collaborative workflows, saves cost for authoring solutions and speeds up development.

# Installation

Install the plugin like any other plugin to folder /mod/contentdesigner
See http://docs.moodle.org/en/Installing_plugins for details on installing Moodle plugins

# Quick start guide

No setup up steps are required for administrators.

Teachers (or users with the permission to edit courses) can add a new content designer activity like any other activity. Then, navigate to the editor tab in the secondary navigation to start adding content.

# Documentation

(NOT AVAILABLE YET, WILL BE PUBLISHED BY THE END OF 2024)
Please refer to the documentation for more information: https://github.com/bdecentgmbh/moodle-mod_contentdesigner/wiki

# Theme support

This plugin is developed and tested on Moodle Core's Boost theme. It should also work with Boost child themes, including Moodle Core's Classic theme. However, we can't support any other theme than Boost.

# Plugin repositories

This plugin will be published and regularly updated in the Moodle plugins repository: https://moodle.org/plugins/mod_contentdesigner
The latest development version can be found on Github: https://github.com/bdecentgmbh/moodle-mod_contentdesigner

# Bug and problem reports / Support requests

This plugin is carefully developed and thoroughly tested, but bugs and problems can always appear. Please report bugs and problems on Github: https://github.com/bdecentgmbh/moodle-mod_contentdesigner/issues We will do our best to solve your problems, but please note that due to limited resources we can't always provide per-case support.

# Feature proposals

Please issue feature proposals on Github: https://github.com/bdecentgmbh/moodle-mod_contentdesigner/issues Please create pull requests on Github: https://github.com/bdecentgmbh/moodle-mod_contentdesigner/pulls We are always interested to read about your feature proposals or even get a pull request from you, but please accept that we can handle your issues only as feature proposals and not as feature requests.

# Moodle release support

This plugin is maintained for the two most recent major releases of Moodle as well as the most recent LTS release of Moodle. If you are running a legacy version of Moodle, but want or need to run the latest version of this plugin, you can get the latest version of the plugin, remove the line starting with $plugin->requires from version.php and use this latest plugin version then on your legacy Moodle. However, please note that you will run this setup completely at your own risk. We can't support this approach in any way and there is an undeniable risk for erratic behavior.

# Translating this plugin

This Moodle plugin is shipped with an english language pack only. All translations into other languages must be managed through AMOS (https://lang.moodle.org) by what they will become part of Moodle's official language pack.

# Copyright

bdecent gmbh
bdecent.de
