/**
 * Module for managing content designer elements and animations.
 *
 * This module defines various functions and constants to handle the loading,
 * refreshing, and animating of content designer elements within a course.
 * It utilizes organization-specific modules for fragment loading and template
 * manipulation, and includes features such as entrance animations and scrolling
 * effects for elements in the viewport.
 *
 * @module mod_contentdesigner/editor
 * @copyright  2024 bdecent gmbh <https://bdecent.de>
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_contentdesigner/elements",["jquery","core/fragment","core/templates","core/loadingicon","core/notification","mod_contentdesigner/anime"],(function($,Fragment,Templates,LoadingIcon,Notification,anime){const SELECTORS={chapter:'[data-elementshortname="chapter"]',chapterList:".chapter-elements-list",elementContent:".element-content",fragments:{nextContents:"load_remain_capter_contents"},contentWrapper:".contentdesigner-wrapper"};function contentDesignerElementsData(cmID,contextID,contentdesignerID){return{cmid:cmID,contextid:contextID,contentdesignerid:contentdesignerID}}const contentDesignerData=()=>{var cmdetails=null!==document.querySelector("input[name=contentdesigner_cm_details]")?document.querySelector("input[name=contentdesigner_cm_details]").value:"";return(cmdetails?JSON.parse(cmdetails):"")||contentDesignerElementsData()};let animations={},button=()=>document.querySelector(".contentdesigner-content"),courseContent=()=>document.querySelector("ul.course-content-list");const removeMarkBtn=chapterSelector=>{null!=document.querySelector(chapterSelector).querySelector(".toolbar-block")&&document.querySelector(chapterSelector).querySelector(".toolbar-block").remove()},animateElements=function(){var leftFrame,rightFrame,fadeIn;leftFrame=[{transform:"translate3d(-100%, 0, 0)"},{transform:"translate3d(0, 0, 0)",opacity:1}],rightFrame=[{transform:"translate3d(100%, 0, 0)"},{transform:"translate3d(10%, 0, 0)",opacity:1}],fadeIn=[{opacity:0},{opacity:1}],document.querySelectorAll(".element-item .general-options.animation").forEach((item=>{var node=item;if(null==node.dataset.entranceanimation||""==node.dataset.entranceanimation)return;var data=JSON.parse(node.dataset.entranceanimation),speed=1500;"slow"==data.duration?speed=3e3:"fast"==data.duration&&(speed=500);const observer=new IntersectionObserver((entries=>{entries.forEach((entry=>{if(entry.isIntersecting){if((node=entry.target).classList.contains("animated"))return;var frame=fadeIn;"slideInLeft"==data.animation?frame=leftFrame:"slideInRight"==data.animation&&(frame=rightFrame),setTimeout((function(){node.classList.add("animated"),item.animate(frame,{duration:speed||1e3})}),data.delay),observer.unobserve(item)}}))}));observer.observe(item)})),document.querySelectorAll(".element-item").forEach((function(item){!function(item){var node=item.childNodes[1];if(null!=node.dataset.scrolleffect&&""!=node.dataset.scrolleffect){var id=node.dataset.contentid,data=JSON.parse(node.dataset.scrolleffect),speed=data.speed?1e4/data.speed:0;animations[id]=anime({targets:item.childNodes[1],translateX:"left"==data.direction?[800,0]:[-800,0],duration:speed||500,autoplay:!1,elasticity:0,easing:"easeInOutSine"}),document.getElementById("page").addEventListener("scroll",(function(){document.getElementById("page").style.overflow="visible";var scroll=animateOnScroll(item,animations[id].duration);animations[id].seek(scroll)})),window.addEventListener("scroll",(function(){var scroll=animateOnScroll(item,animations[id].duration);animations[id].seek(scroll)}));var modalBody=document.querySelector(".path-course-view .modal-dialog-scrollable .modal-body");null!==modalBody&&modalBody.addEventListener("scroll",(function(e){var scroll=animateOnScroll(item,animations[id].duration,e.target);animations[id].seek(scroll)})),window.addEventListener("load",(function(){setTimeout((function(){document.getElementById("page").style.overflow="visible"}),500);var scroll=animateOnScroll(item,animations[id].duration);animations[id].seek(scroll)})),document.getElementById("page").style.overflow="visible"}}(item)}))};const animateOnScroll=function(item,dataspeed){let scrollElement=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;var node=item.childNodes[1];if(null==node.dataset.scrolleffect||""==node.dataset.scrolleffect)return;var data=JSON.parse(node.dataset.scrolleffect);let start=parseInt(data.start)||100,end=200;const docElement=scrollElement||document.documentElement;let clientHeight=docElement.clientHeight,itemY=()=>item.getBoundingClientRect().y,itemTop=()=>item.getBoundingClientRect().top-end,isStartPosition=()=>itemY()+start<=docElement.clientHeight,isEndPosition=()=>itemY()<=end;if(isStartPosition()&&!isEndPosition()){var ls=docElement.scrollHeight-(docElement.clientHeight+docElement.scrollTop),availablescroll=Math.min(clientHeight-(end+start),ls),scrolled=availablescroll>itemTop()?availablescroll-itemTop():item.offsetTop-end-itemTop()-availablescroll,percent=dataspeed/availablescroll,speed=scrolled*percent;return speed}};return{data:contentDesignerData,contentDesignerData:contentDesignerData,refreshContent:()=>{var params={cmid:contentDesignerData().cmid},promise=Fragment.loadFragment("mod_contentdesigner","load_elements",contentDesignerData().contextid,params);promise.done(((html,js)=>{var fakeDiv=document.createElement("div");fakeDiv.innerHTML=html;var chapters=fakeDiv.querySelector(".course-content-list").children,filterChapter=[];chapters.forEach((chapter=>{var elementSelector='li.element-item[data-instanceid="'+chapter.dataset.instanceid+'"]';elementSelector+='[data-elementshortname="'+chapter.dataset.elementshortname+'"]';let chapterSelector='li.chapters-list[data-id="'+chapter.dataset.id+'"]';var _chapter$querySelecto;document.querySelector(chapterSelector)||document.querySelector(elementSelector)?((null!==(_chapter$querySelecto=chapter.querySelectorAll(".element-item"))&&void 0!==_chapter$querySelecto?_chapter$querySelecto:[]).forEach((element=>{var dataset=element.children[0].dataset,selector='li.element-item .element-content[data-instanceid="'+dataset.instanceid+'"]';selector+='[data-elementshortname="'+dataset.elementshortname+'"]';var elementindocument=document.querySelector(selector);document.querySelector(selector)||void 0===document.querySelector(chapterSelector+" .chapter-elements-list")?null!==elementindocument&&1==elementindocument.dataset.replaceonrefresh&&Templates.replaceNode(elementindocument,element,""):document.querySelector(chapterSelector+" .chapter-elements-list").appendChild(element)})),null!==chapter.querySelector(".chapter-elements-list")&&chapter.querySelector(".chapter-elements-list").remove(),null!==chapter.querySelector(".chapter-title")&&chapter.querySelector(".chapter-title").remove(),chapter.children.length>0&&null!=document.querySelector(chapterSelector)&&(removeMarkBtn(chapterSelector),document.querySelector(chapterSelector).append(chapter.children[0]))):filterChapter.push(chapter)})),Templates.appendNodeContents(".contentdesigner-content .course-content-list",filterChapter,js),animateElements(),document.querySelector(SELECTORS.contentWrapper).dispatchEvent(new CustomEvent("elementupdate"))})).catch((error=>Notification.exception(error))),LoadingIcon.addIconToContainerRemoveOnCompletion(button(),promise)},loadNextChapters:function(currentChapter){var params={cmid:contentDesignerData().cmid,chapter:currentChapter},promise=Fragment.loadFragment("mod_contentdesigner","load_next_chapters",contentDesignerData().contextid,params);promise.done(((html,js)=>{var fakeDiv=document.createElement("div");fakeDiv.innerHTML=html;var chapters=fakeDiv.querySelector(".course-content-list").children,filterChapter=[];chapters.forEach((chapter=>{var elementSelector='li.element-item[data-instanceid="'+chapter.dataset.instanceid+'"]';elementSelector+='[data-elementshortname="'+chapter.dataset.elementshortname+'"]',document.querySelector('li.chapters-list[data-id="'+chapter.dataset.id+'"]')||document.querySelector(elementSelector)||filterChapter.push(chapter)})),Templates.appendNodeContents(".contentdesigner-content .course-content-list",filterChapter,js),animateElements()})).catch((error=>Notification.exception(error))),LoadingIcon.addIconToContainerRemoveOnCompletion(button(),promise)},inView:function(el){const rect=el.getBoundingClientRect();return rect.top>=0&&rect.left>=0&&rect.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&rect.right<=(window.innerWidth||document.documentElement.clientWidth)},animateElements:animateElements,courseContent:courseContent,removeWarning:()=>{null!==courseContent()&&null!==courseContent().querySelector(".label.label-warning")&&courseContent().querySelector(".label.label-warning").remove()},loadNextElements:function(currentElement){Fragment.loadFragment("mod_contentdesigner",SELECTORS.fragments.nextContents,contentDesignerData().contextid,{contentid:currentElement.dataset.contentid}).done(((html,js)=>{const selector=currentElement.parentNode.parentNode;Templates.appendNodeContents(selector,html,js)}))},contentDesignerElementsData:contentDesignerElementsData,selectors:SELECTORS}}));

//# sourceMappingURL=elements.min.js.map